/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.GenericHomeGenerator;
import com.sun.ejb.codegen.Remote30WrapperGenerator;
import com.sun.ejb.codegen.RemoteGenerator;
import com.sun.ejb.codegen.ServiceInterfaceGenerator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Wrapper;

public class EjbClassGeneratorFactory
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(EjbClassGeneratorFactory.class.getName());
    private final ClassLoader loader;

    public EjbClassGeneratorFactory(ClassLoader loader) {
        this.loader = loader;
        Wrapper._setClassLoader((ClassLoader)loader);
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    public Class<?> ensureGenericHome(Class<?> anchorClass) throws GeneratorException {
        GenericHomeGenerator generator = new GenericHomeGenerator(this.loader, anchorClass);
        Class<?> clazz = EjbClassGeneratorFactory.loadClassIgnoringExceptions(this.loader, generator.getGeneratedClassName());
        if (clazz != null) {
            return clazz;
        }
        return this.generate(generator);
    }

    public Class<?> ensureServiceInterface(Class<?> ejbClass) throws GeneratorException {
        ServiceInterfaceGenerator generator = new ServiceInterfaceGenerator(this.loader, ejbClass);
        Class<?> clazz = EjbClassGeneratorFactory.loadClassIgnoringExceptions(this.loader, generator.getGeneratedClassName());
        if (clazz != null) {
            return clazz;
        }
        return this.generate(generator);
    }

    public Class<?> ensureRemote(String businessInterfaceName) throws GeneratorException {
        Class<?> remoteIntf;
        Generator generator;
        String generatedRemoteIntfName = RemoteGenerator.getGeneratedRemoteIntfName(businessInterfaceName);
        String wrapperClassName = Remote30WrapperGenerator.getGeneratedRemoteWrapperName(businessInterfaceName);
        Class<?> foundRemoteIntf = EjbClassGeneratorFactory.loadClassIgnoringExceptions(this.loader, generatedRemoteIntfName);
        Class<?> foundRemoteWrapper = EjbClassGeneratorFactory.loadClassIgnoringExceptions(this.loader, wrapperClassName);
        if (foundRemoteIntf != null && foundRemoteWrapper != null) {
            return foundRemoteIntf;
        }
        if (foundRemoteIntf == null) {
            generator = new RemoteGenerator(this.loader, businessInterfaceName);
            remoteIntf = this.generate(generator);
        } else {
            remoteIntf = foundRemoteIntf;
        }
        if (foundRemoteWrapper == null) {
            generator = new Remote30WrapperGenerator(this.loader, businessInterfaceName, generatedRemoteIntfName);
            this.generate(generator);
        }
        return remoteIntf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> generate(Generator generator) throws GeneratorException {
        ClassLoader classLoader = this.loader;
        synchronized (classLoader) {
            Wrapper._clear();
            Class<?> clazz = EjbClassGeneratorFactory.loadClassIgnoringExceptions(this.loader, generator.getGeneratedClassName());
            if (clazz != null) {
                return clazz;
            }
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
                Class<?> generatedClass = generator.generate();
                LOG.log(Level.CONFIG, "Generated class: {0} by generator: {1}", new Object[]{generatedClass, generator});
                Objects.requireNonNull(Type.type(generatedClass));
                Class<?> clazz2 = generatedClass;
                return clazz2;
            }
            catch (IllegalAccessException | RuntimeException e) {
                throw new GeneratorException("Generator failed: " + generator, e);
            }
            finally {
                Wrapper._clear();
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
    }

    @Override
    public void close() {
        Wrapper._setClassLoader(null);
    }

    private static Class<?> loadClassIgnoringExceptions(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.FINE, "Could not load class: " + className + " by classloader " + classLoader, e);
            return null;
        }
    }
}

