/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.hk2;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;

public class HK2CDIBean<T>
implements Bean<T> {
    private final ServiceLocator locator;
    private final ActiveDescriptor<T> descriptor;

    HK2CDIBean(ServiceLocator serviceLocator, ActiveDescriptor<T> descriptor) {
        this.locator = serviceLocator;
        this.descriptor = descriptor;
    }

    public T create(CreationalContext<T> arg0) {
        ServiceHandle serviceHandle = this.locator.getServiceHandle(this.descriptor);
        return (T)serviceHandle.getService();
    }

    public void destroy(T arg0, CreationalContext<T> arg1) {
        this.descriptor.dispose(arg0);
    }

    public Class<?> getBeanClass() {
        return this.descriptor.getImplementationClass();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public Set<Annotation> getQualifiers() {
        if (this.descriptor.getQualifierAnnotations().isEmpty()) {
            return Set.of(Default.Literal.INSTANCE);
        }
        return this.descriptor.getQualifierAnnotations();
    }

    public Class<? extends Annotation> getScope() {
        Class<Dependent> scope = this.descriptor.getScopeAnnotation();
        if (scope == null || scope.equals(PerLookup.class)) {
            scope = Dependent.class;
        }
        return scope;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return this.descriptor.getContractTypes();
    }

    public boolean isAlternative() {
        return false;
    }

    public ActiveDescriptor<T> getHK2Descriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "HK2CDIBean(" + this.descriptor + "," + System.identityHashCode(this) + ")";
    }
}

