/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.store;

import com.sun.enterprise.security.store.AsadminSecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class AsadminTruststore {
    private static final String ASADMIN_TRUSTSTORE = "truststore";
    private KeyStore _keyStore;
    private File _keyFile;
    private char[] _password;

    public static File getAsadminTruststore() {
        String location = System.getProperty("javax.net.ssl.trustStore");
        if (location == null) {
            return new File(AsadminSecurityUtil.GF_CLIENT_DIR, ASADMIN_TRUSTSTORE);
        }
        return new File(location);
    }

    public static AsadminTruststore newInstance() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        return AsadminSecurityUtil.getInstance(true).getAsadminTruststore();
    }

    public static AsadminTruststore newInstance(char[] password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        return AsadminSecurityUtil.getInstance(password, true).getAsadminTruststore();
    }

    AsadminTruststore(char[] password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this.init(AsadminTruststore.getAsadminTruststore(), password);
    }

    private void init(File keyfile, char[] password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this._keyFile = keyfile;
        this._keyStore = KeyStore.getInstance("JKS");
        this._password = password;
        if (!this._keyFile.exists()) {
            this._keyStore.load(null, null);
            return;
        }
        try (BufferedInputStream bInput = new BufferedInputStream(new FileInputStream(this._keyFile));){
            this._keyStore.load(bInput, this._password);
        }
    }

    public boolean certificateExists(Certificate cert) throws KeyStoreException {
        return this._keyStore.getCertificateAlias(cert) != null;
    }

    public void addCertificate(String alias, Certificate cert) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this._keyStore.setCertificateEntry(alias, cert);
        this.writeStore();
    }

    public void writeStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (BufferedOutputStream boutput = new BufferedOutputStream(new FileOutputStream(this._keyFile));){
            this._keyStore.store(boutput, this._password);
        }
    }
}

