/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.MethodPermissionDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.security.common.Role;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class MethodPermissionNode
extends DeploymentDescriptorNode<MethodPermissionDescriptor> {
    private MethodPermissionDescriptor descriptor;

    public MethodPermissionNode() {
        this.registerElementHandler(new XMLElement("method"), MethodNode.class, "addMethod");
    }

    public MethodPermissionDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new MethodPermissionDescriptor();
        }
        return this.descriptor;
    }

    public void startElement(XMLElement element, Attributes attributes) {
        if ("unchecked".equals(element.getQName())) {
            this.descriptor.addMethodPermission(MethodPermission.getPermitAllMethodPermission());
        } else {
            super.startElement(element, attributes);
        }
    }

    public void setElementValue(XMLElement element, String value) {
        if ("role-name".equals(element.getQName())) {
            Role role = new Role(value);
            this.descriptor.addMethodPermission(new MethodPermission(role));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, MethodPermissionDescriptor descriptor, EjbDescriptor ejb) {
        Node subNode = super.writeDescriptor(parent, nodeName, (Descriptor)descriptor);
        return this.writeDescriptorInNode(subNode, descriptor, ejb);
    }

    public Node writeDescriptorInNode(Node subNode, MethodPermissionDescriptor descriptor, EjbDescriptor ejb) {
        MethodPermissionNode.writeLocalizedDescriptions((Node)subNode, (Descriptor)descriptor);
        MethodPermission[] mps = descriptor.getMethodPermissions();
        if (mps.length == 0) {
            return null;
        }
        if (!mps[0].isExcluded()) {
            if (mps[0].isUnchecked()) {
                MethodPermissionNode.appendChild((Node)subNode, (String)"unchecked");
            } else {
                for (MethodPermission mp : mps) {
                    MethodPermissionNode.appendTextChild((Node)subNode, (String)"role-name", (String)mp.getRole().getName());
                }
            }
        }
        MethodDescriptor[] methods = descriptor.getMethods();
        MethodNode mn = new MethodNode();
        for (MethodDescriptor method : methods) {
            String ejbName = ejb.getName();
            mn.writeDescriptor(subNode, "method", method, ejbName);
        }
        return subNode;
    }
}

