/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.timer;

import com.sun.messaging.jmq.util.timer.TimerEventHandler;

public class WakeupableTimer
implements Runnable {
    private static boolean DEBUG = false;
    private String name = null;
    private long mynexttime = 0L;
    private long nexttime = 0L;
    private long repeatinterval = 0L;
    private Thread thr = null;
    private boolean valid = true;
    private boolean wakeup = false;
    private String startString = null;
    private String exitString = null;
    private TimerEventHandler handler = null;

    public WakeupableTimer(String name, TimerEventHandler handler, long delaytime, long repeatInterval, String startString, String exitString) {
        this.name = name;
        this.mynexttime = delaytime + System.currentTimeMillis();
        this.repeatinterval = repeatInterval;
        this.startString = startString;
        this.exitString = exitString;
        this.handler = handler;
        this.thr = new Thread((Runnable)this, name);
        this.thr.start();
    }

    public boolean isTimerThread(Thread t) {
        if (this.thr == null) {
            return false;
        }
        return t == this.thr;
    }

    public synchronized void wakeup() {
        this.wakeup = true;
        this.notifyAll();
    }

    public synchronized void wakeup(long time) {
        this.nexttime = time;
        this.wakeup = true;
        this.notifyAll();
    }

    public void cancel() {
        this.valid = false;
        this.wakeup();
        this.thr.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.handler.handleLogInfo(this.startString);
            long time = System.currentTimeMillis();
            long waittime = this.mynexttime - time;
            if (waittime < 0L) {
                waittime = 0L;
            }
            boolean nowaitOn0 = true;
            while (this.valid) {
                try {
                    WakeupableTimer wakeupableTimer = this;
                    synchronized (wakeupableTimer) {
                        while (!(!this.valid || this.wakeup || waittime == 0L && nowaitOn0)) {
                            if (DEBUG) {
                                this.handler.handleLogInfo(this.name + " run(): before wait(" + waittime + "), valid=" + this.valid + ", wakeup=" + this.wakeup + ", nowaitOn0=" + nowaitOn0);
                            }
                            if (nowaitOn0) {
                                nowaitOn0 = false;
                            }
                            try {
                                this.wait(waittime);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!this.valid || this.wakeup || waittime == 0L || (waittime = this.mynexttime - (time = System.currentTimeMillis())) > 0L) continue;
                            waittime = 0L;
                            if (this.repeatinterval <= 0L) break;
                            waittime = this.repeatinterval;
                            break;
                        }
                        if (!this.valid) {
                            break;
                        }
                        this.wakeup = false;
                    }
                    if (DEBUG) {
                        this.handler.handleLogInfo(this.name + " runTask " + this.handler.getClass().getName());
                    }
                    boolean asrequested = false;
                    this.mynexttime = this.handler.runTask();
                    if (this.mynexttime > 0L) {
                        nowaitOn0 = true;
                        asrequested = true;
                    }
                    if (DEBUG) {
                        this.handler.handleLogInfo(this.name + " completed run " + this.handler.getClass().getName() + " with return " + this.mynexttime);
                    }
                    time = System.currentTimeMillis();
                    if (this.mynexttime == 0L) {
                        this.mynexttime = time + this.repeatinterval;
                    }
                    WakeupableTimer wakeupableTimer2 = this;
                    synchronized (wakeupableTimer2) {
                        if (DEBUG) {
                            this.handler.handleLogInfo(this.name + " run() after runTask(), nexttime=" + this.nexttime + ", mynexttime=" + this.mynexttime + ", time=" + time);
                        }
                        if (this.nexttime > 0L && this.nexttime < this.mynexttime) {
                            this.mynexttime = this.nexttime;
                            nowaitOn0 = true;
                            asrequested = true;
                        }
                        this.nexttime = 0L;
                    }
                    waittime = this.mynexttime - time;
                    if (waittime < 0L) {
                        waittime = 0L;
                    }
                    if (waittime != 0L || asrequested) continue;
                    nowaitOn0 = false;
                }
                catch (Throwable e) {
                    this.handler.handleLogWarn(e.getMessage(), e);
                    if (!(e instanceof OutOfMemoryError)) continue;
                    this.handler.handleOOMError(e);
                }
            }
            this.handler.handleLogInfo(this.exitString);
        }
        catch (Throwable t) {
            this.handler.handleLogError(this.exitString, t);
            this.handler.handleTimerExit(t);
        }
    }
}

