/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.impl.FelixCapabilityAdapter;
import org.apache.felix.bundlerepository.impl.NamespaceTranslator;
import org.apache.felix.bundlerepository.impl.OSGiResourceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OSGiRequirementAdapter
implements Requirement {
    private final org.osgi.resource.Requirement requirement;
    private final HashMap<String, String> cleanedDirectives;
    private final String filter;

    public OSGiRequirementAdapter(org.osgi.resource.Requirement requirement) {
        this.requirement = requirement;
        String f = (String)requirement.getDirectives().get("filter");
        if (f != null) {
            for (String ns : NamespaceTranslator.getTranslatedOSGiNamespaces()) {
                f = f.replaceAll("[(][ ]*" + ns + "[ ]*=", "(" + NamespaceTranslator.getFelixNamespace(ns) + "=");
            }
        }
        this.filter = f;
        this.cleanedDirectives = new HashMap(requirement.getDirectives());
        this.cleanedDirectives.remove("filter");
        this.cleanedDirectives.remove("cardinality");
        this.cleanedDirectives.remove("resolution");
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.requirement.getAttributes();
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.cleanedDirectives;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public String getName() {
        return NamespaceTranslator.getFelixNamespace(this.requirement.getNamespace());
    }

    @Override
    public boolean isExtend() {
        return false;
    }

    @Override
    public boolean isMultiple() {
        String multiple = (String)this.requirement.getDirectives().get("cardinality");
        return "multiple".equals(multiple);
    }

    @Override
    public boolean isOptional() {
        String resolution = (String)this.requirement.getDirectives().get("resolution");
        return "optional".equals(resolution);
    }

    @Override
    public boolean isSatisfied(Capability capability) {
        boolean result = OSGiResourceHelper.matches(this.requirement, new FelixCapabilityAdapter(capability, null));
        return result;
    }
}

