/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.TransactionHandleImpl;
import org.glassfish.concurro.spi.TransactionHandle;
import org.glassfish.concurro.spi.TransactionSetupProvider;

public class TransactionSetupProviderImpl
implements TransactionSetupProvider {
    private static final long serialVersionUID = 2278968807330359713L;
    private transient JavaEETransactionManager transactionManager;
    private final boolean keepTransactionUnchanged;
    private final boolean clearTransaction;

    public TransactionSetupProviderImpl(JavaEETransactionManager transactionManager, boolean keepTransactionUnchanged, boolean clearTransaction) {
        this.transactionManager = transactionManager;
        this.keepTransactionUnchanged = keepTransactionUnchanged;
        this.clearTransaction = clearTransaction;
    }

    public TransactionHandle beforeProxyMethod(String transactionExecutionProperty) {
        if (this.keepTransactionUnchanged) {
            return null;
        }
        if (!this.clearTransaction && "USE_TRANSACTION_OF_EXECUTION_THREAD".equals(transactionExecutionProperty)) {
            return null;
        }
        try {
            Transaction suspendedTxn = this.transactionManager.suspend();
            return new TransactionHandleImpl(suspendedTxn);
        }
        catch (SystemException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "", e);
            return null;
        }
    }

    public void afterProxyMethod(TransactionHandle handle, String transactionExecutionProperty) {
        Transaction suspendedTxn;
        if (handle instanceof TransactionHandleImpl && (suspendedTxn = ((TransactionHandleImpl)handle).getTransaction()) != null) {
            try {
                this.transactionManager.resume(suspendedTxn);
            }
            catch (InvalidTransactionException | SystemException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        ConcurrentRuntime concurrentRuntime = ConcurrentRuntime.getRuntime();
        this.transactionManager = concurrentRuntime.getTransactionManager();
    }
}

