/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class ThemeServlet
extends HttpServlet {
    private static final long serialVersionUID = -8112024913542109274L;
    private static final boolean DEBUG = false;
    private final long lastModified = new Date().getTime();
    private static final Map<String, String> CONTENT_TYPES = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourceName = request.getPathInfo();
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            int character;
            int lastDot;
            inStream = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
            if (inStream == null) {
                response.sendError(404);
                return;
            }
            inStream = new BufferedInputStream(inStream, 4096);
            String type = this.getServletContext().getMimeType(resourceName);
            if (type == null && (lastDot = resourceName.lastIndexOf(46)) != -1) {
                String suffix = resourceName.substring(lastDot + 1);
                type = CONTENT_TYPES.get(suffix.toLowerCase());
            }
            if (type != null) {
                response.setContentType(type);
            }
            response.setDateHeader("Last-Modified", this.getLastModified(request));
            outStream = response.getOutputStream();
            outStream = new BufferedOutputStream(outStream, 4096);
            while ((character = inStream.read()) != -1) {
                outStream.write(character);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getServletInfo() {
        return "Theme Servlet for Sun Web Components";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public long getLastModified(HttpServletRequest request) {
        return this.lastModified;
    }

    static {
        CONTENT_TYPES.put("js", "text/javascript");
        CONTENT_TYPES.put("css", "text/css");
        CONTENT_TYPES.put("htm", "text/html");
        CONTENT_TYPES.put("html", "text/html");
        CONTENT_TYPES.put("wml", "text/wml");
        CONTENT_TYPES.put("txt", "text/plain");
        CONTENT_TYPES.put("xml", "text/xml");
        CONTENT_TYPES.put("jpeg", "image/jpeg");
        CONTENT_TYPES.put("jpe", "image/jpeg");
        CONTENT_TYPES.put("jpg", "image/jpeg");
        CONTENT_TYPES.put("png", "image/png");
        CONTENT_TYPES.put("tif", "image/tiff");
        CONTENT_TYPES.put("tiff", "image/tiff");
        CONTENT_TYPES.put("bmp", "image/bmp");
        CONTENT_TYPES.put("xbm", "image/xbm");
        CONTENT_TYPES.put("ico", "image/x-icon");
        CONTENT_TYPES.put("gif", "image/gif");
        CONTENT_TYPES.put("pdf", "application/pdf");
        CONTENT_TYPES.put("ps", "application/postscript");
        CONTENT_TYPES.put("mim", "application/mime");
        CONTENT_TYPES.put("mime", "application/mime");
        CONTENT_TYPES.put("mid", "application/midi");
        CONTENT_TYPES.put("midi", "application/midi");
        CONTENT_TYPES.put("wav", "audio/wav");
        CONTENT_TYPES.put("bwf", "audio/wav");
        CONTENT_TYPES.put("cpr", "image/cpr");
        CONTENT_TYPES.put("avi", "video/x-msvideo");
        CONTENT_TYPES.put("mpeg", "video/mpeg");
        CONTENT_TYPES.put("mpg", "video/mpeg");
        CONTENT_TYPES.put("mpm", "video/mpeg");
        CONTENT_TYPES.put("mpv", "video/mpeg");
        CONTENT_TYPES.put("mpa", "video/mpeg");
        CONTENT_TYPES.put("au", "audio/basic");
        CONTENT_TYPES.put("snd", "audio/basic");
        CONTENT_TYPES.put("ulw", "audio/basic");
        CONTENT_TYPES.put("aiff", "audio/x-aiff");
        CONTENT_TYPES.put("aif", "audio/x-aiff");
        CONTENT_TYPES.put("aifc", "audio/x-aiff");
        CONTENT_TYPES.put("cdda", "audio/x-aiff");
        CONTENT_TYPES.put("pict", "image/x-pict");
        CONTENT_TYPES.put("pic", "image/x-pict");
        CONTENT_TYPES.put("pct", "image/x-pict");
        CONTENT_TYPES.put("mov", "video/quicktime");
        CONTENT_TYPES.put("qt", "video/quicktime");
        CONTENT_TYPES.put("pdf", "application/pdf");
        CONTENT_TYPES.put("pdf", "application/pdf");
        CONTENT_TYPES.put("ssm", "application/smil");
        CONTENT_TYPES.put("rsml", "application/vnd.rn-rsml");
        CONTENT_TYPES.put("ra", "application/vnd.rn-realaudio");
        CONTENT_TYPES.put("rm", "application/vnd.rn-realmedia");
        CONTENT_TYPES.put("rv", "application/vnd.rn-realvideo");
        CONTENT_TYPES.put("rf", "application/vnd.rn-realflash");
        CONTENT_TYPES.put("rf", "application/vnd.rn-realflash");
        CONTENT_TYPES.put("asf", "application/x-ms-asf");
        CONTENT_TYPES.put("asx", "application/x-ms-asf");
        CONTENT_TYPES.put("wm", "application/x-ms-wm");
        CONTENT_TYPES.put("wma", "application/x-ms-wma");
        CONTENT_TYPES.put("wax", "application/x-ms-wax");
        CONTENT_TYPES.put("wmw", "application/x-ms-wmw");
        CONTENT_TYPES.put("wvx", "application/x-ms-wvx");
        CONTENT_TYPES.put("swf", "application/x-shockwave-flash");
        CONTENT_TYPES.put("spl", "application/futuresplash");
        CONTENT_TYPES.put("avi", "video/msvideo");
        CONTENT_TYPES.put("flc", "video/flc");
        CONTENT_TYPES.put("mp4", "video/mpeg4");
    }
}

