/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.tools.ws.spi.WSToolsObjectFactory;
import jakarta.jws.Oneway;
import jakarta.jws.WebService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebEndpoint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.common.util.HttpParser;
import org.glassfish.jaxb.runtime.api.JAXBRIContext;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.MessageListenerImpl;
import org.glassfish.webservices.monitoring.MessageTrace;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;

public class WebServiceTesterServlet
extends HttpServlet {
    private final WebServiceEndpoint svcEP;
    private static final Logger logger = LogUtils.getLogger();
    private static final List<String> WSIMPORT_MODULES = Arrays.asList("jakarta.activation-api", "angus-activation", "jakarta.annotation-api", "jakarta.xml.bind-api", "com.sun.xml.bind.jaxb-osgi", "org.glassfish.metro.webservices-api-osgi", "org.glassfish.metro.webservices-osgi");
    private static final Hashtable<String, Class> gsiClasses = new Hashtable();
    private static final Hashtable<String, Object> ports = new Hashtable();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebServiceTesterServlet.class);

    public static void invoke(HttpServletRequest request, HttpServletResponse response, WebServiceEndpoint endpoint) {
        try {
            WebServiceTesterServlet servlet = new WebServiceTesterServlet(endpoint);
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            if (request.getMethod().equalsIgnoreCase("GET")) {
                servlet.doGet(request, response);
            } else {
                servlet.doPost(request, response);
            }
        }
        catch (Exception e) {
            try {
                PrintWriter out = response.getWriter();
                out.print("<HTML lang=" + Locale.getDefault().getLanguage() + "><HEAD><TITLE>" + localStrings.getLocalString("enterprise.webservice.monitoring.methodInvocationException", "Method invocation exception") + "</TITLE></HEAD>");
                out.print("<H3>" + localStrings.getLocalString("enterprise.webservice.monitoring.ExceptionDetails", "Exceptions details : {0}", new Object[]{e.getMessage()}) + "</H3>");
                out.print("<HR>");
                e.printStackTrace(out);
                out.print("<HR>");
                out.print("</HTML>");
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public WebServiceTesterServlet(WebServiceEndpoint ep) {
        this.svcEP = ep;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Method[] methods;
        res.setContentType("text/html");
        res.setHeader("pragma", "no-cache");
        PrintWriter out = res.getWriter();
        String requestURL = req.getRequestURL().toString();
        Endpoint myEndpoint = this.svcEP.implementedByWebComponent() ? WebServiceEngineImpl.getInstance().getEndpoint(req.getServletPath()) : WebServiceEngineImpl.getInstance().getEndpoint(req.getRequestURI());
        String seiClassName = myEndpoint.getDescriptor().getServiceEndpointInterface();
        ClassLoader testerCL = this.svcEP.getWebService().getBundleDescriptor().getClassLoader();
        if (testerCL != null) {
            Thread.currentThread().setContextClassLoader(testerCL);
        }
        try {
            Class<?> seiClass = Thread.currentThread().getContextClassLoader().loadClass(seiClassName);
            if (seiClass.getAnnotation(WebService.class) == null) {
                this.testerNotSupportedError(myEndpoint.getDescriptor().getServiceName(), out);
                return;
            }
        }
        catch (ClassNotFoundException clnfEx) {
            this.classNotAccessibleError(Thread.currentThread().getContextClassLoader(), seiClassName, out);
            return;
        }
        this.initializePort(req, res);
        Class clientSEI = gsiClasses.get(requestURL);
        out.print("<HTML lang=" + Locale.getDefault().getLanguage() + "><HEAD><TITLE>" + myEndpoint.getDescriptor().getServiceName().getLocalPart() + " " + localStrings.getLocalString("enterprise.webservice.monitoring.title", "Web Service Tester") + "</TITLE></HEAD>");
        out.print("<BODY><H1>" + myEndpoint.getDescriptor().getServiceName().getLocalPart() + " " + localStrings.getLocalString("enterprise.webservice.monitoring.title", "Web Service Tester") + "</H1>");
        out.print("<br>");
        String wsdlUrl = URLDecoder.decode(requestURL, HttpParser.getCharsetFromHeader((String)req.getContentType())) + "?WSDL";
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.line1", "This form will allow you to test your web service implementation (<A HREF=\"{0}\" title=\"WSDL file describing {1} web service\">WSDL File</A>)", new Object[]{wsdlUrl, myEndpoint.getDescriptor().getServiceName().getLocalPart()}));
        out.print("<hr>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.line2", "To invoke an operation, fill the method parameter(s) input boxes and click on the button labeled with the method name."));
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.methods", "<H3>Methods :</H3>"));
        for (Method m : methods = clientSEI.getMethods()) {
            out.print("<FORM METHOD=\"POST\">");
            out.print(m.toString());
            out.print("<BR>");
            out.print(localStrings.getLocalString("enterprise.webservice.monitoring.formSubmit", "<INPUT TYPE=SUBMIT NAME=action title=\"Invoke {0} operation\" value={0}>", new Object[]{m.getName()}));
            out.print(" (");
            Class<?>[] parameters = m.getParameterTypes();
            for (int i = 0; i < parameters.length; ++i) {
                out.print(localStrings.getLocalString("enterprise.webservice.monitoring.formInput", "<INPUT TYPE=TEXT NAME=PARAM{0}{1} title=\"{0} parameter of type {2}\">", new Object[]{m.getName(), i, parameters[i].getName()}));
                if (i == parameters.length - 1) continue;
                out.print(",");
            }
            out.print(")");
            out.print("<BR>");
            out.print("<HR>");
            out.print("</FORM></BODY></HTML>");
        }
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        res.setHeader("pragma", "no-cache");
        PrintWriter out = res.getWriter();
        String requestURL = req.getRequestURL().toString();
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.postTitle", "<HTML lang={0}><HEAD><TITLE>Method invocation trace</TITLE></HEAD>", new Object[]{Locale.getDefault().getLanguage()}));
        String operationName = req.getParameter("action");
        try {
            Endpoint myEndpoint = this.svcEP.implementedByWebComponent() ? WebServiceEngineImpl.getInstance().getEndpoint(req.getServletPath()) : WebServiceEngineImpl.getInstance().getEndpoint(req.getRequestURI());
            Class clientSEI = gsiClasses.get(requestURL);
            if (clientSEI == null) {
                this.initializePort(req, res);
                clientSEI = gsiClasses.get(requestURL);
            }
            Object port = ports.get(requestURL);
            Method[] methods = clientSEI.getMethods();
            Method toInvoke = null;
            for (Method m : methods) {
                if (!String.valueOf(m.getName()).equals(operationName)) continue;
                toInvoke = m;
            }
            if (toInvoke == null) {
                out.print("cannot  \"action\" request parameter method");
            } else {
                out.print(localStrings.getLocalString("enterprise.webservice.monitoring.methodInvocation", "<H2><A> {0} </A> Method invocation</H2><BR><HR>", new Object[]{toInvoke.getName()}));
                MessageListenerImpl listener = new MessageListenerImpl();
                myEndpoint.addListener(listener);
                Class<?>[] parameterTypes = toInvoke.getParameterTypes();
                Object[] parameterValues = new Object[parameterTypes.length];
                out.print(localStrings.getLocalString("enterprise.webservice.monitoring.methodTrace", "<h4>Method parameter(s)</h4>"));
                out.print("<table border=\"1\">");
                out.print("<tr>");
                out.print("<th>Type</th>");
                out.print("<th>Value</th>");
                out.print("</tr>");
                for (int i = 0; i < parameterTypes.length; ++i) {
                    out.print("<tr>");
                    String webValue = req.getParameter("PARAM" + toInvoke.getName() + i);
                    out.print("<td>" + parameterTypes[i].getName() + "</td>");
                    out.print("<td><pre>" + this.encodeHTML(webValue) + "</pre></td>");
                    parameterValues[i] = this.convertWebParam(parameterTypes[i], webValue);
                    out.print("</tr>");
                }
                out.print("</table>");
                out.print("<HR>");
                out.print(localStrings.getLocalString("enterprise.webservice.monitoring.methodReturn", "<h4>Method returned</h4>") + toInvoke.getReturnType().getName() + " : \"<b>" + this.encodeHTML(toInvoke.invoke(port, parameterValues).toString()) + "</b>\"");
                out.print("<HR>");
                if (listener.getRequest() != null) {
                    out.print(localStrings.getLocalString("enterprise.webservice.monitoring.soapReq", "<h4>SOAP Request</h4>"));
                    this.dumpMessage(listener.getRequest(), out);
                }
                if (toInvoke.getAnnotation(Oneway.class) == null && listener.getRespose() != null) {
                    out.print(localStrings.getLocalString("enterprise.webservice.monitoring.soapResp", "<h4>SOAP Response</h4>"));
                    this.dumpMessage(listener.getRespose(), out);
                }
                myEndpoint.removeListener(listener);
            }
        }
        catch (Throwable e) {
            out.print(localStrings.getLocalString("enterprise.webservice.monitoring.serviceExceptionError", "<H2>Service invocation threw an exception with message : {0}; Refer to the server log for more details</H2><BR><HR>", new Object[]{e.getMessage()}));
            throw new ServletException(e);
        }
        out.print("</HTML>");
        out.close();
    }

    private void dumpMessage(MessageTrace message, PrintWriter out) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(message.getMessage(true).getBytes());
        StreamSource ss = new StreamSource(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult sr = new StreamResult(baos);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.transform(ss, sr);
        out.print("<HR><blockquote><pre xml:lang>");
        out.write(this.encodeHTML(baos.toString()));
        out.print("</pre></blockquote><HR>");
    }

    private Object convertWebParam(Class targetParamType, String webValue) {
        Object convertedValue = null;
        if (webValue == null || webValue.length() == 0) {
            return null;
        }
        if (String.class.equals((Object)targetParamType)) {
            convertedValue = webValue;
        } else {
            try {
                if (Integer.TYPE.equals(targetParamType) || Integer.class.equals((Object)targetParamType)) {
                    convertedValue = Integer.valueOf(webValue);
                }
                if (Boolean.TYPE.equals(targetParamType) || Boolean.class.equals((Object)targetParamType)) {
                    convertedValue = Boolean.valueOf(webValue);
                }
                if (Character.TYPE.equals(targetParamType) || Character.class.equals((Object)targetParamType)) {
                    convertedValue = Character.valueOf(webValue.charAt(0));
                }
                if (Long.TYPE.equals(targetParamType) || Long.class.equals((Object)targetParamType)) {
                    convertedValue = Long.valueOf(webValue);
                }
                if (Float.TYPE.equals(targetParamType) || Float.class.equals((Object)targetParamType)) {
                    convertedValue = Float.valueOf(webValue);
                }
                if (Double.TYPE.equals(targetParamType) || Double.class.equals((Object)targetParamType)) {
                    convertedValue = Double.valueOf(webValue);
                }
                if (Byte.TYPE.equals(targetParamType) || Byte.class.equals((Object)targetParamType)) {
                    convertedValue = Byte.valueOf(webValue);
                }
                if (Short.TYPE.equals(targetParamType) || Short.class.equals((Object)targetParamType)) {
                    convertedValue = Short.valueOf(webValue);
                }
                if (StringBuffer.class.equals((Object)targetParamType)) {
                    convertedValue = new StringBuffer(webValue);
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("Cannot convert " + webValue + " in " + String.valueOf(targetParamType));
            }
        }
        return convertedValue;
    }

    private void classNotAccessibleError(ClassLoader cl, String className, PrintWriter out) {
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.CNFTitle", "<HTML lang={0}><HEAD><TITLE>Method invocation exception</TITLE></HEAD>", new Object[]{Locale.getDefault().getLanguage()}));
        if (cl == null) {
            out.print(localStrings.getLocalString("enterprise.webservice.monitoring.CNFServerError", "<H3>Internal server error, debugging is not available</H3>"));
        } else {
            out.print(localStrings.getLocalString("enterprise.webservice.monitoring.CNFerror2", "<H3>Cannot load class {0} - Verify class presence in bundle</H3>", new Object[]{className}));
        }
        out.print("<HR>");
        out.print("</HTML>");
        out.close();
    }

    private void testerNotSupportedError(QName svcName, PrintWriter out) {
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.TesterNSTitle", "<HTML lang={0}><HEAD><TITLE>Tester feature not supported</TITLE></HEAD>", new Object[]{Locale.getDefault().getLanguage()}));
        out.print("<BODY>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.TesterNSerror2", "Service {0} looks like a JAXRPC based webservice.", new Object[]{svcName}));
        out.print("<br><br>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.TesterNSdetail", "Please note that the tester feature is supported for JAXWS based webservices only"));
        out.print("</BODY>");
        out.print("</HTML>");
        out.close();
    }

    private void wsImportError(URL wsdlUrl, PrintWriter out) {
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.WsImportError", "<HTML lang={0}><HEAD><TITLE>WsImport error for the the following wsdl</TITLE></HEAD>", new Object[]{Locale.getDefault().getLanguage()}));
        out.print("<BODY>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.WsImportError2", "Error generating artifacts for the following WSDL {0}", new Object[]{wsdlUrl}));
        out.print("<br><br>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.WsImportError3", "Possible causes can be invoking https when the application is not configured for security", new Object[]{wsdlUrl}));
        out.print("</BODY>");
        out.print("</HTML>");
        out.close();
    }

    private void initializePort(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String requestURL = req.getRequestURL().toString();
        Endpoint myEndpoint = this.svcEP.implementedByWebComponent() ? WebServiceEngineImpl.getInstance().getEndpoint(req.getServletPath()) : WebServiceEngineImpl.getInstance().getEndpoint(req.getRequestURI());
        QName serviceName = new QName(myEndpoint.getDescriptor().getWsdlPort().getNamespaceURI(), myEndpoint.getDescriptor().getWebService().getName());
        URL wsdlUrl = this.toURL(URLDecoder.decode(requestURL, HttpParser.getCharsetFromHeader((String)req.getContentType())) + "?WSDL");
        String classesDir = this.wsImport(wsdlUrl);
        if (classesDir == null) {
            this.wsImportError(wsdlUrl, res.getWriter());
            return;
        }
        URL[] urls = new URL[]{this.toURL(new File(classesDir))};
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try (GlassfishUrlClassLoader testerCL = new GlassfishUrlClassLoader(urls, currentLoader.getParent());){
            Thread.currentThread().setContextClassLoader((ClassLoader)testerCL);
            String serviceClassName = this.getServiceClass(JAXBRIContext.mangleNameToClassName((String)serviceName.getLocalPart()), classesDir);
            if (serviceClassName == null) {
                throw new RuntimeException("Service Class not generated as expected");
            }
            Class serviceClass = testerCL.loadClass(serviceClassName);
            Service service = Service.create((URL)wsdlUrl, (QName)serviceName);
            if (service == null) {
                throw new RuntimeException("Cannot load Service");
            }
            String portClassName = this.getPortClass(myEndpoint, serviceClass);
            if (portClassName == null) {
                throw new RuntimeException("Cannot find the correct port class.");
            }
            Class portClass = testerCL.loadClass(portClassName);
            Object port = service.getPort(myEndpoint.getDescriptor().getWsdlPort(), portClass);
            if (port == null) {
                throw new RuntimeException("Cannot find the correct port class.");
            }
            ports.put(requestURL, port);
            gsiClasses.put(requestURL, portClass);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
            this.deleteDir(new File(classesDir));
        }
    }

    private URL toURL(String url) throws ServletException {
        try {
            return URI.create(url).toURL();
        }
        catch (MalformedURLException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private URL toURL(File file) throws ServletException {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String wsImport(URL wsdlLocation) throws IOException {
        File classesDir;
        block9: {
            classesDir = new File(System.getProperty("java.io.tmpdir"));
            if (!(classesDir = File.createTempFile("jax-ws", "tester", classesDir)).delete()) {
                logger.log(Level.WARNING, "AS-WSJSR109IMPL-00109", classesDir);
            }
            if (!classesDir.mkdirs()) {
                logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00110", classesDir);
            }
            String oldCP = System.getProperty("java.class.path");
            try {
                WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
                ModulesRegistry modulesRegistry = wscImpl.getModulesRegistry();
                Object classpath1 = classesDir.getAbsolutePath();
                for (String module : WSIMPORT_MODULES) {
                    HK2Module m = modulesRegistry.getModules(module).iterator().next();
                    ModuleDefinition md = m.getModuleDefinition();
                    classpath1 = (String)classpath1 + File.pathSeparator + new File(md.getLocations()[0]).getAbsolutePath();
                }
                System.setProperty("java.class.path", (String)classpath1);
                String[] wsimportArgs = new String[]{"-d", classesDir.getAbsolutePath(), "-keep", wsdlLocation.toExternalForm(), "-target", "3.0", "-extension"};
                WSToolsObjectFactory tools = WSToolsObjectFactory.newInstance();
                logger.log(Level.INFO, "AS-WSJSR109IMPL-00111", wsdlLocation);
                boolean success = tools.wsimport((OutputStream)System.out, wsimportArgs);
                if (success) {
                    logger.log(Level.INFO, "AS-WSJSR109IMPL-00112");
                    break block9;
                }
                logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00113");
                String string = null;
                return string;
            }
            finally {
                if (oldCP == null) {
                    System.clearProperty("java.class.path");
                } else {
                    System.setProperty("java.class.path", oldCP);
                }
            }
        }
        return classesDir.getAbsolutePath();
    }

    private String getServiceClass(String serviceClassName, String classesDirPath) {
        File classesDir = new File(classesDirPath);
        if (!classesDir.exists()) {
            return null;
        }
        List<File> mycoll = this.getListOfFiles(classesDir);
        File[] classes = mycoll.toArray(new File[mycoll.size()]);
        String resolvedServiceClass = null;
        String svcClass = null;
        for (File f : classes) {
            if (f.getName().endsWith(serviceClassName + "_Service.class")) {
                resolvedServiceClass = f.getAbsolutePath().substring(classesDirPath.length() + 1);
                continue;
            }
            if (!f.getName().endsWith(serviceClassName + ".class")) continue;
            svcClass = f.getAbsolutePath().substring(classesDirPath.length() + 1);
        }
        if (resolvedServiceClass != null) {
            svcClass = resolvedServiceClass;
        }
        if (svcClass != null) {
            svcClass = svcClass.substring(0, svcClass.indexOf(".class"));
            return svcClass.replaceAll("\\" + File.separator, ".");
        }
        return null;
    }

    private String getPortClass(Endpoint ep, Class<?> serviceClass) throws Exception {
        for (Method m : serviceClass.getMethods()) {
            WebEndpoint webEP = m.getAnnotation(WebEndpoint.class);
            if (webEP == null || webEP.name() == null || webEP.name().isEmpty()) continue;
            String getPortMethodName = "get" + JAXBRIContext.mangleNameToClassName((String)webEP.name());
            Method getPortMethod = serviceClass.getMethod(getPortMethodName, new Class[0]);
            return getPortMethod.getReturnType().getName();
        }
        return null;
    }

    private List<File> getListOfFiles(File path) {
        File[] files = path != null ? path.listFiles() : null;
        ArrayList<File> result = new ArrayList<File>();
        if (files == null) {
            return result;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                result.addAll(this.getListOfFiles(f));
                continue;
            }
            result.add(f);
        }
        return result;
    }

    private void deleteDir(File path) {
        if (path.exists() && path.isFile()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        this.deleteDir(f);
                    }
                    assert (f.delete());
                }
            }
            assert (path.delete());
        }
    }

    private String encodeHTML(String html) {
        return html.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

