/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.transport.tcp;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.EndpointLifecycleListener;
import org.glassfish.webservices.transport.tcp.AppServRegistry;
import org.glassfish.webservices.transport.tcp.LogUtils;

public final class WSEndpointLifeCycleListener
implements EndpointLifecycleListener {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public void endpointAdded(Endpoint endpoint) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "AS-WSSOAPTCP-00004", endpoint);
        }
        AppServRegistry.getInstance().registerEndpoint(endpoint);
    }

    @Override
    public void endpointRemoved(Endpoint endpoint) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "AS-WSSOAPTCP-00003", endpoint);
        }
        AppServRegistry.getInstance().deregisterEndpoint(endpoint);
    }
}

