/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.protocol.wsrm200702;

import com.sun.xml.ws.rx.rm.protocol.CreateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.AcceptType;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.Expires;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.Identifier;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.IncompleteSequenceBehaviorType;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CreateSequenceResponseType", propOrder={"identifier", "expires", "incompleteSequenceBehavior", "accept", "any"})
@XmlRootElement(name="CreateSequenceResponse", namespace="http://docs.oasis-open.org/ws-rx/wsrm/200702")
public class CreateSequenceResponseElement {
    @XmlElement(name="Identifier", required=true)
    protected Identifier identifier;
    @XmlElement(name="Expires")
    protected Expires expires;
    @XmlElement(name="IncompleteSequenceBehavior")
    protected IncompleteSequenceBehaviorType incompleteSequenceBehavior;
    @XmlElement(name="Accept")
    protected AcceptType accept;
    @XmlAnyElement(lax=true)
    protected List<Object> any;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public CreateSequenceResponseElement() {
    }

    public CreateSequenceResponseElement(CreateSequenceResponseData data) {
        this();
        this.identifier = new Identifier(data.getSequenceId());
        if (data.getIncompleteSequenceBehavior() != Sequence.IncompleteSequenceBehavior.getDefault()) {
            this.incompleteSequenceBehavior = IncompleteSequenceBehaviorType.fromISB(data.getIncompleteSequenceBehavior());
        }
        if (!data.doesNotExpire()) {
            this.expires = new Expires(data.getDuration());
        }
        if (data.getAcceptedSequenceAcksTo() != null) {
            this.accept = new AcceptType();
            this.accept.setAcksTo(data.getAcceptedSequenceAcksTo());
        }
    }

    public CreateSequenceResponseData.Builder toDataBuilder() {
        CreateSequenceResponseData.Builder dataBuilder = CreateSequenceResponseData.getBuilder(this.identifier.getValue());
        if (this.expires != null && this.expires.getDuration() != -1L) {
            dataBuilder.duration(this.expires.getDuration());
        }
        if (this.accept != null) {
            dataBuilder.acceptedSequenceAcksTo(this.accept.getAcksTo());
        }
        if (this.incompleteSequenceBehavior != null) {
            dataBuilder.incompleteSequenceBehavior(this.incompleteSequenceBehavior.translate());
        }
        return dataBuilder;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public Expires getExpires() {
        return this.expires;
    }

    public void setExpires(Expires value) {
        this.expires = value;
    }

    public IncompleteSequenceBehaviorType getIncompleteSequenceBehavior() {
        return this.incompleteSequenceBehavior;
    }

    public void setIncompleteSequenceBehavior(IncompleteSequenceBehaviorType value) {
        this.incompleteSequenceBehavior = value;
    }

    public AcceptType getAccept() {
        return this.accept;
    }

    public void setAccept(AcceptType value) {
        this.accept = value;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }
}

