/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens;

class LongJExpr
extends AbstractJExpr
implements JExpr {
    private final long val;
    private final int radix;

    LongJExpr(long val, int radix) {
        super(0);
        this.val = val;
        this.radix = radix;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        writer.addWordSpace();
        writer.write(Tokens.$NUMBER);
        switch (this.radix) {
            case 2: {
                writer.writeEscaped("0b");
                break;
            }
            case 16: {
                writer.writeEscaped("0x");
            }
        }
        writer.writeEscaped(Long.toString(this.val, this.radix) + "L");
    }
}

