/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.services.impl.JSEResultAdapter;
import com.ibm.jbatch.container.util.BatchContainerConstants;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IBatchThreadPoolService;
import com.ibm.jbatch.spi.services.ParallelTaskResult;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JNDIDelegatingThreadPoolServiceImpl
implements IBatchThreadPoolService,
BatchContainerConstants {
    private static final String sourceClass = JNDIDelegatingThreadPoolServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    public final String DEFAULT_JNDI_LOCATION = "java:comp/DefaultManagedExecutorService";
    private String jndiLocation = null;

    @Override
    public void init(IBatchConfig batchConfig) {
        this.jndiLocation = batchConfig.getConfigProperties().getProperty("THREADPOOL_JNDI_LOCATION", "java:comp/DefaultManagedExecutorService");
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
        String method = "shutdown";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    public void executeTask(Runnable work, Object config) {
        String method = "executeTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        try {
            InitialContext ctx = new InitialContext();
            ExecutorService delegateService = (ExecutorService)ctx.lookup(this.jndiLocation);
            delegateService.execute(work);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiLocation);
            throw new BatchContainerServiceException(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    public ParallelTaskResult executeParallelTask(Runnable work, Object config) {
        String method = "executeParallelTask";
        JSEResultAdapter taskResult = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        try {
            InitialContext ctx = new InitialContext();
            ExecutorService delegateService = (ExecutorService)ctx.lookup(this.jndiLocation);
            Future<?> result = delegateService.submit(work);
            taskResult = new JSEResultAdapter(result);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiLocation);
            throw new BatchContainerServiceException(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return taskResult;
    }
}

