/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.asm;

import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.AnnotationVisitor;
import org.eclipse.persistence.asm.FieldVisitor;
import org.eclipse.persistence.asm.MethodVisitor;

public abstract class ClassVisitor {
    protected ClassVisitor cv;
    protected ClassVisitor customClassVisitor;

    public ClassVisitor() {
    }

    public ClassVisitor(int api) {
        this.cv = ASMFactory.createClassVisitor(api);
    }

    public ClassVisitor(int api, ClassVisitor classVisitor) {
        this.cv = ASMFactory.createClassVisitor(api, classVisitor);
    }

    public void setCustomClassVisitor(ClassVisitor classVisitor) {
        this.cv.customClassVisitor = classVisitor;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSuper(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cv.visitSuper(version, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return this.cv.visitAnnotation(descriptor, visible);
    }

    public AnnotationVisitor visitAnnotationSuper(String descriptor, boolean visible) {
        return this.cv.visitAnnotationSuper(descriptor, visible);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return this.cv.visitField(access, name, desc, signature, value);
    }

    public FieldVisitor visitFieldSuper(int access, String name, String desc, String signature, Object value) {
        return this.cv.visitFieldSuper(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return this.cv.visitMethod(access, name, desc, signature, exceptions);
    }

    public MethodVisitor visitMethodSuper(int access, String name, String desc, String signature, String[] exceptions) {
        return this.cv.visitMethodSuper(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        this.cv.visitEnd();
    }

    public <T> T unwrap() {
        return this.cv.unwrap();
    }
}

