/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.formatter;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.glassfish.main.jul.cfg.LogProperty;
import org.glassfish.main.jul.formatter.FormatterConfigurationHelper;
import org.glassfish.main.jul.formatter.HandlerId;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.record.MessageResolver;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public abstract class GlassFishLogFormatter
extends Formatter {
    protected static final MessageResolver MSG_RESOLVER = new MessageResolver();
    protected static final DateTimeFormatter ISO_LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 6, 6, true).toFormatter(Locale.ROOT);
    protected static final DateTimeFormatter ISO_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(ISO_LOCAL_TIME).toFormatter(Locale.ROOT);
    protected static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_TIME).appendOffsetId().toFormatter(Locale.ROOT);
    private boolean printSequenceNumber;
    private boolean printSource;
    private DateTimeFormatter timestampFormatter = DEFAULT_DATETIME_FORMATTER;

    public GlassFishLogFormatter(boolean printSource, DateTimeFormatter timestampFormatter) {
        this.printSource = printSource;
        this.timestampFormatter = timestampFormatter;
        GlassFishLogFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
    }

    public GlassFishLogFormatter(HandlerId handlerId, boolean printSource, DateTimeFormatter timestampFormatter) {
        this.printSource = printSource;
        this.timestampFormatter = timestampFormatter;
        GlassFishLogFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
        GlassFishLogFormatter.configure(this, FormatterConfigurationHelper.forHandlerId(handlerId));
    }

    public GlassFishLogFormatter(HandlerId handlerId) {
        GlassFishLogFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
        GlassFishLogFormatter.configure(this, FormatterConfigurationHelper.forHandlerId(handlerId));
    }

    public GlassFishLogFormatter() {
        GlassFishLogFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
    }

    private static void configure(GlassFishLogFormatter formatter, FormatterConfigurationHelper helper) {
        formatter.printSequenceNumber = helper.getBoolean(GlassFishLogFormatterProperty.PRINT_SEQUENCE_NUMBER, formatter.printSequenceNumber);
        formatter.printSource = helper.getBoolean(GlassFishLogFormatterProperty.PRINT_SOURCE, formatter.printSource);
        formatter.timestampFormatter = helper.getDateTimeFormatter(GlassFishLogFormatterProperty.TIMESTAMP_FORMAT, formatter.timestampFormatter);
    }

    protected abstract String formatRecord(LogRecord var1);

    public void setPrintSequenceNumber(boolean printSequenceNumber) {
        this.printSequenceNumber = printSequenceNumber;
    }

    public boolean isPrintSequenceNumber() {
        return this.printSequenceNumber;
    }

    public void setPrintSource(boolean printSource) {
        this.printSource = printSource;
    }

    public boolean isPrintSource() {
        return this.printSource;
    }

    public final DateTimeFormatter getTimestampFormatter() {
        return this.timestampFormatter;
    }

    public final void setTimestampFormatter(DateTimeFormatter timestampFormatter) {
        this.timestampFormatter = timestampFormatter == null ? DEFAULT_DATETIME_FORMATTER : timestampFormatter;
    }

    public final void setTimestampFormatter(String format) {
        this.setTimestampFormatter(format == null ? DEFAULT_DATETIME_FORMATTER : DateTimeFormatter.ofPattern(format));
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.getPrintedMessage(MSG_RESOLVER.resolve(record));
    }

    @Override
    public final String format(LogRecord record) {
        return this.formatRecord(record);
    }

    protected String getPrintedMessage(GlassFishLogRecord record) {
        if (record == null) {
            return null;
        }
        String message = record.getMessage();
        String stackTrace = record.getThrownStackTrace();
        if (message == null || message.isEmpty()) {
            return stackTrace;
        }
        if (stackTrace == null) {
            return message;
        }
        return message + System.lineSeparator() + stackTrace;
    }

    static {
        GlassFishLoggingTracer.trace(GlassFishLogFormatter.class, () -> "ISO local time: " + ISO_LOCAL_TIME + ", ISO Local datetime: " + ISO_LOCAL_DATE_TIME + ", ISO-8601 formatter: " + DEFAULT_DATETIME_FORMATTER);
    }

    public static enum GlassFishLogFormatterProperty implements LogProperty
    {
        TIMESTAMP_FORMAT("timestampFormat"),
        PRINT_SEQUENCE_NUMBER("printSequenceNumber"),
        PRINT_SOURCE("printSource");

        private final String propertyName;

        private GlassFishLogFormatterProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

