/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.lang.reflect.Constructor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import org.glassfish.main.jul.cfg.ConfigurationHelper;
import org.glassfish.main.jul.cfg.LogProperty;
import org.glassfish.main.jul.formatter.HandlerId;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class HandlerConfigurationHelper
extends ConfigurationHelper {
    public static final LogProperty FORMATTER = () -> "formatter";
    public static final LogProperty FILTER = () -> "filter";
    private final HandlerId handlerId;

    public static HandlerConfigurationHelper forHandlerClass(Class<? extends Handler> handlerClass) {
        return new HandlerConfigurationHelper(HandlerId.forHandlerClass(handlerClass));
    }

    public HandlerConfigurationHelper(HandlerId handlerId) {
        super(handlerId.getPropertyPrefix(), ERROR_HANDLER_PRINT_TO_STDERR);
        this.handlerId = handlerId;
    }

    public Formatter getFormatter(Class<? extends Formatter> defaultFormatterClass) {
        Supplier<Formatter> defaultSupplier = () -> this.createNewFormatter(defaultFormatterClass);
        Function<String, Formatter> converter = value -> this.createNewFormatter((String)value);
        return this.parseOrSupply(FORMATTER, defaultSupplier, converter);
    }

    public Filter getFilter() {
        Function<String, Filter> converter = value -> {
            Class filterClass = this.findClass((String)value);
            return this.createNewFilter(filterClass);
        };
        return this.parseOrSupply(FILTER, () -> null, converter);
    }

    private <F extends Formatter> F createNewFormatter(String className) {
        Class<F> formatterClass = this.findClass(className);
        return this.createNewFormatter(formatterClass);
    }

    private <F> Class<F> findClass(String className) {
        if (className == null) {
            return null;
        }
        ClassLoader classLoader = this.getClassLoader();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassCastException | ClassNotFoundException | NoClassDefFoundError e) {
            GlassFishLoggingTracer.error(ConfigurationHelper.class, "Classloader: " + classLoader, e);
            throw new IllegalStateException("Formatter instantiation failed! ClassLoader used: " + classLoader, e);
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
        if (threadCL != null) {
            return threadCL;
        }
        return this.getClass().getClassLoader();
    }

    private <F extends Formatter> F createNewFormatter(Class<F> clazz) {
        if (clazz == null) {
            return null;
        }
        Constructor<F> constructor = this.getFormatterConstructorForHandler(clazz);
        try {
            if (constructor == null) {
                return (F)((Formatter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            return (F)((Formatter)constructor.newInstance(this.handlerId));
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            this.handleError(e, FORMATTER.getPropertyFullName(this.handlerId.getPropertyPrefix()), clazz);
            return null;
        }
    }

    private <F extends Formatter> Constructor<F> getFormatterConstructorForHandler(Class<F> formatterClass) {
        try {
            return formatterClass.getConstructor(HandlerId.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            GlassFishLoggingTracer.trace(this.getClass(), "This formatter doesn't support configuration by handler's formatter properties subset: " + formatterClass + ", so we will use formatter's default constructor");
            return null;
        }
    }

    private <F extends Filter> F createNewFilter(Class<F> clazz) {
        try {
            return (F)((Filter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            this.handleError(e, FILTER.getPropertyFullName(this.handlerId.getPropertyPrefix()), clazz);
            return null;
        }
    }
}

