/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.api;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.derby.vti.VTITemplate;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SimpleJsonVTI
extends VTITemplate {
    private JSONArray _topArray = null;
    private int _nextIdx = 0;
    private JSONObject _currentRow = null;
    private boolean _wasNull = true;
    private Connection _connection;
    private VTITemplate.ColumnDescriptor[] _returnColumns;
    private SQLWarning _warning = null;

    private SimpleJsonVTI(JSONArray jSONArray) throws SQLException {
        this._topArray = jSONArray;
        this._connection = DriverManager.getConnection("jdbc:default:connection");
    }

    public static SimpleJsonVTI readArray(JSONArray jSONArray) throws SQLException {
        return new SimpleJsonVTI(jSONArray);
    }

    public void close() throws SQLException {
        this._connection = null;
        this._returnColumns = null;
        this._topArray = null;
        this._currentRow = null;
    }

    public boolean next() throws SQLException {
        Object object;
        if (this._topArray == null) {
            return false;
        }
        if (this._nextIdx >= this._topArray.size()) {
            return false;
        }
        if (this._returnColumns == null) {
            this._returnColumns = this.getReturnTableSignature(this._connection);
        }
        if ((object = this._topArray.get(this._nextIdx)) == null || !(object instanceof JSONObject)) {
            this._currentRow = null;
            String string = object == null ? "NULL" : object.getClass().getName();
            this.addWarning("Row " + this._nextIdx + " is not a JSON object. It is a " + string);
        } else {
            this._currentRow = (JSONObject)object;
        }
        ++this._nextIdx;
        return true;
    }

    public boolean wasNull() {
        return this._wasNull;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
        throw this.notImplemented("clearWarnings");
    }

    public String getString(int n) throws SQLException {
        Object object = this.getColumn(n);
        if (this._wasNull) {
            return null;
        }
        return object.toString();
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumn(n);
        if (this.nullOrWrongType(Boolean.class, n, object)) {
            return false;
        }
        return (Boolean)object;
    }

    public byte getByte(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (this._wasNull) {
            return 0;
        }
        return number.byteValue();
    }

    public short getShort(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (this._wasNull) {
            return 0;
        }
        return number.shortValue();
    }

    public int getInt(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (this._wasNull) {
            return 0;
        }
        return number.intValue();
    }

    public long getLong(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (this._wasNull) {
            return 0L;
        }
        return number.longValue();
    }

    public float getFloat(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (this._wasNull) {
            return 0.0f;
        }
        return number.floatValue();
    }

    public double getDouble(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (this._wasNull) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public Object getObject(int n) throws SQLException {
        return this.getColumn(n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        String string = this.getString(n);
        if (this._wasNull) {
            return null;
        }
        try {
            return new BigDecimal(string);
        }
        catch (Throwable throwable) {
            throw ToolUtilities.wrap(throwable);
        }
    }

    private Number getNumber(int n) throws SQLException {
        Object object = this.getColumn(n);
        if (this.nullOrWrongType(Number.class, n, object)) {
            return null;
        }
        return (Number)object;
    }

    private Object getColumn(int n) throws SQLException {
        if (n < 1 || n > this._returnColumns.length) {
            throw new SQLException("Column index " + n + " is out of bounds.");
        }
        if (this._currentRow == null) {
            this._wasNull = true;
            return null;
        }
        Object object = this._currentRow.get((Object)this._returnColumns[n - 1].columnName);
        this._wasNull = object == null;
        return object;
    }

    private boolean nullOrWrongType(Class clazz, int n, Object object) {
        if (this._wasNull) {
            return true;
        }
        if (!clazz.isInstance(object)) {
            String string = clazz.getName();
            String string2 = object.getClass().getName();
            this.addWarning("Column " + n + " in row " + this._nextIdx + " is not a " + string + ". It is a " + string2 + ".");
            this._wasNull = true;
            return true;
        }
        return false;
    }

    private void addWarning(String string) {
        SQLWarning sQLWarning = new SQLWarning(string);
        if (this._warning == null) {
            this._warning = sQLWarning;
        } else {
            this._warning.setNextWarning(sQLWarning);
        }
    }
}

