/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authentication.jakarta;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import com.sun.enterprise.deployment.runtime.common.ProtectionDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.security.ee.authentication.jakarta.WebServicesDelegate;
import jakarta.security.auth.message.MessagePolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.internal.api.Globals;

public class AuthMessagePolicy {
    public static final String WEB_BUNDLE = "WEB_BUNDLE";
    private static final String HANDLER_CLASS_PROPERTY = "security.jmac.config.ConfigHelper.CallbackHandler";
    private static final String DEFAULT_HANDLER_CLASS = "com.sun.enterprise.security.ee.authentication.jakarta.callback.ContainerCallbackHandler";
    private static String handlerClassName;

    private AuthMessagePolicy() {
    }

    public static MessageSecurityBindingDescriptor getMessageSecurityBinding(String layer, Map<String, Object> properties) {
        String bindingLayer;
        if (properties == null) {
            return null;
        }
        MessageSecurityBindingDescriptor binding = null;
        WebServiceEndpoint webServiceEndpoint = (WebServiceEndpoint)properties.get("SERVICE_ENDPOINT");
        if (webServiceEndpoint != null) {
            binding = webServiceEndpoint.getMessageSecurityBinding();
        } else {
            WebServicesDelegate delegate;
            ServiceReferenceDescriptor serviceReferenceDescriptor = (ServiceReferenceDescriptor)properties.get("SERVICE_REF");
            if (serviceReferenceDescriptor != null && (delegate = (WebServicesDelegate)Globals.get(WebServicesDelegate.class)) != null) {
                binding = delegate.getBinding(serviceReferenceDescriptor, properties);
            }
        }
        if (binding != null && ((bindingLayer = (String)binding.getValue("AuthLayer")) == null || layer.equals(bindingLayer))) {
            return binding;
        }
        return null;
    }

    public static MessagePolicy getMessagePolicy(ProtectionDescriptor protectionDescriptor) {
        MessagePolicy messagePolicy = null;
        if (protectionDescriptor != null) {
            String source = protectionDescriptor.getAttributeValue("AuthSource");
            String recipient = protectionDescriptor.getAttributeValue("AuthRecipient");
            messagePolicy = org.glassfish.epicyro.config.helper.AuthMessagePolicy.getMessagePolicy((String)source, (String)recipient);
        }
        return messagePolicy;
    }

    public static String getProviderID(MessageSecurityBindingDescriptor binding) {
        if (binding == null) {
            return null;
        }
        if (!"SOAP".equals(binding.getValue("AuthLayer"))) {
            return null;
        }
        return (String)binding.getValue("ProviderID");
    }

    public static MessagePolicy[] getSOAPPolicies(MessageSecurityBindingDescriptor binding, String operation, boolean onePolicy) {
        MessagePolicy requestPolicy = null;
        MessagePolicy responsePolicy = null;
        if (binding != null) {
            ArrayList messageSecurityDescriptors = null;
            String layer = (String)binding.getValue("AuthLayer");
            if ("SOAP".equals(layer)) {
                messageSecurityDescriptors = binding.getMessageSecurityDescriptors();
            }
            if (messageSecurityDescriptors != null) {
                if (onePolicy) {
                    if (messageSecurityDescriptors.size() > 0) {
                        MessageSecurityDescriptor messageSecurityDescriptor = (MessageSecurityDescriptor)messageSecurityDescriptors.get(0);
                        requestPolicy = AuthMessagePolicy.getMessagePolicy(messageSecurityDescriptor.getRequestProtectionDescriptor());
                        responsePolicy = AuthMessagePolicy.getMessagePolicy(messageSecurityDescriptor.getResponseProtectionDescriptor());
                    }
                } else {
                    MessageSecurityDescriptor matchMsd = null;
                    for (int i = 0; i < messageSecurityDescriptors.size(); ++i) {
                        MessageSecurityDescriptor msd = (MessageSecurityDescriptor)messageSecurityDescriptors.get(i);
                        List msgDescs = msd.getMessageDescriptors();
                        for (int j = i + 1; j < msgDescs.size(); ++j) {
                            MessageDescriptor msgDesc = (MessageDescriptor)msgDescs.get(j);
                            String opName = msgDesc.getOperationName();
                            if (opName == null && matchMsd == null) {
                                matchMsd = msd;
                                continue;
                            }
                            if (opName == null || !opName.equals(operation)) continue;
                            matchMsd = msd;
                            break;
                        }
                        if (matchMsd == null) continue;
                        requestPolicy = AuthMessagePolicy.getMessagePolicy(matchMsd.getRequestProtectionDescriptor());
                        responsePolicy = AuthMessagePolicy.getMessagePolicy(matchMsd.getResponseProtectionDescriptor());
                    }
                }
            }
        }
        return new MessagePolicy[]{requestPolicy, responsePolicy};
    }

    public static boolean oneSOAPPolicy(MessageSecurityBindingDescriptor binding) {
        String layer;
        boolean onePolicy = true;
        List msgSecDescs = null;
        if (binding != null && "SOAP".equals(layer = binding.getAttributeValue("AuthLayer"))) {
            msgSecDescs = binding.getMessageSecurityDescriptors();
        }
        if (msgSecDescs == null) {
            return true;
        }
        for (int i = 0; i < msgSecDescs.size(); ++i) {
            MessageSecurityDescriptor msd = (MessageSecurityDescriptor)msgSecDescs.get(i);
            for (int j = 0; j < msgSecDescs.size(); ++j) {
                if (j == i || AuthMessagePolicy.policiesAreEqual(msd, (MessageSecurityDescriptor)msgSecDescs.get(j))) continue;
                onePolicy = false;
            }
        }
        return onePolicy;
    }

    public static SunWebApp getSunWebApp(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        WebBundleDescriptor webBundle = (WebBundleDescriptor)properties.get(WEB_BUNDLE);
        return webBundle.getSunDescriptor();
    }

    public static String getProviderID(SunWebApp sunWebApp) {
        if (sunWebApp == null) {
            return null;
        }
        return sunWebApp.getAttributeValue("HttpServletSecurityProvider");
    }

    public static CallbackHandler getDefaultCallbackHandler() {
        try {
            if (handlerClassName == null) {
                handlerClassName = System.getProperty(HANDLER_CLASS_PROPERTY, DEFAULT_HANDLER_CLASS);
            }
            return (CallbackHandler)Class.forName(handlerClassName, true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException pae) {
            throw new RuntimeException(pae);
        }
    }

    private static boolean policiesAreEqual(MessageSecurityDescriptor reference, MessageSecurityDescriptor other) {
        return AuthMessagePolicy.protectionDescriptorsAreEqual(reference.getRequestProtectionDescriptor(), other.getRequestProtectionDescriptor()) && AuthMessagePolicy.protectionDescriptorsAreEqual(reference.getResponseProtectionDescriptor(), other.getResponseProtectionDescriptor());
    }

    private static boolean protectionDescriptorsAreEqual(ProtectionDescriptor pd1, ProtectionDescriptor pd2) {
        String authSource1 = pd1.getAttributeValue("AuthSource");
        String authRecipient1 = pd1.getAttributeValue("AuthRecipient");
        String authSource2 = pd2.getAttributeValue("AuthSource");
        String authRecipient2 = pd2.getAttributeValue("AuthRecipient");
        boolean sameAuthSource = authSource1 == null && authSource2 == null || authSource1 != null && authSource1.equals(authSource2);
        boolean sameAuthRecipient = authRecipient1 == null && authRecipient2 == null || authRecipient1 != null && authRecipient1.equals(authRecipient2);
        return sameAuthSource && sameAuthRecipient;
    }
}

