/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.enterprise.module.bootstrap.StartupContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.util.List;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.appclient.server.core.jws.ClientJNLPConfigData;
import org.glassfish.appclient.server.core.jws.CombinedXPath;
import org.glassfish.appclient.server.core.jws.XPathToDeveloperProvidedContentRefs;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class DeveloperContentService
implements PostConstruct {
    @Inject
    private StartupContext startupContext;
    @Inject
    private ServerEnvironment serverEnv;
    private ClientJNLPConfigData configData;

    public void postConstruct() {
        this.configData = new ClientJNLPConfigData(this.installConfigDir(), this.domainConfigDir());
    }

    private File installConfigDir() {
        return new File(this.startupContext.getArguments().getProperty(GlassFishVariable.INSTALL_ROOT.getPropertyName()), "config");
    }

    private File domainConfigDir() {
        return this.serverEnv.getConfigDirPath();
    }

    List<XPathToDeveloperProvidedContentRefs> xPathsToDevContentRefs() {
        return this.configData.xPathsToDevContentRefs();
    }

    List<CombinedXPath> xPathsToCombinedContent() {
        return this.configData.xPathsToCombinedContent();
    }
}

