/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserFactory;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import com.sun.enterprise.server.logging.parser.ParsedLogRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class LogFile
implements Serializable {
    private static final long serialVersionUID = -2960142541274652618L;
    private final long _indexSize = 10L;
    private final String _logFileName;
    private final List<Long> _recordIdx = new ArrayList<Long>();

    public LogFile(String name) {
        this._logFileName = name;
        this._recordIdx.add(0L);
    }

    public List getLogEntries(long startingRecord) {
        return this.getLogEntries(startingRecord, this.getIndexSize());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<LogEntry> getLogEntries(final long startingRecord, final long maxRecords) {
        if (startingRecord < 0L) {
            return null;
        }
        final long recordsToIgnore = startingRecord % this.getIndexSize();
        try (BufferedReader reader = this.getFilePosition(startingRecord - recordsToIgnore);){
            final ArrayList<LogEntry> results = new ArrayList<LogEntry>();
            if (reader == null) {
                ArrayList<LogEntry> arrayList2 = results;
                return arrayList2;
            }
            File logFile = new File(this.getLogFileName());
            LogParser logParser = LogParserFactory.getInstance().createLogParser(logFile);
            logParser.parseLog(reader, new LogParserListener(){
                long counter = 0L;

                @Override
                public void foundLogRecord(long position, ParsedLogRecord logRecord) {
                    ++this.counter;
                    if (this.counter <= recordsToIgnore) {
                        return;
                    }
                    if ((long)results.size() < maxRecords) {
                        LogEntry entry = new LogEntry(startingRecord + (long)results.size());
                        entry.setLoggedDateTime(logRecord.getTimestamp());
                        entry.setLoggedLevel(logRecord.getLevel());
                        entry.setLoggedLoggerName(logRecord.getLogger());
                        entry.setLoggedMessage(logRecord.getMessage());
                        entry.setLoggedNameValuePairs(logRecord.getSupplementalAttributes().toString());
                        entry.setLoggedProduct(logRecord.getProductId());
                        entry.setMessageId(logRecord.getMessageKey());
                        results.add(entry);
                    }
                }
            });
            ArrayList<LogEntry> arrayList = results;
            return arrayList;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private synchronized void buildLogFileIndex() {
        final long startPos = this._recordIdx.get(this._recordIdx.size() - 1);
        final long localIndexSize = this.getIndexSize();
        try (BufferedReader reader = this.getLogFileReader(startPos);){
            File logFile = new File(this.getLogFileName());
            LogParser logParser = LogParserFactory.getInstance().createLogParser(logFile);
            if (logParser != null) {
                logParser.parseLog(reader, new LogParserListener(){
                    long recordNumber;
                    {
                        this.recordNumber = (long)(LogFile.this._recordIdx.size() - 1) * localIndexSize;
                    }

                    @Override
                    public void foundLogRecord(long position, ParsedLogRecord object) {
                        long modIndex = this.recordNumber % localIndexSize;
                        if (modIndex == 0L) {
                            LogFile.this._recordIdx.add(startPos + position);
                        }
                        ++this.recordNumber;
                    }
                });
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private BufferedReader getFilePosition(long recordNumber) {
        int index = (int)(recordNumber / this.getIndexSize());
        if (index >= this._recordIdx.size()) {
            return null;
        }
        Long filePosition = this._recordIdx.get(index);
        return this.getLogFileReader(filePosition);
    }

    protected BufferedReader getLogFileReader(long fromFilePosition) {
        FileInputStream file = null;
        try {
            long bytesSkipped;
            file = new FileInputStream(this.getLogFileName());
            long bytesToSkip = fromFilePosition - 1L;
            if (bytesToSkip > 0L && (bytesSkipped = file.skip(bytesToSkip)) != bytesToSkip) {
                LogFacade.LOGGING_LOGGER.log(Level.WARNING, "Did not skip {0} bytes while positioning reader in {1}", new Object[]{bytesToSkip, this.getLogFileName()});
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(file));
            return reader;
        }
        catch (Exception ex) {
            LogFacade.LOGGING_LOGGER.log(Level.SEVERE, "Error reading from file: " + this.getLogFileName(), ex);
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception ex2) {
                    LogFacade.LOGGING_LOGGER.log(Level.SEVERE, "Error closing file: " + this.getLogFileName(), ex2);
                }
            }
            return null;
        }
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    public long getLastIndexNumber() {
        this.buildLogFileIndex();
        return this._recordIdx.size() - 1;
    }

    public long getIndexSize() {
        return 10L;
    }

    public static class LogEntry
    implements Serializable {
        private static final long serialVersionUID = 1067284334612090072L;
        private long recordNumber;
        private OffsetDateTime loggedDateTime;
        private String loggedLevel;
        private String loggedProduct;
        private String loggedLoggerName;
        private String loggedNameValuePairs;
        private String loggedMessage;
        private String messageId;

        public LogEntry(long recordNumber) {
            this.recordNumber = recordNumber;
        }

        public OffsetDateTime getLoggedDateTime() {
            return this.loggedDateTime;
        }

        public void setLoggedDateTime(OffsetDateTime loggedDateTime) {
            this.loggedDateTime = loggedDateTime;
        }

        public String getLoggedLevel() {
            return this.loggedLevel;
        }

        public void setLoggedLevel(String loggedLevel) {
            this.loggedLevel = loggedLevel;
        }

        public String getLoggedProduct() {
            return this.loggedProduct;
        }

        public void setLoggedProduct(String loggedProduct) {
            this.loggedProduct = loggedProduct;
        }

        public String getLoggedLoggerName() {
            return this.loggedLoggerName;
        }

        public void setLoggedLoggerName(String loggedLoggerName) {
            this.loggedLoggerName = loggedLoggerName;
        }

        public String getLoggedNameValuePairs() {
            return this.loggedNameValuePairs;
        }

        public void setLoggedNameValuePairs(String loggedNameValuePairs) {
            this.loggedNameValuePairs = loggedNameValuePairs;
        }

        public void setLoggedMessage(String message) {
            this.loggedMessage = message;
        }

        public void appendLoggedMessage(String message) {
            this.loggedMessage = this.loggedMessage + message;
        }

        public String getLoggedMessage() {
            return this.loggedMessage;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public long getRecordNumber() {
            return this.recordNumber;
        }

        public void setRecordNumber(long recordNumber) {
            this.recordNumber = recordNumber;
        }

        public String toString() {
            return this.getRecordNumber() + ":" + this.getLoggedMessage();
        }
    }
}

