/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.ResourcePropertyNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AdministeredObjectDefinitionNode
extends DeploymentDescriptorNode<AdministeredObjectDefinitionDescriptor> {
    @LogMessageInfo(message="For administered-object resource: {0}, there is no application part in its resource adapter name: {1}.", level="WARNING", cause="For embedded resource adapter, its internal format of resource adapter name should contains application name.", comment="For the method writeDescriptor of com.sun.enterprise.deployment.node.AdministeredObjectDefinitionNode.")
    private static final String RESOURCE_ADAPTER_NAME_INVALID = "AS-DEPLOYMENT-00022";
    private AdministeredObjectDefinitionDescriptor descriptor;

    public AdministeredObjectDefinitionNode() {
        this.registerElementHandler(new XMLElement("property"), ResourcePropertyNode.class, "addAdministeredObjectPropertyDescriptor");
    }

    @Override
    public AdministeredObjectDefinitionDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new AdministeredObjectDefinitionDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("name", "setName");
        table.put("interface-name", "setInterfaceName");
        table.put("class-name", "setClassName");
        table.put("resource-adapter", "setResourceAdapter");
        return table;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, AdministeredObjectDefinitionDescriptor desc) {
        Element node = AdministeredObjectDefinitionNode.appendChild(parent, nodeName);
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "description", desc.getDescription());
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "name", desc.getName());
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "interface-name", desc.getInterfaceName());
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "class-name", desc.getClassName());
        String resourceAdapterName = desc.getResourceAdapter();
        int poundIndex = resourceAdapterName.indexOf("#");
        if (poundIndex > 0) {
            resourceAdapterName = resourceAdapterName.substring(poundIndex);
        } else if (poundIndex == 0) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, RESOURCE_ADAPTER_NAME_INVALID, new Object[]{desc.getName(), desc.getResourceAdapter()});
        }
        AdministeredObjectDefinitionNode.appendTextChild((Node)node, "resource-adapter", resourceAdapterName);
        return ResourcePropertyNode.write(node, desc);
    }
}

