/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.codegen.AccessLevel;
import org.eclipse.persistence.internal.codegen.CodeGenerator;

public abstract class CodeDefinition {
    protected AccessLevel accessLevel = new AccessLevel();
    protected String name = "";
    protected String comment = "";
    protected static final String JAVA_LANG_PACKAGE_NAME = "java.lang";
    protected static final String JAVA_UTIL_PACKAGE_NAME = "java.util";
    protected static final String TOPLINK_INDIRECTION_PACKAGE_NAME = "org.eclipse.persistence.indirection";

    protected CodeDefinition() {
    }

    private static boolean adjustmentNeededForType(String typeName, Map<String, Set<String>> typeNameMap) {
        if (typeName == null || typeName.isEmpty()) {
            return false;
        }
        if (CodeDefinition.packageName(typeName).isEmpty()) {
            return false;
        }
        Set<String> packages = typeNameMap.get(CodeDefinition.shortName(typeName));
        return packages == null || packages.size() <= 1;
    }

    protected static String adjustTypeName(String typeName, Map<String, Set<String>> typeNameMap) {
        if (CodeDefinition.adjustmentNeededForType(typeName, typeNameMap)) {
            CodeDefinition.putTypeNameInMap(typeName, typeNameMap);
            return typeName.substring(CodeDefinition.packageName(typeName).length() + 1);
        }
        return typeName;
    }

    protected static Set<String> parseForTypeNames(String longString) {
        HashSet<String> typeNames = new HashSet<String>();
        if (longString != null) {
            typeNames.addAll(CodeDefinition.parseForTypeNamesInPackage(longString, JAVA_LANG_PACKAGE_NAME));
            typeNames.addAll(CodeDefinition.parseForTypeNamesInPackage(longString, JAVA_UTIL_PACKAGE_NAME));
            typeNames.addAll(CodeDefinition.parseForTypeNamesInPackage(longString, TOPLINK_INDIRECTION_PACKAGE_NAME));
        }
        return typeNames;
    }

    private static Set<String> parseForTypeNamesInPackage(String longString, String packageName) {
        HashSet<String> typeNames = new HashSet<String>();
        int packageStartIndex = longString.indexOf(packageName);
        while (packageStartIndex != -1) {
            boolean lookingForEndOfTypeName = true;
            int searchIndex = packageStartIndex + packageName.length() + 1;
            while (lookingForEndOfTypeName) {
                if (Character.isJavaIdentifierPart(longString.charAt(searchIndex))) {
                    ++searchIndex;
                    continue;
                }
                lookingForEndOfTypeName = false;
            }
            typeNames.add(longString.substring(packageStartIndex, searchIndex));
            packageStartIndex = longString.indexOf(packageName, searchIndex);
        }
        return typeNames;
    }

    protected static void putTypeNameInMap(String typeName, Map<String, Set<String>> typeNameMap) {
        if (typeName == null || typeName.isEmpty()) {
            return;
        }
        String shortName = CodeDefinition.shortName(typeName);
        String packageName = CodeDefinition.packageName(typeName);
        if (!packageName.isEmpty()) {
            Set<Object> packageNames;
            if (typeNameMap.get(shortName) == null) {
                packageNames = new HashSet();
                typeNameMap.put(shortName, packageNames);
            } else {
                packageNames = typeNameMap.get(shortName);
            }
            if (!packageNames.contains(packageName)) {
                packageNames.add(packageName);
            }
        }
    }

    private static String packageName(String typeName) {
        int lastPeriod = typeName.lastIndexOf(46);
        if (lastPeriod == -1) {
            return "";
        }
        return typeName.substring(0, lastPeriod);
    }

    private static String shortName(String typeName) {
        int shortNameStartIndex;
        int searchIndex = shortNameStartIndex = typeName.lastIndexOf(46) + 1;
        boolean stillLookingForEnd = true;
        while (stillLookingForEnd) {
            if (Character.isJavaIdentifierPart(typeName.charAt(searchIndex))) {
                stillLookingForEnd = ++searchIndex < typeName.length();
                continue;
            }
            stillLookingForEnd = false;
        }
        return typeName.substring(shortNameStartIndex, searchIndex);
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        try {
            CodeGenerator generator = new CodeGenerator();
            this.write(generator);
            return generator.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void write(CodeGenerator generator) throws IOException {
        if (!this.getComment().isEmpty()) {
            generator.writeln("/**");
            String comment = this.getComment();
            String cr = System.lineSeparator();
            int lastLineIndex = 0;
            int nextLineIndex = comment.indexOf(cr);
            while (nextLineIndex != -1) {
                generator.write(" * ");
                generator.write(comment.substring(lastLineIndex, nextLineIndex + cr.length()));
                lastLineIndex = nextLineIndex + cr.length();
                nextLineIndex = comment.indexOf(cr, lastLineIndex);
            }
            generator.write(" * ");
            generator.writeln(comment.substring(lastLineIndex));
            generator.writeln(" */");
            generator.cr();
        }
        this.getAccessLevel().write(generator);
        generator.write(" ");
        this.writeBody(generator);
    }

    public abstract void writeBody(CodeGenerator var1) throws IOException;
}

