/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ConnectionRequestInfoImpl;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.SecurityException;
import jakarta.resource.spi.security.PasswordCredential;
import java.util.Arrays;
import javax.security.auth.Subject;

public class SecurityUtils {
    private static StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);

    public static PasswordCredential getPasswordCredential(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (connectionRequestInfo == null) {
            if (subject == null) {
                return null;
            }
            PasswordCredential passwordCredential = null;
            for (PasswordCredential temp : subject.getPrivateCredentials(PasswordCredential.class)) {
                if (!temp.getManagedConnectionFactory().equals((Object)managedConnectionFactory)) continue;
                passwordCredential = temp;
            }
            if (passwordCredential == null) {
                throw new SecurityException(sm.getString("su.no_passwd_cred"));
            }
            return passwordCredential;
        }
        ConnectionRequestInfoImpl cxReqInfo = (ConnectionRequestInfoImpl)connectionRequestInfo;
        PasswordCredential passwordCredential = new PasswordCredential(cxReqInfo.getUser(), cxReqInfo.getPassword());
        passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
        return passwordCredential;
    }

    private static boolean isEqual(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean isPasswordCredentialEqual(PasswordCredential pC1, PasswordCredential pC2) {
        if (pC1 == pC2) {
            return true;
        }
        if (pC1 == null || pC2 == null) {
            return pC1 == pC2;
        }
        if (!SecurityUtils.isEqual(pC1.getUserName(), pC2.getUserName())) {
            return false;
        }
        return Arrays.equals(pC1.getPassword(), pC2.getPassword());
    }
}

