/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro;

import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.concurro.AbstractManagedThread;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.ThreadExpiredException;
import org.glassfish.concurro.spi.ContextHandle;
import org.glassfish.concurro.spi.ContextSetupProvider;

public class ManagedThreadFactoryImpl
implements ManagedThreadFactory {
    public static final String MANAGED_THREAD_FACTORY_STOPPED = "ManagedThreadFactory is stopped";
    private final String name;
    private final int priority;
    private final List<Thread> threads;
    private final Lock lock;
    private final ContextSetupProvider contextSetupProvider;
    private final ContextServiceImpl contextService;
    @Deprecated(forRemoval=true, since="3.1.0")
    protected ContextHandle savedContextHandleForSetup;
    private boolean stopped;
    private final AtomicInteger threadIdSequence = new AtomicInteger();
    private long hungTaskThreshold = 0L;

    public ManagedThreadFactoryImpl(String name) {
        this(name, null, 5);
    }

    public ManagedThreadFactoryImpl(String name, ContextServiceImpl contextService) {
        this(name, contextService, 5);
    }

    public ManagedThreadFactoryImpl(String name, ContextServiceImpl contextService, int priority) {
        this.name = name;
        this.contextService = contextService;
        this.contextSetupProvider = contextService != null ? contextService.getContextSetupProvider() : null;
        this.priority = priority;
        this.threads = new ArrayList<Thread>();
        this.lock = new ReentrantLock();
    }

    public String getName() {
        return this.name;
    }

    public long getHungTaskThreshold() {
        return this.hungTaskThreshold;
    }

    public void setHungTaskThreshold(long hungTaskThreshold) {
        this.hungTaskThreshold = hungTaskThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread newThread(Runnable r) {
        this.lock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException(MANAGED_THREAD_FACTORY_STOPPED);
            }
            ContextHandle contextHandleForSetup = this.savedContextHandleForSetup != null ? this.savedContextHandleForSetup : (this.contextSetupProvider != null ? this.contextSetupProvider.saveContext(this.contextService) : null);
            Thread newThread = this.createThread(r, contextHandleForSetup);
            newThread.setDaemon(true);
            this.threads.add(newThread);
            Thread thread = newThread;
            return thread;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Thread createThread(Runnable runnable, ContextHandle contextHandleForSetup) {
        ManagedThread newThread = new ManagedThread(runnable, contextHandleForSetup);
        newThread.setPriority(this.priority);
        return newThread;
    }

    protected ForkJoinWorkerThread createWorkerThread(ForkJoinPool forkJoinPool, ContextHandle contextHandleForSetup) {
        WorkerThread newThread = new WorkerThread(forkJoinPool, contextHandleForSetup);
        newThread.setPriority(this.priority);
        return newThread;
    }

    protected void removeThread(Thread t) {
        this.lock.lock();
        try {
            this.threads.remove(t);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Collection<Thread> getThreads() {
        this.lock.lock();
        try {
            List<Thread> list = List.copyOf(this.threads);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void taskStarting(Thread t, ManagedFutureTask<?> task) {
        if (t instanceof ThreadWithTiming) {
            ThreadWithTiming mt = (ThreadWithTiming)((Object)t);
            mt.notifyTaskStarting(task);
        }
    }

    public void taskDone(Thread t) {
        if (t instanceof ThreadWithTiming) {
            ThreadWithTiming mt = (ThreadWithTiming)((Object)t);
            mt.notifyTaskDone();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            for (Thread t : this.threads) {
                this.shutdown(t);
                t.interrupt();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ContextSetupProvider getContextSetupProvider() {
        return this.contextSetupProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        this.lock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException(MANAGED_THREAD_FACTORY_STOPPED);
            }
            ContextHandle contextHandleForSetup = this.savedContextHandleForSetup != null ? this.savedContextHandleForSetup : (this.contextSetupProvider != null ? this.contextSetupProvider.saveContext(this.contextService) : null);
            ForkJoinWorkerThread newThread = this.createWorkerThread(pool, contextHandleForSetup);
            this.threads.add(newThread);
            ForkJoinWorkerThread forkJoinWorkerThread = newThread;
            return forkJoinWorkerThread;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void shutdown(Thread t) {
        if (t instanceof AbstractManagedThread) {
            AbstractManagedThread mt = (AbstractManagedThread)t;
            mt.shutdown();
        }
    }

    public class ManagedThread
    extends AbstractManagedThread
    implements ThreadWithTiming {
        private static final System.Logger LOG = System.getLogger(ManagedThread.class.getName());
        private final long threadStartTime;
        private final ContextHandle contextHandleForSetup;
        private volatile ManagedFutureTask<?> task;
        volatile long taskStartTime;

        public ManagedThread(Runnable target, ContextHandle contextHandleForSetup) {
            super(target);
            this.threadStartTime = System.currentTimeMillis();
            this.taskStartTime = 0L;
            this.setName(ManagedThreadFactoryImpl.this.name + "-Thread-" + ManagedThreadFactoryImpl.this.threadIdSequence.incrementAndGet());
            this.contextHandleForSetup = contextHandleForSetup;
            this.setUncaughtExceptionHandler((t, e) -> LOG.log(System.Logger.Level.WARNING, () -> "Thread with id " + t.getId() + " failed with exception: " + String.valueOf(e), e));
        }

        @Override
        public void run() {
            block8: {
                ContextHandle handle = null;
                try {
                    if (this.contextHandleForSetup != null) {
                        handle = ManagedThreadFactoryImpl.this.contextSetupProvider.setup(this.contextHandleForSetup);
                    }
                    if (this.isShutdown()) {
                        this.interrupt();
                    }
                    super.run();
                    if (handle == null) break block8;
                }
                catch (ThreadExpiredException ex) {
                    try {
                        LOG.log(System.Logger.Level.WARNING, () -> "Thread with id " + this.getId() + " expired.", (Throwable)ex);
                        if (handle != null) {
                            ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                        }
                        ManagedThreadFactoryImpl.this.removeThread(this);
                    }
                    catch (Throwable throwable) {
                        if (handle != null) {
                            ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                        }
                        ManagedThreadFactoryImpl.this.removeThread(this);
                        throw throwable;
                    }
                }
                ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
            }
            ManagedThreadFactoryImpl.this.removeThread(this);
        }

        @Override
        boolean cancelTask() {
            ManagedFutureTask<?> task = this.task;
            if (task != null) {
                return task.cancel(true);
            }
            return false;
        }

        @Override
        public String getTaskIdentityName() {
            ManagedFutureTask<?> task = this.task;
            if (task != null) {
                return task.getTaskIdentityName();
            }
            return "null";
        }

        @Override
        public long getTaskRunTime(long now) {
            if (this.task != null && this.taskStartTime > 0L) {
                long taskRunTime = now - this.taskStartTime;
                return taskRunTime > 0L ? taskRunTime : 0L;
            }
            return 0L;
        }

        @Override
        public long getThreadStartTime() {
            return this.threadStartTime;
        }

        @Override
        public boolean isTaskHung(long now) {
            if (ManagedThreadFactoryImpl.this.hungTaskThreshold > 0L) {
                return this.getTaskRunTime(now) - ManagedThreadFactoryImpl.this.hungTaskThreshold > 0L;
            }
            return false;
        }

        @Override
        public void notifyTaskDone() {
            this.taskStartTime = 0L;
            this.task = null;
        }

        @Override
        public void notifyTaskStarting(ManagedFutureTask<?> task) {
            this.taskStartTime = System.currentTimeMillis();
            this.task = task;
        }
    }

    class WorkerThread
    extends ForkJoinWorkerThread
    implements ThreadWithTiming {
        private static final System.Logger LOG = System.getLogger(WorkerThread.class.getName());
        public static final long NOT_STARTED = -1L;
        volatile long taskStartTime;
        final ContextHandle contextHandleForSetup;

        public WorkerThread(ForkJoinPool pool, ContextHandle contextHandleForSetup) {
            super(pool);
            this.taskStartTime = -1L;
            this.contextHandleForSetup = contextHandleForSetup;
            this.setUncaughtExceptionHandler((t, e) -> LOG.log(System.Logger.Level.WARNING, () -> "Thread with id " + t.getId() + " failed with exception: " + String.valueOf(e), e));
        }

        @Override
        protected void onTermination(Throwable exception) {
            super.onTermination(exception);
            ManagedThreadFactoryImpl.this.removeThread(this);
        }

        @Override
        public void run() {
            try {
                if (this.contextHandleForSetup != null) {
                    ManagedThreadFactoryImpl.this.contextSetupProvider.setup(this.contextHandleForSetup);
                }
                super.run();
            }
            catch (ThreadExpiredException ex) {
                LOG.log(System.Logger.Level.WARNING, () -> "Thread with id " + this.getId() + " expired.", (Throwable)ex);
            }
        }

        @Override
        public boolean isTaskHung(long now) {
            return this.taskStartTime != -1L && now - this.taskStartTime > ManagedThreadFactoryImpl.this.hungTaskThreshold;
        }

        @Override
        public void notifyTaskDone() {
            this.taskStartTime = -1L;
        }

        @Override
        public void notifyTaskStarting(ManagedFutureTask<?> task) {
            this.taskStartTime = System.currentTimeMillis();
        }
    }

    public static interface ThreadWithTiming {
        public void notifyTaskDone();

        public void notifyTaskStarting(ManagedFutureTask<?> var1);

        public boolean isTaskHung(long var1);
    }
}

