/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer.types;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonGenerator;
import java.nio.charset.StandardCharsets;
import org.eclipse.yasson.internal.JsonbConfigProperties;
import org.eclipse.yasson.internal.SerializationContextImpl;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.types.TypeSerializer;
import org.eclipse.yasson.internal.serializer.types.TypeSerializerBuilder;

class StringSerializer
extends TypeSerializer<String> {
    StringSerializer(TypeSerializerBuilder serializerBuilder) {
        super(serializerBuilder);
    }

    @Override
    void serializeValue(String value, JsonGenerator generator, SerializationContextImpl context) {
        String newString;
        JsonbConfigProperties configProperties = context.getJsonbContext().getConfigProperties();
        if (configProperties.isStrictIJson() && !(newString = new String(value.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8)).equals(value)) {
            throw new JsonbException(Messages.getMessage(MessageKeys.UNPAIRED_SURROGATE, new Object[0]));
        }
        generator.write(value);
    }
}

