/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.Animal;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.Bar;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.BarServlet;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.Cat;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.Dog;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.Foo;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.FooServlet;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.MyBinding;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.MyInterceptor;
import org.jboss.cdi.tck.shrinkwrap.ee.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.application6.ApplicationDescriptor;
import org.jboss.shrinkwrap.descriptor.api.application6.ModuleType;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@RunAsClient
@SpecVersion(spec="interceptors", version="1.2")
public class InterceptorEnvironmentJNDITest
extends AbstractTest {
    private static final String GREETING = "greeting";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String HELLO = "Hello";
    private static final String BYE = "Bye";
    private static final String FOO_GET = "foo?get=";
    private static final String BAR_GET = "bar?get=";
    @ArquillianResource(value=FooServlet.class)
    URL fooContextPath;
    @ArquillianResource(value=BarServlet.class)
    URL barContextPath;

    @Deployment(testable=false)
    public static EnterpriseArchive createTestArchive() {
        EnterpriseArchive enterpriseArchive = (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().notTestArchive()).withClasses(new Class[]{MyBinding.class, MyInterceptor.class, Animal.class})).noDefaultWebModule().build();
        StringAsset applicationXml = new StringAsset(((ApplicationDescriptor)((ModuleType)((ApplicationDescriptor)((ModuleType)((ApplicationDescriptor)((ApplicationDescriptor)Descriptors.create(ApplicationDescriptor.class)).version("6").applicationName("Test").createModule().ejb("test-ejb.jar").up()).createModule().getOrCreateWeb().webUri("test1.war").contextRoot("/test1").up()).up()).createModule().getOrCreateWeb().webUri("test2.war").contextRoot("/test2").up()).up()).exportAsString());
        enterpriseArchive.setApplicationXML((Asset)applicationXml);
        WebArchive fooArchive = (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withName("test1.war")).withClasses(new Class[]{FooServlet.class, Foo.class, Dog.class})).withWebXml((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createEnvEntry().envEntryName(GREETING).envEntryType(JAVA_LANG_STRING).envEntryValue(BYE).up())).withDefaultEjbModuleDependency().build();
        enterpriseArchive.addAsModule((Archive)fooArchive);
        WebArchive barArchive = (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withName("test2.war")).withClasses(new Class[]{BarServlet.class, Bar.class, Cat.class})).withWebXml((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createEnvEntry().envEntryName(GREETING).envEntryType(JAVA_LANG_STRING).envEntryValue(HELLO).up())).withDefaultEjbModuleDependency().build();
        enterpriseArchive.addAsModule((Archive)barArchive);
        return enterpriseArchive;
    }

    @Test(groups={"javaee-full"})
    @SpecAssertion(section="interceptor_environment", id="a")
    public void testInterceptorEnvironment() throws FailingHttpStatusCodeException, MalformedURLException, IOException {
        WebClient webClient = new WebClient();
        webClient.getPage(this.fooContextPath + FOO_GET + "init");
        String fooAnimalName = webClient.getPage(this.fooContextPath + FOO_GET + "name").getWebResponse().getContentAsString();
        String fooGreeting = webClient.getPage(this.fooContextPath + FOO_GET + GREETING).getWebResponse().getContentAsString();
        String fooInterceptorAnimalName = webClient.getPage(this.fooContextPath + FOO_GET + "intName").getWebResponse().getContentAsString();
        String fooInterceptorGreeting = webClient.getPage(this.fooContextPath + FOO_GET + "intGreeting").getWebResponse().getContentAsString();
        Assert.assertEquals((String)fooInterceptorGreeting, (String)fooGreeting);
        Assert.assertEquals((String)fooInterceptorAnimalName, (String)fooAnimalName);
        Assert.assertEquals((String)fooGreeting, (String)BYE);
        Assert.assertEquals((String)fooAnimalName, (String)"Dog");
        webClient.getPage(this.barContextPath + BAR_GET + "init");
        String barAnimalName = webClient.getPage(this.barContextPath + BAR_GET + "name").getWebResponse().getContentAsString();
        String barGreeting = webClient.getPage(this.barContextPath + BAR_GET + GREETING).getWebResponse().getContentAsString();
        String barInterceptorAnimalName = webClient.getPage(this.barContextPath + BAR_GET + "intName").getWebResponse().getContentAsString();
        String barInterceptorGreeting = webClient.getPage(this.barContextPath + BAR_GET + "intGreeting").getWebResponse().getContentAsString();
        Assert.assertEquals((String)barInterceptorGreeting, (String)barGreeting);
        Assert.assertEquals((String)barInterceptorAnimalName, (String)barAnimalName);
        Assert.assertEquals((String)barGreeting, (String)HELLO);
        Assert.assertEquals((String)barAnimalName, (String)"Cat");
    }
}

