/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.postconstruct;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.jboss.cdi.tck.tests.context.request.postconstruct.RequestContextObserver;
import org.jboss.cdi.tck.tests.context.request.postconstruct.SimpleBean;

@WebServlet(value={"/simple"})
public class SimpleInfoServlet
extends HttpServlet {
    @Inject
    RequestContextObserver observer;
    @Inject
    BeanManager beanManager;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Bean bean = this.beanManager.resolve(this.beanManager.getBeans(SimpleBean.class, new Annotation[0]));
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        SimpleBean simpleBean = (SimpleBean)bean.create(ctx);
        boolean isActive = simpleBean.isRequestContextActiveDuringPostConstruct();
        bean.destroy((Object)simpleBean, ctx);
        resp.getWriter().append("Active:" + isActive);
        resp.getWriter().append("\n");
        resp.getWriter().append("Initialized requests:" + this.observer.getInitializations().get());
        resp.getWriter().append("\n");
        resp.getWriter().append("Destroyed requests:" + this.observer.getDestructions().get());
        resp.setContentType("text/plain");
    }
}

