/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.sessioncontext;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.common.sessioncontext.AcceptIF;
import com.sun.ts.tests.ejb30.common.sessioncontext.TestIF;
import com.sun.ts.tests.ejb30.common.sessioncontext.Three1IF;
import com.sun.ts.tests.ejb30.common.sessioncontext.Three2IF;
import java.util.Properties;

public abstract class ClientBase
extends EETest {
    protected Properties props;
    private Three1IF sessionContextBean;
    private Three2IF sessionContextBean2;
    private TestIF testBean;
    private AcceptIF acceptBean;

    protected abstract Three1IF getSessionContextBean();

    protected abstract Three2IF getSessionContextBean2();

    protected abstract TestIF getTestBean();

    protected abstract AcceptIF getAcceptBean();

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        this.sessionContextBean = this.getSessionContextBean();
        this.sessionContextBean2 = this.getSessionContextBean2();
        this.testBean = this.getTestBean();
        this.acceptBean = this.getAcceptBean();
    }

    public void cleanup() throws Exception {
    }

    protected void removeBeans() {
        if (this.sessionContextBean != null) {
            try {
                this.sessionContextBean.remove();
                TLogger.log("Successfully removed sessionContextBean.");
            }
            catch (Exception e) {
                TLogger.log("Exception while removing sessionContextBean " + e);
            }
        }
        if (this.sessionContextBean2 != null) {
            try {
                this.sessionContextBean2.remove();
                TLogger.log("Successfully removed sessionContextBean2.");
            }
            catch (Exception e) {
                TLogger.log("Exception while removing sessionContextBean2 " + e);
            }
        }
        if (this.testBean != null) {
            try {
                this.testBean.remove();
                TLogger.log("Successfully removed testBean.");
            }
            catch (Exception e) {
                TLogger.log("Exception while removing testBean " + e);
            }
        }
        if (this.acceptBean != null) {
            try {
                this.acceptBean.remove();
                TLogger.log("Successfully removed acceptBean.");
            }
            catch (Exception e) {
                TLogger.log("Exception while removing acceptBean " + e);
            }
        }
    }

    public void getBusinessObjectRemote1() throws Exception {
        try {
            Three1IF three1IF = this.sessionContextBean.getBusinessObjectRemote1();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void getBusinessObjectRemote1Illegal() throws Exception {
        try {
            this.sessionContextBean.getBusinessObjectRemote1Illegal();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void getBusinessObjectRemote2() throws Exception {
        try {
            Three2IF three2IF = this.sessionContextBean2.getBusinessObjectRemote2();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void getBusinessObjectLocal1() throws Exception {
        try {
            this.testBean.getBusinessObjectLocal1();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void getBusinessObjectLocal1Illegal() throws Exception {
        try {
            this.testBean.getBusinessObjectLocal1Illegal();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void getBusinessObjectLocal2() throws Exception {
        try {
            this.testBean.getBusinessObjectLocal2();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void passBusinessObjectRemote1() throws Exception {
        try {
            Three1IF bob = this.sessionContextBean.getBusinessObjectRemote1();
            this.acceptBean.accept(bob);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void passBusinessObjectRemote2() throws Exception {
        try {
            Three2IF bob = this.sessionContextBean2.getBusinessObjectRemote2();
            this.acceptBean.accept(bob);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void passBusinessObjectLocal1() throws Exception {
        try {
            this.testBean.passBusinessObjectLocal1();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void passBusinessObjectLocal2() throws Exception {
        try {
            this.testBean.passBusinessObjectLocal2();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void lookupIllegalArgumentException() throws Exception {
        try {
            this.testBean.lookupIllegalArgumentException();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void getInvokedBusinessInterfaceRemote1() throws Exception {
        String expected = Three1IF.class.getName();
        String actual = null;
        try {
            Class intf = this.sessionContextBean.getInvokedBusinessInterfaceRemote1();
            actual = intf.getName();
            if (!expected.equals(actual)) {
                throw new Exception("Expected class: " + expected + ", actual:" + actual);
            }
            TLogger.log("Got expected invoked business interface: " + expected);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void getInvokedBusinessInterfaceRemote2() throws Exception {
        String expected = Three2IF.class.getName();
        String actual = null;
        try {
            Class intf = this.sessionContextBean2.getInvokedBusinessInterfaceRemote2();
            actual = intf.getName();
            if (!expected.equals(actual)) {
                throw new Exception("Expected class: " + expected + ", actual:" + actual);
            }
            TLogger.log("Got expected invoked business interface: " + expected);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void getInvokedBusinessInterfaceLocal1() throws Exception {
        try {
            this.testBean.getInvokedBusinessInterfaceLocal1();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }

    public void getInvokedBusinessInterfaceLocal2() throws Exception {
        try {
            this.testBean.getInvokedBusinessInterfaceLocal2();
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
    }
}

