/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesT3;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.io.Serializable;
import java.util.Properties;

public class MsgBeanMsgTestT3
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private TopicConnectionFactory tFactory = null;
    private QueueConnection qConnection = null;
    private TopicConnection tConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private Topic topic = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private TopicPublisher tPublisher = null;
    private TopicSession tSession = null;

    public MsgBeanMsgTestT3() {
        TestUtil.logTrace((String)"@MsgBeanMsgTest3()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesT3  - @MsgBeanMsgTest3-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                System.out.println("qFactory error");
            }
            System.out.println("got a qFactory !!");
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            if (this.tFactory == null) {
                System.out.println("tFactory error");
            }
            System.out.println("got a tFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                System.out.println("queueR error");
            }
            this.topic = (Topic)this.context.lookup("java:comp/env/jms/MDB_TOPIC");
            if (this.topic == null) {
                System.out.println("topic error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        TestUtil.logTrace((String)("from jms.ee.mdb.mdb_msgTypesT3 @onMessage!" + msg));
        try {
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                System.out.println("connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            this.tConnection = this.tFactory.createTopicConnection();
            if (this.tConnection == null) {
                System.out.println("connection error");
            } else {
                this.tConnection.start();
                this.tSession = this.tConnection.createTopicSession(true, 0);
            }
            if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicTextTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicTextTestCreate - create the message");
                this.msgClearBodyTopicTextTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicTextTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicTextTest - read and verify the message");
                this.msgClearBodyTopicTextTest((TextMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicObjectTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicObjectTestCreate - create the message");
                this.msgClearBodyTopicObjectTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicObjectTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicObjectTest - read and verify the message");
                this.msgClearBodyTopicObjectTest((ObjectMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicMapTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicMapTestCreate - create the message");
                this.msgClearBodyTopicMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicMapTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicMapTest - read and verify the message");
                this.msgClearBodyTopicMapTest((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicBytesTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicBytesTestCreate - create the message");
                this.msgClearBodyTopicBytesTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicBytesTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicBytesTest - read and verify the message");
                this.msgClearBodyTopicBytesTest((BytesMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicStreamTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicStreamTestCreate - create the message");
                this.msgClearBodyTopicStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicStreamTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyTopicStreamTest - read and verify the message");
                this.msgClearBodyTopicStreamTest((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgResetTopicTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgResetTopicTest - read and verify the message");
                this.msgResetTopicTest();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidTopicStreamTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running readNullCharNotValidTopicStreamTestCreate - read and verify the message");
                this.readNullCharNotValidTopicStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidTopicStreamTest")) {
                TestUtil.logTrace((String)"@onMessage - running readNullCharNotValidTopicStreamTest - read and verify the message");
                this.readNullCharNotValidTopicStreamTest((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidTopicMapTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running readNullCharNotValidTopicMapTestCreate - read and verify the message");
                this.readNullCharNotValidTopicMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidTopicMapTest")) {
                TestUtil.logTrace((String)"@onMessage - running readNullCharNotValidTopicMapTest - read and verify the message");
                this.readNullCharNotValidTopicMapTest((MapMessage)msg);
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
                TestUtil.logTrace((String)("Do not have a method for this testcase: " + msg.getStringProperty("TestCase")));
            }
            TestUtil.logTrace((String)"@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            if (this.tConnection != null) {
                try {
                    this.tConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void msgClearBodyTopicTextTestCreate() {
        try {
            TextMessage messageSent = null;
            messageSent = this.qSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("TestCase", "msgClearBodyTopicTextTest");
            TestUtil.logTrace((String)"sending a Text message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyTopicObjectTestCreate() {
        try {
            ObjectMessage messageSentObjectMsg = null;
            TestUtil.logTrace((String)"Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.qSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)messageSentObjectMsg, (Properties)this.p);
            messageSentObjectMsg.setObject((Serializable)((Object)"Initial message"));
            messageSentObjectMsg.setStringProperty("TestCase", "msgClearBodyTopicObjectTest");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentObjectMsg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyTopicMapTestCreate() {
        try {
            MapMessage messageSentMapMessage = null;
            TestUtil.logTrace((String)"Send MapMessage to Topic.");
            messageSentMapMessage = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSentMapMessage, (Properties)this.p);
            messageSentMapMessage.setStringProperty("TestCase", "msgClearBodyTopicMapTest");
            messageSentMapMessage.setString("aString", "Initial message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentMapMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyTopicBytesTestCreate() {
        byte bValue = 127;
        try {
            BytesMessage messageSentBytesMessage = null;
            TestUtil.logTrace((String)"Send BytesMessage to Topic.");
            messageSentBytesMessage = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, (Properties)this.p);
            messageSentBytesMessage.setStringProperty("TestCase", "msgClearBodyTopicBytesTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentBytesMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyTopicStreamTestCreate() {
        try {
            StreamMessage messageSentStreamMessage = null;
            TestUtil.logTrace((String)"sending a Stream message");
            messageSentStreamMessage = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSentStreamMessage, (Properties)this.p);
            messageSentStreamMessage.setStringProperty("TestCase", "msgClearBodyTopicStreamTest");
            messageSentStreamMessage.writeString("Testing...");
            TestUtil.logTrace((String)"Sending message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentStreamMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyTopicTextTest(TextMessage messageReceived) {
        String testCase = "msgClearBodyTopicTextTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Test TextMessage ");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceived.getText()));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceived.clearBody();
            if (messageReceived.getText() == null) {
                TestUtil.logTrace((String)"Empty body after clearBody as expected: null");
            } else {
                TestUtil.logTrace((String)"Fail: message body was not empty");
                pass = false;
            }
            if (messageReceived.getStringProperty("TestCase").equals("msgClearBodyTopicTextTest")) {
                TestUtil.logTrace((String)"Pass: Text properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Text properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write and read 2nd contents");
            messageReceived.setText("new data");
            if (messageReceived.getText().equals("new data")) {
                TestUtil.logTrace((String)"Pass:");
            } else {
                TestUtil.logTrace((String)"Fail:");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyTopicObjectTest(ObjectMessage messageReceivedObjectMsg) {
        String testCase = "msgClearBodyTopicObjectTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Testing Object message");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceivedObjectMsg.getObject()));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedObjectMsg.clearBody();
            if (messageReceivedObjectMsg.getObject() == null) {
                TestUtil.logTrace((String)"Empty body after clearBody as expected: null");
            } else {
                TestUtil.logTrace((String)"Fail: message body was not empty");
                pass = false;
            }
            if (messageReceivedObjectMsg.getStringProperty("TestCase").equals("msgClearBodyTopicObjectTest")) {
                TestUtil.logTrace((String)"Pass: Object properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Object properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write 2nd contents");
            messageReceivedObjectMsg.setObject((Serializable)((Object)"new stuff here!!!!!!"));
            TestUtil.logTrace((String)"read 2nd contents");
            if (messageReceivedObjectMsg.getObject().equals("new stuff here!!!!!!")) {
                TestUtil.logTrace((String)"Pass:");
            } else {
                TestUtil.logTrace((String)"Fail: ");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgClearBodyTopicMapTest(MapMessage messageReceivedMapMessage) {
        String testCase = "msgClearBodyTopicMapTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Test for MapMessage ");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceivedMapMessage.getString("aString")));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedMapMessage.clearBody();
            if (messageReceivedMapMessage.getString("aString") == null) {
                TestUtil.logTrace((String)"Empty body after clearBody as expected: null");
            } else {
                TestUtil.logTrace((String)"Fail: message body was not empty");
                pass = false;
            }
            if (messageReceivedMapMessage.getStringProperty("TestCase").equals("msgClearBodyTopicMapTest")) {
                TestUtil.logTrace((String)"Pass: Map properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Map properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write 2nd contents");
            messageReceivedMapMessage.setString("yes", "new stuff !!!!!");
            TestUtil.logTrace((String)"read 2nd contents");
            if (messageReceivedMapMessage.getString("yes").equals("new stuff !!!!!")) {
                TestUtil.logTrace((String)"PASS:");
            } else {
                TestUtil.logTrace((String)"FAIL:");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyTopicBytesTest(BytesMessage messageReceivedBytesMessage) {
        String testCase = "msgClearBodyTopicBytesTest";
        boolean pass = true;
        byte bValue2 = 22;
        try {
            TestUtil.logTrace((String)"Test BytesMessage ");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceivedBytesMessage.readByte()));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedBytesMessage.clearBody();
            TestUtil.logTrace((String)"Bytes message body should now be empty and in writeonly mode");
            try {
                byte b = messageReceivedBytesMessage.readByte();
                TestUtil.logTrace((String)"Fail: MessageNotReadableException not thrown as expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageNotReadableException) {
                    TestUtil.logTrace((String)"Pass: MessageNotReadableException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            if (messageReceivedBytesMessage.getStringProperty("TestCase").equals("msgClearBodyTopicBytesTest")) {
                TestUtil.logTrace((String)"Pass: Bytes msg properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Bytes msg properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write 2nd contents");
            messageReceivedBytesMessage.writeByte(bValue2);
            TestUtil.logTrace((String)"read 2nd contents");
            messageReceivedBytesMessage.reset();
            if (messageReceivedBytesMessage.readByte() == bValue2) {
                TestUtil.logTrace((String)"Pass:");
            } else {
                TestUtil.logTrace((String)"Fail:");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyTopicStreamTest(StreamMessage messageReceivedStreamMessage) {
        String testCase = "msgClearBodyTopicStreamTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Test StreamMessage ");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceivedStreamMessage.readString()));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedStreamMessage.clearBody();
            TestUtil.logTrace((String)"Stream message body should now be empty and in writeonly mode");
            try {
                String s = messageReceivedStreamMessage.readString();
                TestUtil.logTrace((String)"Fail: MessageNotReadableException should have been thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageNotReadableException) {
                    TestUtil.logTrace((String)"Pass: MessageNotReadableException thrown as expected");
                }
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            if (messageReceivedStreamMessage.getStringProperty("TestCase").equals("msgClearBodyTopicStreamTest")) {
                TestUtil.logTrace((String)"Pass: Stream msg properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Stream msg properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write 2nd contents");
            messageReceivedStreamMessage.writeString("new data");
            TestUtil.logTrace((String)"read 2nd contents");
            messageReceivedStreamMessage.reset();
            if (messageReceivedStreamMessage.readString().equals("new data")) {
                TestUtil.logTrace((String)"Pass:");
            } else {
                TestUtil.logTrace((String)"Fail:");
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgResetTopicTest() {
        boolean pass = true;
        int nInt = 1000;
        String testCase = "msgResetTopicTest";
        try {
            StreamMessage messageSentStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            try {
                TestUtil.logTrace((String)"creating a Stream message");
                messageSentStreamMessage = this.qSession.createStreamMessage();
                JmsUtil.addPropsToMessage((Message)messageSentStreamMessage, (Properties)this.p);
                messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetTopicTest1");
                messageSentStreamMessage.writeString("Testing...");
                TestUtil.logTrace((String)"reset stream message -  now  should be in readonly mode");
                messageSentStreamMessage.reset();
                messageSentStreamMessage.writeString("new data");
                TestUtil.logTrace((String)"Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                TestUtil.logTrace((String)"Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            try {
                TestUtil.logTrace((String)"creating a Byte message");
                messageSentBytesMessage = this.qSession.createBytesMessage();
                JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, (Properties)this.p);
                messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetTopicTest2");
                messageSentBytesMessage.writeInt(nInt);
                TestUtil.logTrace((String)"reset Byte message -  now  should be in readonly mode");
                messageSentBytesMessage.reset();
                messageSentBytesMessage.writeInt(nInt);
                TestUtil.logTrace((String)"Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                TestUtil.logTrace((String)"Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void readNullCharNotValidTopicMapTestCreate() {
        try {
            MapMessage mapSent = null;
            boolean pass = true;
            mapSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)mapSent, (Properties)this.p);
            mapSent.setStringProperty("TestCase", "readNullCharNotValidTopicMapTest");
            TestUtil.logTrace((String)"Write a null string to the map message object with mapMessage.setString");
            mapSent.setString("WriteANull", null);
            TestUtil.logTrace((String)" Send the message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)mapSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void readNullCharNotValidTopicStreamTestCreate() {
        try {
            StreamMessage messageSent = null;
            boolean pass = true;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("TestCase", "readNullCharNotValidTopicStreamTest");
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("TestCase", "readNullCharNotValidTopicStreamTest");
            TestUtil.logTrace((String)"Write a null string to the map message object with streamMessage.setString");
            messageSent.writeString(null);
            TestUtil.logTrace((String)" Send the message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNullCharNotValidTopicMapTest(MapMessage mapReceived) {
        String testCase = "readNullCharNotValidTopicMapTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Use readChar to read a null  ");
            try {
                char c = mapReceived.getChar("WriteANull");
                TestUtil.logTrace((String)"Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                TestUtil.logTrace((String)"Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNullCharNotValidTopicStreamTest(StreamMessage messageReceived) {
        String testCase = "readNullCharNotValidTopicStreamTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Use readChar to read a null  ");
            try {
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                TestUtil.logTrace((String)"Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            TestUtil.logTrace((String)"Sending response message");
            TestUtil.logTrace((String)("==================================Test Results from: " + testCase));
            TestUtil.logTrace((String)("==================================Status: " + results));
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            TestUtil.logTrace((String)("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown"));
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logTrace((String)("Error: " + ee.getClass().getName() + " was thrown"));
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesT3  In MsgBeanMsgTest3::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesT3  In MsgBeanMsgTest3::remove()!!");
    }
}

