/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.methodexpression;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.Expression;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "methodexpression_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    private static final String NL = System.getProperty("line.seperator", "\n");
    private Properties testProps;

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="methodexpression_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"methodexpression_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, BarELResolver.class, ResolverTest.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TCKFunctionMapper.class, EmployeeELResolver.class, VariableELResolver.class, VectELResolver.class, FunctionELResolver.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", servlet_vehicle);
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="jsp")
    public void positiveMethodExpressionTest() throws Exception {
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        StringBuffer buf = new StringBuffer();
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext simpleContext = new SimpleELContext(ResolverType.VECT_ELRESOLVER);
            ELContext context = simpleContext.getELContext();
            Object[] params1 = new Object[]{"new member"};
            Class[] paramTypes1 = new Class[]{Object.class};
            String exprStr1 = "#{vect.add}";
            MethodExpression mexp1 = expFactory.createMethodExpression(context, exprStr1, Boolean.TYPE, paramTypes1);
            pass1 = ExpressionTest.testMethodExpression((MethodExpression)mexp1, (ELContext)context, (String)exprStr1, (Object[])params1, (Object)Boolean.TRUE, (boolean)false, (StringBuffer)buf);
            Object[] params2 = new Object[]{0, "new member"};
            Class[] paramTypes2 = new Class[]{Integer.TYPE, Object.class};
            String exprStr2 = "#{vect.add}";
            MethodExpression mexp2 = expFactory.createMethodExpression(context, exprStr2, null, paramTypes2);
            pass2 = ExpressionTest.testMethodExpression((MethodExpression)mexp2, (ELContext)context, (String)exprStr2, (Object[])params2, null, (boolean)false, (StringBuffer)buf);
            Object[] params3 = null;
            Class[] paramTypes3 = new Class[]{};
            String exprStr3 = "true";
            MethodExpression mexp3 = expFactory.createMethodExpression(context, exprStr3, String.class, paramTypes3);
            pass3 = ExpressionTest.testMethodExpression((MethodExpression)mexp3, (ELContext)context, (String)exprStr3, params3, (Object)"true", (boolean)true, (StringBuffer)buf);
            Object[] params4 = null;
            Class[] paramTypes4 = new Class[]{};
            String exprStr4 = "true";
            MethodExpression mexp4 = expFactory.createMethodExpression(context, exprStr4, Boolean.class, paramTypes4);
            pass4 = ExpressionTest.testMethodExpression((MethodExpression)mexp4, (ELContext)context, (String)exprStr4, params4, (Object)Boolean.TRUE, (boolean)true, (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("Test FAILED" + buf.toString());
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void negativeMethodExpressionTest() throws Exception {
        boolean pass = true;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        SimpleELContext simpleContext = new SimpleELContext(ResolverType.VECT_ELRESOLVER);
        ELContext context = simpleContext.getELContext();
        Object[] params = new Object[]{"new member"};
        Class[] paramTypes = new Class[]{Object.class};
        String exprStr1 = "#{vect.add}";
        MethodExpression mexp1 = expFactory.createMethodExpression(context, exprStr1, Boolean.TYPE, paramTypes);
        try {
            mexp1.getMethodInfo(null);
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() with null ELContext parameter did not" + NL));
            TestUtil.logErr((String)(" cause an exception to be thrown" + NL));
        }
        catch (NullPointerException npe) {
            TestUtil.logMsg((String)("Expected Exception Thrown, when Null ELContext passed to getMethodInfo(): " + npe.getClass().getSimpleName()));
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() with null ELContext threw the wrong Exception!" + NL + "Expected: NullPointerException" + NL + "Received: " + e.toString() + NL));
            e.printStackTrace();
        }
        try {
            mexp1.invoke(null, params);
            pass = false;
            TestUtil.logErr((String)("Call to invoke() with null ELContext parameter did not" + NL));
            TestUtil.logErr((String)(" cause an exception to be thrown" + NL));
        }
        catch (NullPointerException npe) {
            TestUtil.logMsg((String)("Expected Exception Thrown, when Null ELContext passed to invoke(): " + npe.getClass().getSimpleName()));
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to invoke() with null ELContext throw the wrong Exception!" + NL + "Expected: NullPointerException" + NL + "Received: " + e.toString() + NL));
            e.printStackTrace();
        }
        String exprStr2 = "#{vect.noSuchMethod}";
        MethodExpression mexp2 = expFactory.createMethodExpression(context, exprStr2, Boolean.TYPE, paramTypes);
        try {
            mexp2.getMethodInfo(context);
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() for non-existent method did not cause" + NL));
            TestUtil.logErr((String)(" an exception to be thrown" + NL));
        }
        catch (MethodNotFoundException mnfe) {
            TestUtil.logMsg((String)("Expected Exception Thrown, when method does not exists for getMethodInfo(): " + ((Object)((Object)mnfe)).getClass().getSimpleName()));
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() for non-existent method threw the wrong exception!" + NL + "Expected: MethodNotFoundException" + NL + "Received: " + e.toString() + NL));
            e.printStackTrace();
        }
        try {
            mexp2.invoke(context, params);
            pass = false;
            TestUtil.logErr((String)("Call to invoke() for non-existent method did not cause" + NL));
            TestUtil.logErr((String)(" an exception to be thrown" + NL));
        }
        catch (MethodNotFoundException mnfe) {
            TestUtil.logMsg((String)("Expected Exception Thrown, when method does not exists for invoke(): " + ((Object)((Object)mnfe)).getClass().getSimpleName()));
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() for non-existent method threw the wrong exception!" + NL + "Expected: MethodNotFoundException" + NL + "Received: " + e.toString() + NL));
            e.printStackTrace();
        }
        String exprStr3 = "#{wect.add}";
        MethodExpression mexp3 = expFactory.createMethodExpression(context, exprStr3, Boolean.TYPE, paramTypes);
        try {
            mexp3.getMethodInfo(context);
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() for non-existent property did not cause" + NL));
            TestUtil.logErr((String)(" an exception to be thrown" + NL));
        }
        catch (PropertyNotFoundException pnfe) {
            TestUtil.logMsg((String)("Expected Exception Thrown, No such property in ELContextfor getMethodInfo(): " + ((Object)((Object)pnfe)).getClass().getSimpleName()));
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() for non-existent property threw the wrong exception!" + NL + "Expected: PropertyNotFoundException" + NL + "Received: " + e.toString() + NL));
            e.printStackTrace();
        }
        try {
            mexp3.invoke(context, params);
            pass = false;
            TestUtil.logErr((String)("Call to invoke() for non-existent property did not cause" + NL));
            TestUtil.logErr((String)(" an exception to be thrown" + NL));
        }
        catch (PropertyNotFoundException pnfe) {
            TestUtil.logMsg((String)("Expected Exception Thrown, No such property in ELContextfor invoke(): " + ((Object)((Object)pnfe)).getClass().getSimpleName()));
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to invoke() for non-existent property threw the wrong exception!" + NL + "Expected: PropertyNotFoundException" + NL + "Received: " + e.toString() + NL));
            e.printStackTrace();
        }
        String exprStr4 = "literal";
        MethodExpression mexp4 = expFactory.createMethodExpression(context, exprStr4, Void.TYPE, paramTypes);
        try {
            mexp4.invoke(context, params);
            pass = false;
            TestUtil.logErr((String)("Call to invoke() for string literal with expected return" + NL));
            TestUtil.logErr((String)(" value of void did not cause an exception to be thrown" + NL));
        }
        catch (ELException ee) {
            TestUtil.logMsg((String)("Expected Exception Thrown. Call to invoke() with string literal ELContext for invoke()." + NL + "Expected return type is void: " + ((Object)((Object)ee)).getClass().getSimpleName()));
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to invoke() for string literal with expected return" + NL + "value of void caused the wrong exception to be thrown!" + NL + "Expected: ELException: " + NL + "Received: " + e.toString()));
            e.printStackTrace();
        }
        String exprStr5 = "literal";
        MethodExpression mexp5 = expFactory.createMethodExpression(context, exprStr5, Double.class, paramTypes);
        try {
            mexp5.invoke(context, params);
            pass = false;
            TestUtil.logErr((String)("Call to invoke() for string literal with non-coercable expected " + NL));
            TestUtil.logErr((String)("return value did not cause an exception to be thrown" + NL));
        }
        catch (ELException ee) {
            TestUtil.logMsg((String)("Expected Exception Thrown. Call to invoke() with string literal ELContext for invoke()." + NL + "Expected return type can't be coerced: " + ((Object)((Object)ee)).getClass().getSimpleName()));
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to invoke() for string literal with non-coercable expected " + NL + "return value caused the wrong exception to be thrown!" + NL + "Expected: ELException: " + NL + "Received: " + e.toString()));
            e.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void methodExpressionSerializableTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        Class[] paramTypes = new Class[]{Object.class};
        String exprStr = "#{vect.add}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new SimpleELContext().getELContext();
            MethodExpression evalmexp = expFactory.createMethodExpression(context, exprStr, Boolean.class, paramTypes);
            TestUtil.logTrace((String)("Eval Method Expression For Testing: " + evalmexp.toString() + NL));
            MethodExpression literalmexp = expFactory.createMethodExpression(context, "vect.add", Boolean.class, paramTypes);
            TestUtil.logTrace((String)("Literal Method Expression For Testing: " + literalmexp.toString() + NL));
            if (!ExpressionTest.expressionSerializableTest((Expression)evalmexp, (StringBuffer)buf) || !ExpressionTest.expressionSerializableTest((Expression)literalmexp, (StringBuffer)buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void methodExpressionMatchingExactPreferredTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetA('text')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression((MethodExpression)me, (ELContext)context, (String)exprStr, null, (Object)"String", (boolean)false, (StringBuffer)buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL));
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void methodExpressionMatchingOverloadBeatsCoercionTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetB('1')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression((MethodExpression)me, (ELContext)context, (String)exprStr, null, (Object)"CharSequence", (boolean)false, (StringBuffer)buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL));
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void methodExpressionMatchingOverloadBeatsExactVarArgsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetC('aaa','bbb')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression((MethodExpression)me, (ELContext)context, (String)exprStr, null, (Object)"CharSequence-CharSequence", (boolean)false, (StringBuffer)buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL));
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void methodExpressionMatchingCoercionBeatsExactVarArgsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetD('1','1')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression((MethodExpression)me, (ELContext)context, (String)exprStr, null, (Object)"Long-Long", (boolean)false, (StringBuffer)buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL));
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void methodExpressionMatchingVarArgsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetD('aaa','bbb')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression((MethodExpression)me, (ELContext)context, (String)exprStr, null, (Object)"String-Strings", (boolean)false, (StringBuffer)buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL));
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void methodExpressionMatchingAmbiguousTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetE('1234',1234)}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            me.getMethodInfo(context);
            pass = false;
        }
        catch (MethodNotFoundException mnfe) {
            pass = true;
        }
        catch (Exception ex) {
            pass = false;
            TestUtil.logErr((String)("Call to getMethodInfo() with ambiguous method expression threw the wrong Exception!" + NL + "Expected: MethodNotFoundException" + NL + "Received: " + ex.toString() + NL));
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }
}

