/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.collectionoperators;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.Customer;
import com.sun.ts.tests.el.common.util.DataBase;
import com.sun.ts.tests.el.common.util.Date;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.Order;
import com.sun.ts.tests.el.common.util.Product;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import jakarta.el.ELProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "collectionoperators_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    private ELProcessor elp;
    private DataBase database;
    Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String jsp_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", jsp_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="collectionoperators_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"collectionoperators_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, EmployeeELResolver.class, FunctionELResolver.class, VariableELResolver.class, VectELResolver.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TestNum.class, TypesBean.class, Validator.class, DataBase.class, Customer.class, Product.class, Order.class, Date.class, TCKFunctionMapper.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionMapFilterTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"[Toy Story, 10.0]", "[History of Golf, 11.0]"};
        String[] expr2 = new String[]{"20", "30", "40"};
        this.testIterable("map-filter-one", "products.stream().filter(p->p.unitPrice >= 10 && p.unitPrice < 12).sorted((p,q)->p.unitPrice-q.unitPrice).map(p->[p.name,p.unitPrice]).toList()", expr1);
        this.testIterable("map-filter-two", "[1,2,3,4].stream().filter(i->i > 1).map(i->i*10).toList()", expr2);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionMinTest() throws Exception {
        this.buildELContext();
        this.testStream("min", "[2,3,1,5].stream().min().get()", 1L);
        this.elp.eval("comparing = map->(x,y)->map(x).compareTo(map(y))");
        this.testStream("min", "[3,2,1].stream().min((i,j)->i-j).get()", 1L);
        this.testStream("min", "customers.stream().min((x,y)->x.orders.size()-y.orders.size()).get().name", "Charlie Yeh");
        this.elp.eval("comparing = map->(x,y)->map(x).compareTo(map(y))");
        this.testStream("min", "customers.stream().min(comparing(c->c.orders.size())).get().name", "Charlie Yeh");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionMaxTest() throws Exception {
        this.buildELContext();
        this.testStream("max", "[2,3,1,5].stream().max().get()", 5L);
        this.testStream("max", "['xy', 'xyz', 'abc'].stream().max().get()", "xyz");
        this.testStream("max", "[2].stream().max((i,j)->i-j).get()", 2L);
        this.elp.eval("comparing = map->(x,y)->map(x).compareTo(map(y))");
        this.testStream("max", "customers.stream().max((x,y)->x.orders.size()-y.orders.size()).get().name", "John Doe");
        this.testStream("max", "customers.stream().max(comparing(c->c.orders.size())).get().name", "John Doe");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionDistinctTest() throws Exception {
        this.buildELContext();
        this.testIterable("distinct", " ['a', 'b', 'b', 'c'].stream().distinct().toList()", new String[]{"a", "b", "c"});
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionForEachTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"Eagle", "Coming Home", "Greatest Hits", "History of Golf", "Toy Story", "iSee"};
        this.testIterable("forEach", "lst = []; products.stream().forEach(p->lst.add(p.name)); lst", expr1);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionFindFirstTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"Product: 200, Eagle, book, 12.5, 100"};
        this.testIterable("findFirst", "products.stream().sorted(p->p.unitPrice).findFirst().get()", expr1);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionLimitTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"[Product: 202, Greatest Hits, cd, 6.5, 200]"};
        String[] expr2 = new String[]{"Product: 202, Greatest Hits, cd, 6.5, 200", "Product: 201, Coming Home, dvd, 8.0, 50"};
        this.testIterable("limit", "products.stream().sorted((p,q)->p.unitPrice-q.unitPrice).limit(1).toList()", expr1);
        this.testIterable("limit", "products.stream().sorted((p,q)->p.unitPrice-q.unitPrice).limit(2).toList()", expr2);
    }

    public void elCollectionAnyMatchTest() throws Exception {
        this.buildELContext();
        this.testIterable("anyMatch_True", "products.stream().anyMatch(p->p.unitPrice >= 10)", true);
        this.testIterable("anyMatch_False", "products.stream().anyMatch(p->p.unitPrice == 100)", false);
    }

    public void elCollectionNoneMatchTest() throws Exception {
        this.buildELContext();
        this.testIterable("noneMatch_False", "products.stream().noneMatch(p->p.unitPrice >= 10)", false);
        this.testIterable("noneMatch_True", "products.stream().noneMatch(p->p.unitPrice == 100)", true);
    }

    public void elCollectionAllMatchTest() throws Exception {
        this.buildELContext();
        this.testIterable("allMatch_true", "products.stream().allMatch(p->p.unitPrice >= 1)", true);
        this.testIterable("allMatch_false", "products.stream().allMatch(p->p.unitPrice == 100)", false);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionSumTest() throws Exception {
        this.buildELContext();
        this.testIterable("sum", "['10', '12', '13'].stream().sum()", new String[]{"35"});
        this.testIterable("sum_Empty", "[].stream().sum()", new String[]{"0"});
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionCountTest() throws Exception {
        this.buildELContext();
        this.testIterable("count", "[1,2,3,4,5].stream().count()", new String[]{"5"});
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionAverageTest() throws Exception {
        this.buildELContext();
        this.testStream("average_ints", "ints.stream().average().get()", 4.5);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionToArrayTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"Product: 200, Eagle, book, 12.5, 100", "Product: 205, iSee, book, 12.5, 150", "Product: 203, History of Golf, book, 11.0, 30", "Product: 202, Greatest Hits, cd, 6.5, 200", "Product: 204, Toy Story, dvd, 10.0, 1000", "Product: 201, Coming Home, dvd, 8.0, 50"};
        this.testArray("toArray", "products.stream().sorted(p->p.unitPrice).toArray()", expr1);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionReduceTest() throws Exception {
        this.buildELContext();
        this.testStream("reduce-one", "[1,2,3,4,5].stream().reduce(0, (l,r)->l+r)", 15L);
        this.testStream("reduce-two", "[1,2,3,4,5].stream().reduce((l,r)->l+r).get()", 15L);
        this.testStream("reduce-three", "[].stream().reduce((l,r)->l+r).orElse(101)", 101L);
        this.testStream("reduce-four", "[].stream().reduce((l,r)->l+r).orElseGet(()->101)", 101L);
        this.testStream("reduce-five", "c = 0; [1,2,3,4,5,6].stream().reduce(0, (l,r)->(c = c+1; c % 2 == 0? l+r: l-r))", 3L);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionSubStreamTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"2", "3", "4"};
        this.testIterable("substream-one", "[0,1,2,3,4].stream().substream(2).toList()", expr1);
        this.testIterable("substream-two", "[0,1,2,3,4,5,6].stream().substream(2,5).toList()", expr1);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionPeekTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"1", "2", "3", "4"};
        this.testIterable("peek-one", "lst = []; [1,2,3,4].stream().peek(i->lst.add(i)).toList()", expr1);
        this.testIterable("peek-two", "lst.stream().toList()", expr1);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionFlatMapTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"Order: 10, 100, 2/18/2010, 20.8", "Order: 11, 100, 5/3/2011, 34.5", "Order: 12, 100, 8/2/2011, 210.75", "Order: 13, 101, 1/15/2011, 50.23", "Order: 14, 101, 1/3/2012, 126.77"};
        this.testIterable("flatMap", "customers.stream().filter(c->c.country=='USA').flatMap(c->c.orders.stream()).toList()", expr1);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionSetLiteralTest() throws Exception {
        boolean pass = false;
        try {
            ELProcessor elp = new ELProcessor();
            String valueA = "myValueA";
            String valueB = "myValueB";
            elp.setVariable("aaa", "'" + valueA + "'");
            elp.setVariable("bbb", "'" + valueB + "'");
            Boolean result = (Boolean)elp.eval("{aaa,bbb}.contains(aaa)");
            pass = result;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Construction and use of a valid Set literal threw an Exception!" + TestUtil.NEW_LINE + "Received: " + e.toString() + TestUtil.NEW_LINE));
            e.printStackTrace();
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionListLiteralTest() throws Exception {
        boolean pass = false;
        try {
            ELProcessor elp = new ELProcessor();
            String valueA = "myValueA";
            String valueB = "myValueB";
            elp.setVariable("aaa", "'" + valueA + "'");
            elp.setVariable("bbb", "'" + valueB + "'");
            Object result = elp.eval("[aaa,bbb].get(1)");
            pass = valueB.equals(result);
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Construction and use of a valid List literal threw an Exception!" + TestUtil.NEW_LINE + "Received: " + e.toString() + TestUtil.NEW_LINE));
            e.printStackTrace();
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elCollectionMapLiteralTest() throws Exception {
        boolean pass = false;
        try {
            ELProcessor elp = new ELProcessor();
            String key = "myKey";
            String value = "myValue";
            elp.setVariable("aaa", "'" + key + "'");
            elp.setVariable("bbb", "'" + value + "'");
            Object result = elp.eval("{aaa:bbb}.get(aaa)");
            pass = value.equals(result);
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Construction and use of a valid Map literal threw an Exception!" + TestUtil.NEW_LINE + "Received: " + e.toString() + TestUtil.NEW_LINE));
            e.printStackTrace();
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    private void logLine(String s) {
        TestUtil.logMsg((String)s);
    }

    private void buildELContext() {
        this.elp = new ELProcessor();
        this.database = new DataBase();
        this.database.init();
        this.elp.defineBean("customers", this.database.getCustomers());
        this.elp.defineBean("products", this.database.getProducts());
        this.elp.defineBean("orders", this.database.getOrders());
        this.elp.defineBean("ints", this.database.getInts());
    }

    private void testIterable(String name, String query, String[] expected) throws Exception {
        int explength = 0;
        if (expected != null) {
            explength = expected.length;
        }
        this.logLine("=== Testing " + name + " ===");
        this.logLine(query);
        Object ret = this.elp.eval(query);
        int indx = 0;
        this.logLine(" = returns =");
        if (expected == null) {
            if (ret != null) {
                throw new Exception("TEST FAILED, Unexpected Value!" + ELTestUtil.NL + "Expected: null");
            }
            this.logLine(" null ");
        } else if (expected.length == 1) {
            String golden = expected[0];
            String result = ret.toString();
            this.logLine(" " + result);
            if (!golden.equals(result)) {
                throw new Exception("TEST FAILED, Unexpected Value!" + ELTestUtil.NL + "Expected: " + golden + ELTestUtil.NL + "Received: " + result);
            }
        } else {
            for (Object item : (Iterable)ret) {
                String result = item.toString();
                String golden = expected[indx++];
                this.logLine(" " + result);
                if (golden.equals(result)) continue;
                throw new Exception("TEST FAILED, Unexpected Value!" + ELTestUtil.NL + "Expected: " + golden + ELTestUtil.NL + "Received: " + result);
            }
            if (indx != explength) {
                throw new Exception("Test FAILED lenght incorrect!" + ELTestUtil.NL + "Expected: " + explength + ELTestUtil.NL + "Found: " + indx);
            }
        }
    }

    private void testIterable(String name, String query, Boolean expected) throws Exception {
        this.testIterable(name, query, new String[]{expected.toString()});
    }

    private void testArray(String name, String query, String[] expected) throws Exception {
        this.logLine("=== Test " + name + "===");
        this.logLine(query);
        Object arry = this.elp.eval(query);
        int gldLength = Array.getLength(arry);
        this.logLine(" = returns =");
        if (gldLength != expected.length) {
            throw new Exception("Test FAILED lenght incorrect!" + ELTestUtil.NL + "Expected: " + expected.length + ELTestUtil.NL + "Found: " + gldLength);
        }
        for (int indx = 0; gldLength < indx; ++indx) {
            String golden;
            String item = (String)Array.get(arry, indx);
            if (!item.equals(golden = expected[indx])) {
                throw new Exception("Test FAILED" + ELTestUtil.NL + "Expected: " + item + ELTestUtil.NL + "Received: " + golden);
            }
            this.logLine(" " + item);
        }
    }

    private void testStream(String name, String query, Object exp_value) throws Exception {
        this.logLine("=== Testing " + name + " ===");
        Object result = this.elp.eval(query);
        this.logLine("EL Quuery String: '" + query + "' -returns: " + result + "(" + result.getClass() + ")");
        if (!exp_value.equals(result)) {
            throw new Exception("Test FAILED" + ELTestUtil.NL + "Expected: " + exp_value + ELTestUtil.NL + "Received: " + result);
        }
    }
}

