/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.semicolonoperator;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import jakarta.el.ELProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientServletTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "semicolonoperator_servlet_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientServletTest.class.getName());
    Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientServletTest.inputStreamToString(inStream).replaceAll("el_servlet_vehicle", servlet_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="semicolonoperator_servlet_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"semicolonoperator_servlet_vehicle_web.war");
        servlet_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ServletVehicle.class, ExpressionTest.class, EmployeeELResolver.class, FunctionELResolver.class, VariableELResolver.class, VectELResolver.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TestNum.class, TypesBean.class, Validator.class, TCKFunctionMapper.class, ELClientServletTest.class});
        InputStream inStream = ELClientServletTest.class.getResourceAsStream("/vehicle/servlet/servlet_vehicle_web.xml");
        String webXml = ELClientServletTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        servlet_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        return servlet_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientServletTest theTests = new ELClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSemiColonOperatorBigDecimalTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "BigDecimal";
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a + b", BigDecimal.valueOf(2L), comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a * b", BigDecimal.valueOf(1L), comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a - b", BigDecimal.valueOf(0L), comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a % b", 0.0, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a mod b", 0.0, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSemiColonOperatorFloatTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Float";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logTrace((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            elp.eval(bValue);
            if ("BigInteger".equals(bName)) {
                Validator.testExpression(elp, "a = types.tckFloat; a + b", BigDecimal.valueOf(2L), comparitorA + " + " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a * b", BigDecimal.valueOf(1L), comparitorA + " * " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a - b", BigDecimal.valueOf(0L), comparitorA + " - " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            } else {
                Validator.testExpression(elp, "a = types.tckFloat; a + b", 2.0, comparitorA + " + " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a * b", 1.0, comparitorA + " * " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a - b", 0.0, comparitorA + " - " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a / b", 1.0, comparitorA + " / " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a div b", 1.0, comparitorA + " div " + bName);
            }
            Validator.testExpression(elp, "a = types.tckFloat; a % b", 0.0, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckFloat; a mod b", 0.0, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSemiColonOperatorDoubleTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Double";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logTrace((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            elp.eval(bValue);
            if ("BigInteger".equals(bName)) {
                Validator.testExpression(elp, "a = types.tckDouble; a + b", BigDecimal.valueOf(2L), comparitorA + " + " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a * b", BigDecimal.valueOf(1L), comparitorA + " * " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a - b", BigDecimal.valueOf(0L), comparitorA + " - " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            } else {
                Validator.testExpression(elp, "a = types.tckDouble; a + b", 2.0, comparitorA + " + " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a * b", 1.0, comparitorA + " * " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a - b", 0.0, comparitorA + " - " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a / b", 1.0, comparitorA + " / " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a div b", 1.0, comparitorA + " div " + bName);
            }
            Validator.testExpression(elp, "a = types.tckDouble; a % b", 0.0, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckDouble; a mod b", 0.0, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSemiColonOperatorBigIntegerTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "BigInteger";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Double");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logTrace((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckBigInteger; a + b", BigInteger.valueOf(2L), comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a * b", BigInteger.valueOf(1L), comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a - b", BigInteger.valueOf(0L), comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a % b", BigInteger.valueOf(0L), comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a mod b", BigInteger.valueOf(0L), comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSemiColonOperatorIntegerTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Integer";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Double");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logTrace((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckInteger; a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSemiColonOperatorLongTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Long";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logTrace((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckLong; a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSemiColonOperatorShortTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Short";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logTrace((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckShort; a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSemiColonOperatorByteTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Byte";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        excludeList.add("Short");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                TestUtil.logTrace((String)("*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***"));
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckByte; a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSemiColonOperatorNullTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        elp.defineBean("types", (Object)new TypesBean());
        Long expected = 0L;
        String bValue = "b = types.tckNull";
        elp.eval(bValue);
        Validator.testExpression(elp, "a = null; a + b", expected, "null + null");
        Validator.testExpression(elp, "a = null; a - b", expected, "null - null");
        Validator.testExpression(elp, "a = null; a * b", expected, "null * null");
        Validator.testExpression(elp, "a = null; a / b", expected, "null / null");
        Validator.testExpression(elp, "a = null; a div b", expected, "null div null");
        Validator.testExpression(elp, "a = null; a % b", expected, "null % null");
        Validator.testExpression(elp, "a = null; a mod b", expected, "null mod null");
    }
}

