/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManagerFactory;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManagerFactory.Member;
import ee.jakarta.tck.persistence.core.entityManagerFactory.Member_;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Properties;

public class Client3
extends PMClientBase {
    Properties props = null;

    public static void main(String[] args) {
        Client3 theTests = new Client3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createMemberTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNamedQueryLockModeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        try {
            TypedQuery namedTypeQuery;
            Object result;
            LockModeType lmt;
            boolean ok1;
            Query namedQuery;
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.logTrace("Defining queries");
            Query query = this.getEntityManager().createQuery("select m from Member m where m.memberId=1");
            query.setLockMode(LockModeType.NONE);
            this.getEntityManagerFactory().addNamedQuery("query", query);
            CriteriaQuery cquery = cbuilder.createQuery(Member.class);
            Root member = cquery.from(Member.class);
            cquery.select((Selection)member);
            cquery.where((Expression)cbuilder.equal((Expression)member.get(Member_.memberId), (Object)1));
            TypedQuery typedQuery = this.getEntityManager().createQuery(cquery);
            typedQuery.setLockMode(LockModeType.NONE);
            this.getEntityManagerFactory().addNamedQuery("typed_query", (Query)typedQuery);
            try {
                this.getEntityTransaction().begin();
                this.logMsg("*********************************");
                this.logMsg("Testing query with different lock mode than the original");
                namedQuery = this.getEntityManager().createNamedQuery("query");
                ok1 = false;
                lmt = namedQuery.getLockMode();
                if (lmt != null) {
                    if (lmt.equals((Object)LockModeType.NONE)) {
                        this.logTrace("Received expected lock mode before change:" + lmt.name());
                        ok1 = true;
                    } else {
                        this.logErr("Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt.name());
                    }
                } else {
                    this.logErr("getLockModeType returned null");
                }
                namedQuery.setLockMode(LockModeType.PESSIMISTIC_READ);
                lmt = namedQuery.getLockMode();
                boolean ok2 = false;
                if (lmt.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    this.logTrace("Received LockModeType:" + lmt.name());
                    ok2 = true;
                } else if (lmt.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    this.logTrace("Received LockModeType:" + lmt + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                    ok2 = true;
                } else {
                    this.logErr("Expected lock mode after change:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lmt.name());
                }
                List lResult = namedQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    result = (Member)lResult.get(0);
                    if (((Member)result).getMemberId() == 1) {
                        this.logTrace("Received expected id:" + ((Member)result).getMemberId());
                        foundOne = true;
                    } else {
                        this.logErr("Expected id:1, actual:" + ((Member)result).getMemberId());
                    }
                } else {
                    this.logErr("Did not get correct number of results, expected:1, actual:" + lResult.size());
                    for (Member m : lResult) {
                        this.logErr("Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok1 && ok2) {
                    pass1 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                this.logMsg("*********************************");
                this.logMsg("Testing query verify original lock mode is active");
                namedQuery = this.getEntityManager().createNamedQuery("query");
                ok1 = false;
                lmt = namedQuery.getLockMode();
                if (lmt != null) {
                    if (lmt.equals((Object)LockModeType.NONE)) {
                        this.logTrace("Received expected lock mode before change:" + lmt.name());
                        ok1 = true;
                    } else {
                        this.logErr("Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt.name());
                    }
                } else {
                    this.logErr("getLockModeType returned null");
                }
                List lResult = namedQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    Member result2 = (Member)lResult.get(0);
                    if (result2.getMemberId() == 1) {
                        this.logTrace("Received expected id:" + result2.getMemberId());
                        foundOne = true;
                    } else {
                        this.logErr("Expected id:1, actual:" + result2.getMemberId());
                    }
                } else {
                    this.logErr("Did not get correct number of results, expected:1, actual:" + lResult.size());
                    for (Member m : lResult) {
                        this.logErr("Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok1) {
                    pass2 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                this.logMsg("*********************************");
                this.logMsg("Testing query definition can be replaced ");
                Query query2 = this.getEntityManager().createQuery("select m from Member m where m.memberId=2").setLockMode(LockModeType.PESSIMISTIC_READ);
                this.getEntityManagerFactory().addNamedQuery("query", query2);
                Query namedQuery2 = this.getEntityManager().createNamedQuery("query");
                boolean ok12 = false;
                LockModeType lmt2 = namedQuery2.getLockMode();
                if (lmt2 != null) {
                    if (lmt2.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                        this.logTrace("Received LockModeType:" + lmt2.name());
                        ok12 = true;
                    } else if (lmt2.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                        this.logTrace("Received LockModeType:" + lmt2 + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                        ok12 = true;
                    } else {
                        this.logErr("Expected lock mode after change:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lmt2.name());
                    }
                } else {
                    this.logErr("getLockModeType returned null");
                }
                List lResult = namedQuery2.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    result = (Member)lResult.get(0);
                    if (((Member)result).getMemberId() == 2) {
                        this.logTrace("Received expected id:" + ((Member)result).getMemberId());
                        foundOne = true;
                    } else {
                        this.logErr("Expected id:2, actual:" + ((Member)result).getMemberId());
                    }
                } else {
                    this.logErr("Did not get correct number of results, expected:2, actual:" + lResult.size());
                    for (Member m : lResult) {
                        this.logErr("Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok12) {
                    pass3 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                this.logMsg("*********************************");
                this.logMsg("Testing TypedQuery with lock mode different than the original");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Member.class);
                boolean ok13 = false;
                LockModeType lmt3 = namedTypeQuery.getLockMode();
                if (lmt3 != null) {
                    if (lmt3.equals((Object)LockModeType.NONE)) {
                        this.logTrace("Received expected lock mode before change:" + lmt3.name());
                        ok13 = true;
                    } else {
                        this.logErr("Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt3.name());
                    }
                } else {
                    this.logErr("getLockModeType returned null");
                }
                namedTypeQuery.setLockMode(LockModeType.PESSIMISTIC_READ);
                lmt3 = namedTypeQuery.getLockMode();
                boolean ok2 = false;
                if (lmt3.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    this.logTrace("Received expected lock mode after change:" + lmt3.name());
                    ok2 = true;
                } else if (lmt3.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    this.logTrace("Received LockModeType:" + lmt3 + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                    ok2 = true;
                } else {
                    this.logErr("Expected lock mode after change:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lmt3.name());
                }
                List lResult = namedTypeQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    result = (Member)lResult.get(0);
                    if (((Member)result).getMemberId() == 1) {
                        this.logTrace("Received expected id:" + ((Member)result).getMemberId());
                        foundOne = true;
                    } else {
                        this.logErr("Expected id:1, actual:" + ((Member)result).getMemberId());
                    }
                } else {
                    this.logErr("Did not get correct number of results, expected:1, actual:" + lResult.size());
                    for (Member m : lResult) {
                        this.logErr("Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok13 && ok2) {
                    pass4 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                this.logMsg("*********************************");
                this.logMsg("Testing TypedQuery verify original lock mode is active");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Member.class);
                boolean ok14 = false;
                LockModeType lmt4 = namedTypeQuery.getLockMode();
                if (lmt4 != null) {
                    if (lmt4.equals((Object)LockModeType.NONE)) {
                        this.logTrace("Received expected lock mode before change:" + lmt4.name());
                        ok14 = true;
                    } else {
                        this.logErr("Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt4.name());
                    }
                } else {
                    this.logErr("getLockModeType returned null");
                }
                List lResult = namedTypeQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    Member result3 = (Member)lResult.get(0);
                    if (result3.getMemberId() == 1) {
                        this.logTrace("Received expected id:" + result3.getMemberId());
                        foundOne = true;
                    } else {
                        this.logErr("Expected id:1, actual:" + result3.getMemberId());
                    }
                } else {
                    this.logErr("Did not get correct number of results, expected:1, actual:" + lResult.size());
                    for (Member m : lResult) {
                        this.logErr("Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok14) {
                    pass5 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("addNamedQueryLockModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMemberTestData() {
        try {
            this.getEntityTransaction().begin();
            Member[] members = new Member[]{new Member(1, "1"), new Member(2, "2"), new Member(3, "3"), new Member(4, "4"), new Member(5, "5")};
            for (Member m : members) {
                this.logTrace("Persisting member:" + m.toString());
                this.getEntityManager().persist((Object)m);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM MEMBER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

