/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.xa.ee.resXcomp3;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import com.sun.ts.tests.xa.ee.resXcomp3.Ejb2Test;
import jakarta.ejb.EJBException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;

public class Ejb1TestEJB {
    private Properties p = null;
    private Properties testProps = null;
    private Ejb2Test ref = null;
    private TSNamingContext context = null;
    private DataSource ds1;
    private DataSource ds4 = null;
    private String dbTable1 = null;
    private transient Connection con1 = null;
    private transient Connection con4 = null;
    private TSEISDataSource ds2;
    private TSEISDataSource ds3;
    private transient TSConnection con2 = null;
    private transient TSConnection con3 = null;
    private transient Statement stmt = null;

    public void initialize(Properties props) {
        this.testProps = props;
        String eMsg = "";
        try {
            TestUtil.init((Properties)props);
            this.context = new TSNamingContext();
            eMsg = "Exception doing a lookup for Ejb2Test ";
            this.ref = (Ejb2Test)this.context.lookup("java:comp/env/ejb/Ejb2Test", Ejb2Test.class);
            this.ref.initialize(props);
            TestUtil.logMsg((String)"Initialize logging data from server in Ejb1");
            eMsg = "Exception doing a initLogging for Ejb2Test ";
            this.ref.initLogging(this.p);
            eMsg = "Exception looking up JDBCwhitebox";
            this.ds1 = (DataSource)this.context.lookup("java:comp/env/eis/JDBCwhitebox-xa");
            eMsg = "Exception looking up EIS whitebox-xa";
            this.ds2 = (TSEISDataSource)this.context.lookup("java:comp/env/eis/whitebox-xa");
            eMsg = "Exception looking up EIS whitebox-notx";
            this.ds3 = (TSEISDataSource)this.context.lookup("java:comp/env/eis/whitebox-notx");
            eMsg = "Exception looking up EIS JDBCwhitebox-notx";
            this.ds4 = (DataSource)this.context.lookup("java:comp/env/eis/JDBCwhitebox-notx");
            TestUtil.logMsg((String)("JDBCwhitebox-xa ds1 : " + this.ds1));
            TestUtil.logMsg((String)("whitebox-xa ds2 : " + this.ds2));
            TestUtil.logMsg((String)("whitebox-notx ds3 : " + this.ds3));
            TestUtil.logMsg((String)("JDBCwhitebox-notx ds4 : " + this.ds4));
        }
        catch (Exception e) {
            TestUtil.logMsg((String)eMsg);
            TestUtil.logErr((String)"Ejb1: initialize failed", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void dbConnect(String tName) {
        TestUtil.logMsg((String)"dbConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.conTable1();
                TestUtil.logMsg((String)("Made the JDBC connection to " + this.dbTable1 + " DB"));
            } else {
                this.conTable2();
                TestUtil.logMsg((String)"Made the connection to EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception on JDBC connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void insertDup(String tName) {
        String eMsg = null;
        TestUtil.logTrace((String)"insertDup");
        try {
            if (tName.equals(this.dbTable1)) {
                TestUtil.logMsg((String)"Getting a connection con4");
                eMsg = "Exception doing a getConnection from ds4";
                this.con4 = this.ds4.getConnection();
                TestUtil.logTrace((String)("con4: " + this.con4.toString()));
                TestUtil.logMsg((String)("Insert row in " + this.dbTable1));
                String key = new String(this.testProps.getProperty("Xa_Tab1_insert_init"));
                this.stmt = this.con4.createStatement();
                this.stmt.executeUpdate(key);
                TestUtil.logTrace((String)("Inserted a row into the table using notx - key " + tName + key));
                TestUtil.logMsg((String)("nsertDup key in " + this.dbTable1));
            } else {
                TestUtil.logMsg((String)"Getting a connection con3");
                eMsg = "Exception doing a getConnection from ds3";
                this.con3 = this.ds3.getConnection();
                TestUtil.logTrace((String)("con3: " + this.con3.toString()));
                TestUtil.logMsg((String)"Insert row in EIS");
                eMsg = "Exception doing an insert in EIS con3 ds3";
                String key = new String(this.testProps.getProperty("TSEIS_insert_init"));
                this.con3.insert(key, key);
                TestUtil.logTrace((String)("Inserted a row in EIS using notx - key " + key));
                TestUtil.logMsg((String)"nsertDup key in EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logMsg(eMsg);
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"Captured Exception in insertDup");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                eMsg = "Exception in closing stmt";
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                eMsg = "Exception in closing con3";
                if (this.con3 != null) {
                    this.con3.close();
                    this.con3 = null;
                }
                eMsg = "Exception in closing con4";
                if (this.con4 != null) {
                    this.con4.close();
                    this.con4 = null;
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)eMsg);
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logMsg((String)"Captured Exception in insertDup");
                throw new EJBException(e.getMessage());
            }
        }
    }

    public void insert(String tName) {
        String key = null;
        TestUtil.logTrace((String)"insert");
        try {
            if (tName.equals(this.dbTable1)) {
                TestUtil.logMsg((String)("Insert row in " + this.dbTable1));
                key = new String(this.testProps.getProperty("Xa_Tab1_insert_init"));
                this.stmt = this.con1.createStatement();
                this.stmt.executeUpdate(key);
                TestUtil.logTrace((String)("Inserted a row into the table " + tName));
                TestUtil.logMsg((String)"Calling insert in Ejb2 ");
                this.ref.dbConnect(tName);
                this.ref.insert(tName);
                this.ref.dbUnConnect(tName);
            } else {
                TestUtil.logMsg((String)"Insert row in EIS");
                key = new String(this.testProps.getProperty("TSEIS_insert_init"));
                this.con2.insert(key, key);
                TestUtil.logTrace((String)"Inserted a row into the EIS ");
                TestUtil.logMsg((String)"Calling insert in Ejb2 ");
                this.ref.dbConnect("EIS");
                this.ref.insert("EIS");
                this.ref.dbUnConnect("EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception inserting a row into table " + tName + ";\n" + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception in insert@Ejb1 closing stmt" + e.getMessage()), (Throwable)e);
                throw new EJBException(e.getMessage());
            }
        }
    }

    public void destroyData(String tName) {
        String eMsg = null;
        String removeString = TestUtil.getProperty((String)"Xa_Tab1_Delete");
        TestUtil.logMsg((String)("destroyData : " + tName));
        try {
            if (tName.equals(this.dbTable1)) {
                eMsg = "Exception doing a getConnection from ds4";
                TestUtil.logMsg((String)"Getting a connection con4");
                this.con4 = this.ds4.getConnection();
                TestUtil.logTrace((String)("con4: " + this.con4.toString()));
                eMsg = "Exception doing a dropTable on con4";
                this.stmt = this.con4.createStatement();
                this.stmt.executeUpdate(removeString);
                TestUtil.logMsg((String)("Deleted all rows from table " + this.dbTable1));
            } else {
                eMsg = "Exception doing a getConnection from ds3";
                TestUtil.logMsg((String)"Getting a connection con3");
                this.con3 = this.ds3.getConnection();
                TestUtil.logTrace((String)("con3: " + this.con3.toString()));
                eMsg = "Exception doing a dropTable on con3";
                this.con3.dropTable();
                TestUtil.logMsg((String)"Deleted all rows from EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logMsg(eMsg);
            TestUtil.logErr((String)"Exception occured trying to drop table", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                eMsg = "Exception in closing stmt";
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                eMsg = "Exception in closing con3";
                if (this.con3 != null) {
                    this.con3.close();
                    this.con3 = null;
                }
                eMsg = "Exception in closing con4";
                if (this.con4 != null) {
                    this.con4.close();
                    this.con4 = null;
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)eMsg);
                TestUtil.logErr((String)"Exception occured trying to drop table", (Throwable)e);
                throw new EJBException(e.getMessage());
            }
        }
    }

    public void dbUnConnect(String tName) {
        TestUtil.logMsg((String)"dbUnConnect");
        Vector queryResults = new Vector();
        try {
            if (tName.equals(this.dbTable1)) {
                this.con1.close();
                this.con1 = null;
                TestUtil.logMsg((String)("Closed " + this.dbTable1 + " connection"));
            } else {
                this.con2.close();
                this.con2 = null;
                TestUtil.logMsg((String)"Closed EIS connection");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to close the DB connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging Ejb1");
        this.testProps = p;
        try {
            TestUtil.init((Properties)p);
            this.dbTable1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"Xa_Tab1_Delete"));
            TestUtil.logMsg((String)(this.dbTable1 + " Ejb1 initLogging OK!"));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Inside Ejb1 initLogging" + e.getMessage());
        }
    }

    public boolean verifyData(String operation, String tName, int[] expResults) {
        boolean status = false;
        int linenum = 0;
        Statement queryStatement = null;
        ResultSet theResults = null;
        Vector queryResults = new Vector();
        try {
            if (operation.equals("commit")) {
                TestUtil.logMsg((String)("Expected number of rows is: " + expResults.length));
                if (tName.equals(this.dbTable1)) {
                    String query = this.testProps.getProperty("Xa_Tab1_query");
                    TestUtil.logMsg((String)("query is " + query));
                    queryStatement = this.con1.prepareStatement(query);
                    theResults = queryStatement.executeQuery();
                    ResultSetMetaData rsmeta = theResults.getMetaData();
                    int numColumns = rsmeta.getColumnCount();
                    TestUtil.logTrace((String)("Number of columns from rsmeta " + numColumns));
                    while (theResults.next()) {
                        TestUtil.logMsg((String)("Line No: " + ++linenum + " results: " + theResults.getInt(1) + " expResults: " + expResults[linenum - 1]));
                        if (theResults.getInt(1) == expResults[linenum - 1]) {
                            status = true;
                            TestUtil.logMsg((String)("verifyData OK, Status is : " + status));
                            continue;
                        }
                        status = false;
                        TestUtil.logMsg((String)("verifyData ERROR, Status is : " + status));
                        break;
                    }
                    if (expResults.length != linenum) {
                        TestUtil.logTrace((String)"Error - expected row count does not match table in verifyData!!");
                        status = false;
                    }
                } else {
                    int i;
                    TestUtil.logMsg((String)"Getting a connection con3");
                    this.con3 = this.ds3.getConnection();
                    TestUtil.logMsg((String)("con3: " + this.con3.toString()));
                    queryResults = this.con3.readData();
                    for (i = 0; i < expResults.length; ++i) {
                        TestUtil.logMsg((String)("Expected results: " + expResults.length));
                        if (!queryResults.contains(new Integer(expResults[i]).toString())) {
                            status = false;
                            TestUtil.logMsg((String)("VerifyData Error, Status is : " + status));
                            break;
                        }
                        status = true;
                        TestUtil.logMsg((String)("VerifyData OK, Status is : " + status));
                    }
                    for (i = 0; i < queryResults.size(); ++i) {
                        TestUtil.logMsg((String)("Query Results contains : " + queryResults.elementAt(i)));
                    }
                }
            } else if (tName.equals(this.dbTable1)) {
                String query = this.testProps.getProperty("Xa_Tab1_query");
                TestUtil.logMsg((String)("query is " + query));
                queryStatement = this.con1.prepareStatement(query);
                theResults = queryStatement.executeQuery();
                TestUtil.logTrace((String)("status is " + status));
                status = !theResults.next();
                TestUtil.logMsg((String)("Resultset has no data? " + status));
            } else {
                int i;
                TestUtil.logMsg((String)"Getting a connection con3");
                this.con3 = this.ds3.getConnection();
                TestUtil.logMsg((String)("con3: " + this.con3.toString()));
                queryResults = this.con3.readData();
                for (i = 0; i < expResults.length; ++i) {
                    TestUtil.logMsg((String)("Not Expected results: " + expResults[i]));
                    if (queryResults.contains(new Integer(expResults[i]).toString())) {
                        status = false;
                        TestUtil.logMsg((String)("VerifyData Error, Status is : " + status));
                        break;
                    }
                    status = true;
                    TestUtil.logMsg((String)("VerifyData OK, Status is : " + status));
                }
                for (i = 0; i < queryResults.size(); ++i) {
                    TestUtil.logMsg((String)("Query REsults contains : " + queryResults.elementAt(i)));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)"Error verifyData database inserts Ejb1 ");
            TestUtil.printStackTrace((Throwable)e);
            status = false;
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (theResults != null) {
                    theResults.close();
                }
                if (queryStatement != null) {
                    queryStatement.close();
                }
                if (this.con3 != null) {
                    this.con3.close();
                    this.con3 = null;
                }
            }
            catch (Exception exception) {}
        }
        TestUtil.logMsg((String)("Verify Data Status is : " + status));
        return status;
    }

    public void throwEJBException() throws EJBException {
        TestUtil.logTrace((String)"throwEJBException");
        throw new EJBException("EJBException from Ejb1TestEJB");
    }

    private void conTable1() {
        TestUtil.logTrace((String)"conTable1");
        try {
            this.con1 = this.ds1.getConnection();
            TestUtil.logTrace((String)("con1: " + this.con1.toString()));
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException connecting to " + this.dbTable1 + " DB"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Exception connecting to " + this.dbTable1 + " DB con1 "), (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void conTable2() {
        TestUtil.logTrace((String)"conTable2");
        try {
            this.con2 = this.ds2.getConnection();
            TestUtil.logTrace((String)("con2: " + this.con2.toString()));
        }
        catch (Exception ee) {
            TestUtil.logErr((String)"Exception connecting to EIS con2 ", (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }
}

