/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt7;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient7
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt7";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private DataSource ds1 = null;
    private csSchema csSch = null;
    private rsSchema rsSch = null;
    private JDBCTestMsg msg = null;
    private String drManager = null;
    private Properties sqlp = null;
    private CallableStatement cstmt = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private Properties props = null;

    public static void main(String[] args) {
        callStmtClient7 theTests = new callStmtClient7();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
                this.stmt = this.conn.createStatement();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFloat01() throws Exception {
        String minStringVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_In_Max(?)}");
            this.msg.setMsg("to extract the Minimum Value of float to be Updated");
            sminStringVal = this.rsSch.extractVal("Float_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            float minFloatVal = Float.parseFloat(sminStringVal);
            this.msg.setMsg("Minimum flaot Value to be updated :" + minFloatVal);
            this.cstmt.setFloat(1, minFloatVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Float_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            float rFloatVal = this.rs.getFloat(1);
            this.msg.addOutputMsg("" + minFloatVal, "" + rFloatVal);
            if (rFloatVal == minFloatVal) {
                this.msg.setMsg("setFloat Method sets the designated parameter to a float value ");
            } else {
                this.msg.printTestError("setFloat Method does not set the designated parameter to a float value ", "test setFloat failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFloat is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setFloat is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFloat02() throws Exception {
        String maxStringVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_In_Null(?)}");
            this.msg.setMsg("to extract the Minimum Value of float to be Updated");
            smaxStringVal = this.rsSch.extractVal("Float_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            float maxFloatVal = Float.parseFloat(smaxStringVal);
            this.msg.setMsg("Maximum float Value to be updated :" + maxFloatVal);
            this.cstmt.setFloat(1, maxFloatVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Float_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            float rFloatVal = this.rs.getFloat(1);
            this.msg.addOutputMsg("" + maxFloatVal, "" + rFloatVal);
            if (rFloatVal == maxFloatVal) {
                this.msg.setMsg("setFloat Method sets the designated parameter to a float value ");
            } else {
                this.msg.printTestError("setFloat Method does not set the designated parameter to a float value ", "test setFloat failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFloat is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setFloat is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetDouble01() throws Exception {
        String minStringVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_In_Max(?)}");
            this.msg.setMsg("to extract the Minimum Value of double to be Updated");
            sminStringVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            double minDoubleVal = Double.parseDouble(sminStringVal);
            this.msg.setMsg("Minimum double Value to be updated :" + minDoubleVal);
            this.cstmt.setDouble(1, minDoubleVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Double_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            double rDoubleVal = this.rs.getDouble(1);
            this.msg.addOutputMsg("" + minDoubleVal, "" + rDoubleVal);
            if (rDoubleVal == minDoubleVal) {
                this.msg.setMsg("setDouble Method sets the designated parameter to a double value ");
            } else {
                this.msg.printTestError("setDouble Method does not set the designated parameter to a double value ", "test setDouble failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setDouble is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setDouble is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetDouble02() throws Exception {
        String maxStringVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_In_Null(?)}");
            this.msg.setMsg("to extract the Maximum Value of double to be Updated");
            smaxStringVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            double maxDoubleVal = Double.parseDouble(smaxStringVal);
            this.msg.setMsg("Maximum double Value to be updated :" + maxDoubleVal);
            this.cstmt.setDouble(1, maxDoubleVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Double_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            double rDoubleVal = this.rs.getDouble(1);
            this.msg.addOutputMsg("" + maxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal == maxDoubleVal) {
                this.msg.setMsg("setDouble Method sets the designated parameter to a double value ");
            } else {
                this.msg.printTestError("setDouble Method does not set the designated parameter to a double value ", "test setDouble failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setDouble is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setDouble is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBytes01() throws Exception {
        String binarySize = null;
        try {
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            binarySize = this.props.getProperty("binarySize");
            int bytearrsize = Integer.parseInt(binarySize);
            this.msg.setMsg("Binary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            this.msg.setMsg(" get the bytearray value");
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Binary_Proc_In(?)}");
            this.cstmt.setBytes(1, bytearr);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Binary_Val_Query = this.sqlp.getProperty("Binary_Query_Val", "");
            this.msg.setMsg("Query String :" + Binary_Val_Query);
            this.rs = this.stmt.executeQuery(Binary_Val_Query);
            this.rs.next();
            byte[] oRetVal = this.rs.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("setBytes did not set the proper byte array values", "test setBytes failed");
            }
            this.msg.setMsg("setBytes sets the proper byte array values");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBytes is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBytes02() throws Exception {
        String varbinarySize = null;
        try {
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            varbinarySize = this.props.getProperty("varbinarySize");
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("Varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            this.msg.setMsg(" get the bytearray value");
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varbinary_Proc_In(?)}");
            this.cstmt.setBytes(1, bytearr);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Varbinary_Val_Query = this.sqlp.getProperty("Varbinary_Query_Val", "");
            this.msg.setMsg("Query String :" + Varbinary_Val_Query);
            this.rs = this.stmt.executeQuery(Varbinary_Val_Query);
            this.rs.next();
            byte[] oRetVal = this.rs.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("setBytes did not set the proper byte array values", "test setBytes failed");
            }
            this.msg.setMsg("setBytes sets the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBytes is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    public void testSetDate01() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_In_Mfg(?)}");
            this.cstmt.setNull(1, 91);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Date_Mfg_Query = this.sqlp.getProperty("Date_Query_Mfg", "");
            this.msg.setMsg("Query String :" + Date_Mfg_Query);
            this.rs = this.stmt.executeQuery(Date_Mfg_Query);
            this.rs.next();
            Date oRetVal = this.rs.getDate(1);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("setDate sets the Null value " + oRetVal);
            } else {
                this.msg.printTestError("setDate did not set the Null value", "test setDate failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFloat is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setFloat is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetDate02() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_In_Null(?)}");
            this.msg.setMsg("CallableStatement created");
            this.msg.setMsg("extract the Date Value to be Updated");
            String sRetStr = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            sRetStr = sRetStr.trim();
            Date oExtVal = Date.valueOf(sRetStr);
            this.msg.setMsg("Date : " + sRetStr);
            this.cstmt.setDate(1, oExtVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Date_Null_Query = this.sqlp.getProperty("Date_Query_Null", "");
            this.msg.setMsg("Query String :" + Date_Null_Query);
            this.rs = this.stmt.executeQuery(Date_Null_Query);
            this.rs.next();
            Date oRetVal = this.rs.getDate(1);
            this.msg.addOutputMsg(oExtVal.toString(), oRetVal.toString());
            if (oRetVal.toString().equals(oExtVal.toString())) {
                this.msg.setMsg("setDate sets the non null Date value " + oRetVal);
            } else {
                this.msg.printTestError("setDate did not set the non null Date value", "test setDate Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setDate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setDate is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetDate03() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_In_Mfg(?)}");
            this.cstmt.setNull(1, 91);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            Calendar oCalDefault = Calendar.getInstance();
            String Date_Mfg_Query = this.sqlp.getProperty("Date_Query_Mfg", "");
            this.msg.setMsg("Query String :" + Date_Mfg_Query);
            this.rs = this.stmt.executeQuery(Date_Mfg_Query);
            this.rs.next();
            Date oRetVal = this.rs.getDate(1, oCalDefault);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("setDate sets the Null value ");
            } else {
                this.msg.printTestError("setDate did not set the Null value", "test setDate Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setDate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setDate is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetDate04() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_In_Null(?)}");
            this.msg.setMsg("extract the Date Value to be Updated");
            String sRetStr = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            sRetStr = sRetStr.trim();
            Date oExtVal = Date.valueOf(sRetStr);
            Calendar oCalDefault = Calendar.getInstance();
            this.cstmt.setDate(1, oExtVal, oCalDefault);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("query from the database to check the call of cstmt.executeUpdate");
            String Date_Null_Query = this.sqlp.getProperty("Date_Query_Null", "");
            this.msg.setMsg("Query String :" + Date_Null_Query);
            this.rs = this.stmt.executeQuery(Date_Null_Query);
            this.rs.next();
            Date oRetVal = this.rs.getDate(1, oCalDefault);
            this.msg.addOutputMsg(oExtVal.toString(), oRetVal.toString());
            if (oRetVal.toString().equals(oExtVal.toString())) {
                this.msg.setMsg("setDate sets the non null Date value ");
            } else {
                this.msg.printTestError("setDate did not set the non null Date value", "test setDate Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setDate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setDate is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetTime01() throws Exception {
        Time brkTimeVal = null;
        Time rTimeVal = null;
        String sbrkTimeVal = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_In_Null(?)}");
            this.msg.setMsg("extract the Value of Break_Time to be Updated");
            sbrkTimeVal = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            sbrkTimeVal = sbrkTimeVal.substring(sbrkTimeVal.indexOf(39) + 1, sbrkTimeVal.lastIndexOf(39));
            sbrkTimeVal = new String(sbrkTimeVal);
            sbrkTimeVal = sbrkTimeVal.trim();
            brkTimeVal = Time.valueOf(sbrkTimeVal);
            this.msg.setMsg("Time Value :" + brkTimeVal);
            this.cstmt.setTime(1, brkTimeVal);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Time_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimeVal = this.rs.getTime(1);
            this.msg.addOutputMsg(sbrkTimeVal, rTimeVal.toString());
            if (rTimeVal.toString().trim().equals(sbrkTimeVal)) {
                this.msg.setMsg("setTime Method sets the designated parameter to a Time value ");
            } else {
                this.msg.printTestError("setTime Method does not set the designated parameter to a Time value ", "test setTime Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setTime is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setTime is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetTime02() throws Exception {
        Time inTimeVal = null;
        Time rTimeVal = null;
        String sinTimeVal = null;
        Calendar cal = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_In_Null(?)}");
            sinTimeVal = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            sinTimeVal = sinTimeVal.substring(sinTimeVal.indexOf(39) + 1, sinTimeVal.lastIndexOf(39));
            sinTimeVal = new String(sinTimeVal);
            sinTimeVal = sinTimeVal.trim();
            inTimeVal = Time.valueOf(sinTimeVal);
            this.msg.setMsg("Time Value :" + inTimeVal);
            cal = Calendar.getInstance();
            this.cstmt.setTime(1, inTimeVal, cal);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            this.msg.setMsg("get the query string");
            String Null_Val_Query = this.sqlp.getProperty("Time_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimeVal = this.rs.getTime(1, cal);
            this.msg.addOutputMsg(sinTimeVal, rTimeVal.toString());
            if (rTimeVal.toString().trim().equals(sinTimeVal)) {
                this.msg.setMsg("setTime Method sets the designated parameter to a Time value ");
            } else {
                this.msg.printTestError("setTime Method does not set the designated parameter to a Time value ", "test setTime Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setTime is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setTime is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetTimestamp01() throws Exception {
        Timestamp brkTimeVal = null;
        Timestamp rTimeVal = null;
        String sbrkTimeVal = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_In_Null(?)}");
            this.msg.setMsg("extract the Value of Break_Timestamp to be Updated");
            sbrkTimeVal = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            sbrkTimeVal = sbrkTimeVal.substring(sbrkTimeVal.indexOf(39) + 1, sbrkTimeVal.lastIndexOf(39));
            sbrkTimeVal = new String(sbrkTimeVal);
            sbrkTimeVal = sbrkTimeVal.trim();
            brkTimeVal = Timestamp.valueOf(sbrkTimeVal);
            this.msg.setMsg("Timestamp Value :" + brkTimeVal);
            this.cstmt.setTimestamp(1, brkTimeVal);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Timestamp_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimeVal = this.rs.getTimestamp(1);
            this.msg.addOutputMsg(brkTimeVal.toString(), rTimeVal.toString());
            if (rTimeVal.compareTo(brkTimeVal) == 0) {
                this.msg.setMsg("setTimestamp Method sets the designated parameter to a Timestamp value ");
            } else {
                this.msg.printTestError("setTimestamp Method does not set the designated parameter to a Timestamp value ", "test setTimestamp Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setTimestamp is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setTimestamp is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetTimestamp02() throws Exception {
        Timestamp inTimeVal = null;
        Timestamp rTimeVal = null;
        String sinTimeVal = null;
        Calendar cal = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_In_Null(?)}");
            sinTimeVal = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            sinTimeVal = sinTimeVal.substring(sinTimeVal.indexOf(39) + 1, sinTimeVal.lastIndexOf(39));
            sinTimeVal = new String(sinTimeVal);
            sinTimeVal = sinTimeVal.trim();
            inTimeVal = Timestamp.valueOf(sinTimeVal);
            this.msg.setMsg("get the Calendar Instance");
            cal = Calendar.getInstance();
            this.cstmt.setTimestamp(1, inTimeVal, cal);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Timestamp_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimeVal = this.rs.getTimestamp(1, cal);
            this.msg.addOutputMsg(inTimeVal.toString(), rTimeVal.toString());
            if (rTimeVal.compareTo(inTimeVal) == 0) {
                this.msg.setMsg("setTimestamp Method sets the designated parameter to a Timestamp value ");
            } else {
                this.msg.printTestError("setTimestamp Method does not set the designated parameter to a Timestamp value ", "test setTimestamp Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setTimestamp is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setTimestamp is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

