/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.invalidDest;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InvalidDestTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.invalidDest.InvalidDestTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final System.Logger logger = System.getLogger(InvalidDestTestsIT.class.getName());
    private static JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    public void invalidDestinationTests() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            boolean pass = true;
            Topic dummyT = null;
            JmsTool tool = new JmsTool(14, this.user, this.password, lookup, this.mode);
            tool.getDefaultConnection().close();
            Connection newConn = tool.getNewConnection(14, this.user, this.password, lookup);
            if (newConn.getClientID() == null) {
                newConn.setClientID("cts");
            }
            Session newSession = newConn.createSession(false, 1);
            try {
                newSession.unsubscribe("foo");
                logger.log(System.Logger.Level.ERROR, "Error: unsubscribe(foo) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from unsubscribe(foo)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unsubscribe(foo) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                newSession.createDurableSubscriber(dummyT, "cts");
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createDurableSubscriber(null, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(null, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                newSession.createDurableSubscriber(dummyT, "cts", "TEST = 'test'", true);
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(null, String, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createDurableSubscriber(null, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(null, String, String, boolean) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                newConn.close();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing new Connection", (Throwable)ex);
            }
            if (!pass) {
                throw new Exception("invalidDestinationTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("invalidDestinationTests");
        }
    }
}

