/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.topicMsgHeaders;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TopicHeaderTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.topicMsgHeaders.TopicHeaderTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(TopicHeaderTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        logger.log(System.Logger.Level.TRACE, "Results: " + status[index]);
        return retcode;
    }

    @Test
    public void msgHdrIDTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String id = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrIDTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDToopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceivedObjectMsg.getJMSMessageID());
            id = messageReceivedObjectMsg.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "ObjectMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceivedMapMessage.getJMSMessageID());
            id = messageReceivedMapMessage.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "MapMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceivedBytesMessage.getJMSMessageID());
            id = messageReceivedBytesMessage.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "BytesMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceivedStreamMessage.getJMSMessageID());
            id = messageReceivedStreamMessage.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "StreamMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDTopicTest");
            logger.log(System.Logger.Level.TRACE, "sending a Text message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceived.getJMSMessageID());
            id = messageReceived.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "TextMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSMessageID returned from JMSMessageID");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrIDTopicTest");
        }
    }

    @Test
    public void msgHdrTimeStampTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        Object id = null;
        try {
            TextMessage messageSent = null;
            StreamMessage messageSentStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to TOPIC.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrTimeStampTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            long timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            long timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSentObjectMsg.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentObjectMsg.getJMSTimestamp() && timeAfterSend >= messageSentObjectMsg.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "Object Message TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from ObjectMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            messageSentMapMessage.setString("aString", "value");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSentMapMessage.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentMapMessage.getJMSTimestamp() && timeAfterSend >= messageSentMapMessage.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "MapMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from MapMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSentBytesMessage.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentBytesMessage.getJMSTimestamp() && timeAfterSend >= messageSentBytesMessage.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "BytesMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from BytesMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSentStreamMessage.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentStreamMessage.getJMSTimestamp() && timeAfterSend >= messageSentStreamMessage.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "StreamMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from StreamMessage");
                pass = false;
            }
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            logger.log(System.Logger.Level.TRACE, "sending a Text message");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSent.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSent.getJMSTimestamp() && timeAfterSend >= messageSent.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "TextMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from TextMessage");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid TimeStamp returned from JMSTimeStamp");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrTimeStampTopicTest");
        }
    }

    @Test
    public void msgHdrCorlIdTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String jmsCorrelationID = "test Correlation id";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            logger.log(System.Logger.Level.TRACE, "Sending Text message to Topic ");
            messageSent.setJMSCorrelationID(jmsCorrelationID);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "jmsCorrelationID:  " + messageReceived.getJMSCorrelationID());
            if (messageReceived.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Text Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceived.getJMSCorrelationID().equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.TRACE, "pass");
            } else {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Text Message Error: JMSCorrelationID is incorrect");
            }
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrCorlIdTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            messageSentObjectMsg.setJMSCorrelationID(jmsCorrelationID);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "jmsCorrelationID:  " + messageReceivedObjectMsg.getJMSCorrelationID());
            if (messageReceivedObjectMsg.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Object Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceivedObjectMsg.getJMSCorrelationID().equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.TRACE, "pass");
            } else {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Object Message Error: JMSCorrelationID is incorrect");
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            messageSentMapMessage.setJMSCorrelationID(jmsCorrelationID);
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "jmsCorrelationID:  " + messageReceivedMapMessage.getJMSCorrelationID());
            if (messageReceivedMapMessage.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Map Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceivedMapMessage.getJMSCorrelationID().equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.TRACE, "pass");
            } else {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Map Message Error: JMSCorrelationID is incorrect");
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            messageSentBytesMessage.setJMSCorrelationID(jmsCorrelationID);
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "jmsCorrelationID:  " + messageReceivedBytesMessage.getJMSCorrelationID());
            if (messageReceivedBytesMessage.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Bytes Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceivedBytesMessage.getJMSCorrelationID().equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.TRACE, "pass");
            } else {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Byte Message Error: JMSCorrelationID is incorrect");
            }
            logger.log(System.Logger.Level.TRACE, "sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            messageSentStreamMessage.setJMSCorrelationID(jmsCorrelationID);
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "jmsCorrelationID:  " + messageReceivedStreamMessage.getJMSCorrelationID());
            if (messageReceivedStreamMessage.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Stream Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceivedStreamMessage.getJMSCorrelationID().equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.TRACE, "pass");
            } else {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Stream Message Error: JMSCorrelationID is incorrect");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSCorrelationID returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrCorlIdTopicTest");
        }
    }

    @Test
    public void msgHdrReplyToTopicTest() throws Exception {
        boolean pass = true;
        Topic replyTopic = null;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            logger.log(System.Logger.Level.TRACE, "Send Text message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field should have been null for this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSent.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            replyTopic = (Topic)messageReceived.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Text Message Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrReplyToTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedObjectMsg.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSentObjectMsg.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            replyTopic = (Topic)messageReceivedObjectMsg.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Object Message ReplyTo Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedMapMessage.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSentMapMessage.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received Map message ");
            replyTopic = (Topic)messageReceivedMapMessage.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Map Message ReplyTo Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedBytesMessage.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSentBytesMessage.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received Bytes message ");
            replyTopic = (Topic)messageReceivedBytesMessage.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Bytes Message ReplyTo Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedStreamMessage.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSentStreamMessage.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received Stream message ");
            replyTopic = (Topic)messageReceivedStreamMessage.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Stream Message ReplyTo Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid Replyto returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrReplyToTopicTest");
        }
    }

    @Test
    public void msgHdrJMSTypeTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String type = "TESTMSG";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            logger.log(System.Logger.Level.TRACE, "JMSType test - Send a Text message");
            messageSent.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceived.getJMSType());
            if (messageReceived.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Text Message Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSType test - Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrJMSTypeTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            messageSentObjectMsg.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceivedObjectMsg.getJMSType());
            if (messageReceivedObjectMsg.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Object Message JMSType Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSType test - Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            messageSentMapMessage.setString("aString", "value");
            messageSentMapMessage.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceivedMapMessage.getJMSType());
            if (messageReceivedMapMessage.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Map Message JMSType Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSType test - Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            messageSentBytesMessage.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceivedBytesMessage.getJMSType());
            if (messageReceivedBytesMessage.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Bytes Message JMSType Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSType test - sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            messageSentStreamMessage.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceivedStreamMessage.getJMSType());
            if (messageReceivedStreamMessage.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Stream Message JMSType Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSType returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSTypeTopicTest");
        }
    }

    @Test
    public void msgHdrJMSPriorityTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        int priority = 2;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - Send a Text message");
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceived.getJMSPriority());
            if (messageReceived.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Text Message Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrJMSPriorityTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceivedObjectMsg.getJMSPriority());
            if (messageReceivedObjectMsg.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Object Message JMSPriority Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceivedMapMessage.getJMSPriority());
            if (messageReceivedMapMessage.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Map Message JMSPriority Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceivedBytesMessage.getJMSPriority());
            if (messageReceivedBytesMessage.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Bytes Message JMSPriority Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceivedStreamMessage.getJMSPriority());
            if (messageReceivedStreamMessage.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Stream Message JMSPriority Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSPriority returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSPriorityTopicTest");
        }
    }

    @Test
    public void msgHdrJMSExpirationTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        long forever = 0L;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timetoLive=0) - Send TextMessage to Topic");
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceived.getJMSExpiration());
            if (messageReceived.getJMSExpiration() == forever) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "TextMessage.getJMSExpiration() returned  " + messageReceived.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timetoLive=60000) - Send TextMessage to Topic");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            long currentTime = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceived.getJMSExpiration());
            long timeLeftToExpiration = messageReceived.getJMSExpiration() - currentTime;
            logger.log(System.Logger.Level.INFO, "TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "TextMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timeToLive=0) - Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrJMSExpirationTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceivedObjectMsg.getJMSExpiration());
            if (messageReceivedObjectMsg.getJMSExpiration() == forever) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "ObjectMessage.getJMSExpiration() returned  " + messageReceivedObjectMsg.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timetoLive=60000) - Send ObjectMessage to Topic.");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            currentTime = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceivedObjectMsg.getJMSExpiration());
            timeLeftToExpiration = messageReceivedObjectMsg.getJMSExpiration() - currentTime;
            logger.log(System.Logger.Level.INFO, "TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timeToLive=0) - Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceivedMapMessage.getJMSExpiration());
            if (messageReceivedMapMessage.getJMSExpiration() == forever) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "MapMessage.getJMSExpiration() returned  " + messageReceivedMapMessage.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timetoLive=60000) - Send MapMessage to Topic.");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            currentTime = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceivedMapMessage.getJMSExpiration());
            timeLeftToExpiration = messageReceivedMapMessage.getJMSExpiration() - currentTime;
            logger.log(System.Logger.Level.INFO, "TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "MapMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timeToLive=0) - Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceivedBytesMessage.getJMSExpiration());
            if (messageReceivedBytesMessage.getJMSExpiration() == forever) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "BytesMessage.getJMSExpiration() returned  " + messageReceivedBytesMessage.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timetoLive=60000) - Send BytesMessage to Topic.");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            currentTime = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceivedBytesMessage.getJMSExpiration());
            timeLeftToExpiration = messageReceivedBytesMessage.getJMSExpiration() - currentTime;
            logger.log(System.Logger.Level.INFO, "TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timeToLive=0) - sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceivedStreamMessage.getJMSExpiration());
            if (messageReceivedStreamMessage.getJMSExpiration() == forever) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "StreamMessage.getJMSExpiration() returned  " + messageReceivedStreamMessage.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test (set timetoLive=60000) - Send StreamMessage to Topic.");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            currentTime = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is " + messageReceivedStreamMessage.getJMSExpiration());
            timeLeftToExpiration = messageReceivedStreamMessage.getJMSExpiration() - currentTime;
            logger.log(System.Logger.Level.INFO, "TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                logger.log(System.Logger.Level.INFO, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSExpiration Failed");
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSExpiration returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSExpirationTopicTest");
        }
    }

    @Test
    public void msgHdrJMSDestinationTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        Topic replyDestination = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("publishing a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            logger.log(System.Logger.Level.TRACE, "publish Text Message to Topic.");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceived.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                logger.log(System.Logger.Level.TRACE, "Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Text Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Text Message Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "publish ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrIDQTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceivedObjectMsg.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                logger.log(System.Logger.Level.TRACE, "Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Object Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Object Message Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "publish MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceivedMapMessage.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                logger.log(System.Logger.Level.TRACE, "Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Map Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Map Message Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "publish BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceivedBytesMessage.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                logger.log(System.Logger.Level.TRACE, "Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Bytes Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Bytes Message Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "publishing a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "publishing Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceivedStreamMessage.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                logger.log(System.Logger.Level.TRACE, "Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Stream Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Stream Message Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSDestination returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSDestinationTopicTest");
        }
    }

    @Test
    public void msgHdrJMSDeliveryModeTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "default delivery mode is 2");
            logger.log(System.Logger.Level.INFO, "persistent is: 2");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("publishing a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            logger.log(System.Logger.Level.TRACE, "publish Text Message to Topic.");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Text Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                logger.log(System.Logger.Level.TRACE, "Text Message Pass ");
            }
            logger.log(System.Logger.Level.TRACE, "publish ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"Test for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Object Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                logger.log(System.Logger.Level.TRACE, "Object Message Pass ");
            }
            logger.log(System.Logger.Level.TRACE, "publish MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Map Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                logger.log(System.Logger.Level.TRACE, "Map Message Pass ");
            }
            logger.log(System.Logger.Level.TRACE, "publish BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Bytes Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                logger.log(System.Logger.Level.TRACE, "Bytes Message Pass ");
            }
            logger.log(System.Logger.Level.TRACE, "publishing a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "publishing Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Stream Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                logger.log(System.Logger.Level.TRACE, "Stream Message Pass ");
            }
            this.tool.getDefaultTopicPublisher().setDeliveryMode(1);
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("publishing a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            logger.log(System.Logger.Level.TRACE, "publish Text Message to Topic.");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Text Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                logger.log(System.Logger.Level.TRACE, "Text Message Pass ");
            }
            logger.log(System.Logger.Level.TRACE, "publish ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrJMSDeliveryModeTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedObjectMsg != null) {
                logger.log(System.Logger.Level.TRACE, "messageReceivedObjectMsg=" + messageReceivedObjectMsg);
            }
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Object Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                logger.log(System.Logger.Level.TRACE, "Object Message Pass ");
            }
            logger.log(System.Logger.Level.TRACE, "publish MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedMapMessage != null) {
                logger.log(System.Logger.Level.TRACE, "messageReceivedMapMessage=" + messageReceivedMapMessage);
            }
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Map Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                logger.log(System.Logger.Level.TRACE, "Map Message Pass ");
            }
            logger.log(System.Logger.Level.TRACE, "publish BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedBytesMessage != null) {
                logger.log(System.Logger.Level.TRACE, "messageReceivedBytesMessage=" + messageReceivedBytesMessage);
            }
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Bytes Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                logger.log(System.Logger.Level.TRACE, "Bytes Message Pass ");
            }
            logger.log(System.Logger.Level.TRACE, "publishing a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "publishing Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedStreamMessage != null) {
                logger.log(System.Logger.Level.TRACE, "messageReceivedStreamMessage=" + messageReceivedStreamMessage);
            }
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Stream Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                logger.log(System.Logger.Level.TRACE, "Stream Message Pass ");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSDeliveryMode returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSDeliveryModeTopicTest");
        }
    }
}

