/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.messageproducertests;

import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.CompletionListener;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.messageproducertests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    transient MessageProducer producer = null;
    transient MessageConsumer consumer = null;
    transient Connection connection = null;
    transient Session session = null;
    transient Destination destination = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    boolean queueTest = false;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Closing default Connection");
            this.tool.getDefaultConnection().close();
            if (this.queueTest) {
                logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            this.tool.closeAllResources();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("cleanup failed!", e);
        }
    }

    @Test
    public void queueSendAndRecvTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendAndRecvTest1");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("queueSendAndRecvTest1", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueSendAndRecvTest1 failed");
        }
    }

    @Test
    public void queueSendAndRecvTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendAndRecvTest2");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, int, int, long)");
            this.producer.send(this.destination, (Message)expTextMessage, 1, 3, 0L);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 3 || actTextMessage.getJMSExpiration() != 0L) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority());
                logger.log(System.Logger.Level.ERROR, "TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("queueSendAndRecvTest2", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueSendAndRecvTest2 failed");
        }
    }

    @Test
    public void queueSendAndRecvTest3() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendAndRecvTest3");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message)");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("queueSendAndRecvTest3", e);
        }
        if (!pass) {
            throw new Exception("queueSendAndRecvTest3 failed");
        }
    }

    @Test
    public void queueSendAndRecvTest4() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendAndRecvTest4");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, int, int, long)");
            this.producer.send((Message)expTextMessage, 1, 3, 0L);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 3 || actTextMessage.getJMSExpiration() != 0L) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority());
                logger.log(System.Logger.Level.ERROR, "TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("queueSendAndRecvTest4", e);
        }
        if (!pass) {
            throw new Exception("queueSendAndRecvTest4 failed");
        }
    }

    @Test
    public void queueSetGetDeliveryModeTest() throws Exception {
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            long expDeliveryMode = 2L;
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned");
            long actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetDeliveryModeTest");
        }
        try {
            int expDeliveryMode = 1;
            logger.log(System.Logger.Level.INFO, "Calling setDeliveryMode(" + expDeliveryMode + ")");
            this.producer.setDeliveryMode(expDeliveryMode);
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned");
            int actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetDeliveryModeTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetDeliveryModeTest failed");
        }
    }

    @Test
    public void queueSetGetDeliveryDelayTest() throws Exception {
        long actDeliveryDelay;
        long expDeliveryDelay;
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            expDeliveryDelay = 0L;
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned");
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetDeliveryDelayTest");
        }
        try {
            expDeliveryDelay = 1L;
            logger.log(System.Logger.Level.INFO, "Calling setDeliveryDelay(" + expDeliveryDelay + ")");
            this.producer.setDeliveryDelay(expDeliveryDelay);
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned");
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetDeliveryDelayTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetDeliveryDelayTest failed");
        }
    }

    @Test
    public void queueSetGetDisableMessageIDTest() throws Exception {
        boolean actDisableMessageID;
        boolean expDisableMessageID;
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            expDisableMessageID = true;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageID(" + expDisableMessageID + ")");
            this.producer.setDisableMessageID(expDisableMessageID);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned");
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetDisableMessageIDTest");
        }
        try {
            expDisableMessageID = false;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageID(" + expDisableMessageID + ")");
            this.producer.setDisableMessageID(expDisableMessageID);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned");
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetDisableMessageIDTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetDisableMessageIDTest failed");
        }
    }

    @Test
    public void queueSetGetDisableMessageTimestampTest() throws Exception {
        boolean actDisableMessageTimestamp;
        boolean expDisableMessageTimestamp;
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            expDisableMessageTimestamp = true;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")");
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned");
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetDisableMessageTimestampTest");
        }
        try {
            expDisableMessageTimestamp = false;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")");
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned");
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetDisableMessageTimestampTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetDisableMessageTimestampTest failed");
        }
    }

    @Test
    public void queueSetGetPriorityTest() throws Exception {
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            int expPriority = 4;
            logger.log(System.Logger.Level.INFO, "Calling getPriority and expect " + expPriority + " to be returned");
            int actPriority = this.producer.getPriority();
            if (actPriority != expPriority) {
                logger.log(System.Logger.Level.ERROR, "getPriority() returned " + actPriority + ", expected " + expPriority);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetPriorityTest");
        }
        int[] expPriority = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (int i = 0; i < expPriority.length; ++i) {
            try {
                logger.log(System.Logger.Level.INFO, "Calling setPriority(" + expPriority[i] + ")");
                this.producer.setPriority(expPriority[i]);
                logger.log(System.Logger.Level.INFO, "Calling getPriority and expect " + expPriority[i] + " to be returned");
                int actPriority = this.producer.getPriority();
                if (actPriority == expPriority[i]) continue;
                logger.log(System.Logger.Level.ERROR, "getPriority() returned " + actPriority + ", expected " + expPriority[i]);
                pass = false;
                continue;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
                throw new Exception("queueSetGetPriorityTest");
            }
        }
        if (!pass) {
            throw new Exception("queueSetGetPriorityTest failed");
        }
    }

    @Test
    public void queueSetGetTimeToLiveTest() throws Exception {
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            long expTimeToLive = 0L;
            logger.log(System.Logger.Level.INFO, "Calling getTimeToLive and expect " + expTimeToLive + " to be returned");
            long actTimeToLive = this.producer.getTimeToLive();
            if (actTimeToLive != expTimeToLive) {
                logger.log(System.Logger.Level.ERROR, "getTimeToLive() returned " + actTimeToLive + ", expected " + expTimeToLive);
                pass = false;
            }
            expTimeToLive = 1000L;
            logger.log(System.Logger.Level.INFO, "Calling setTimeToLive(" + expTimeToLive + ")");
            this.producer.setTimeToLive(expTimeToLive);
            logger.log(System.Logger.Level.INFO, "Calling getTimeToLive and expect " + expTimeToLive + " to be returned");
            actTimeToLive = this.producer.getTimeToLive();
            if (actTimeToLive != expTimeToLive) {
                logger.log(System.Logger.Level.ERROR, "getTimeToLive() returned " + actTimeToLive + ", expected " + expTimeToLive);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueSetGetTimeToLiveTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetTimeToLiveTest failed");
        }
    }

    @Test
    public void queueInvalidDestinationExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = null;
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueInvalidDestinationExceptionTests");
            try {
                logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                this.producer.send(this.destination, (Message)expTextMessage);
                logger.log(System.Logger.Level.ERROR, "Didn't throw InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueInvalidDestinationExceptionTests", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueInvalidDestinationExceptionTests failed");
        }
    }

    @Test
    public void queueUnsupportedOperationExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueUnsupportedOperationExceptionTests");
            try {
                logger.log(System.Logger.Level.INFO, "Send message with destination specified at creation time");
                this.producer.send(this.destination, (Message)expTextMessage);
                logger.log(System.Logger.Level.ERROR, "Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Send message with destination specified at creation time");
                this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e.getMessage());
                pass = false;
            }
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            try {
                logger.log(System.Logger.Level.INFO, "Send message with destination not specified at creation time");
                this.producer.send((Message)expTextMessage);
                logger.log(System.Logger.Level.ERROR, "Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Send message with destination not specified at creation time");
                this.producer.send((Message)expTextMessage, 1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueUnsupportedOperationExceptionTests", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueUnsupportedOperationExceptionTests failed");
        }
    }

    @Test
    public void queueDeliveryDelayTest() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "-----------------------------------------------------------");
            logger.log(System.Logger.Level.INFO, "BEGIN TEST queueDeliveryDelayTest with DeliveryDelay=30Secs");
            logger.log(System.Logger.Level.INFO, "-----------------------------------------------------------");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            this.producer.setDeliveryDelay(30000L);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage message = this.session.createTextMessage("This is a test!");
            logger.log(System.Logger.Level.INFO, "Set StringProperty COM_SUN_JMS_TESTNAME");
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "queueDeliveryDelayTest");
            logger.log(System.Logger.Level.INFO, "Sending message with DeliveryMode.PERSISTENT and DeliveryDelay=30Secs");
            this.producer.send(this.destination, (Message)message, 2, 4, 0L);
            logger.log(System.Logger.Level.INFO, "Waiting 15 seconds to receive message");
            message = (TextMessage)this.consumer.receive(15000L);
            if (message != null) {
                logger.log(System.Logger.Level.ERROR, "FAILED: Message received before delivery delay of 30 secs elapsed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message not available after 15 seconds (CORRECT)");
                logger.log(System.Logger.Level.INFO, "Sleeping 15 more seconds before receiving message");
                Thread.sleep(15000L);
                logger.log(System.Logger.Level.INFO, "Waiting 15 seconds to receive message");
                message = (TextMessage)this.consumer.receive(15000L);
                if (message == null) {
                    logger.log(System.Logger.Level.ERROR, "FAILED: Message was not received after delivery delay of 30 secs elapsed");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Message received after 30 seconds expired (CORRECT)");
                }
            }
            logger.log(System.Logger.Level.INFO, "Sending message with DeliveryMode.NON_PERSISTENT and DeliveryDelay=30Secs");
            this.producer.send(this.destination, (Message)message, 1, 4, 0L);
            logger.log(System.Logger.Level.INFO, "Waiting 15 seconds to receive message");
            message = (TextMessage)this.consumer.receive(15000L);
            if (message != null) {
                logger.log(System.Logger.Level.ERROR, "FAILED: Message received before delivery delay of 30 secs elapsed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message not available after 15 seconds (CORRECT)");
                logger.log(System.Logger.Level.INFO, "Sleeping 15 more seconds before receiving message");
                Thread.sleep(15000L);
                logger.log(System.Logger.Level.INFO, "Waiting 15 seconds to receive message");
                message = (TextMessage)this.consumer.receive(15000L);
                if (message == null) {
                    logger.log(System.Logger.Level.ERROR, "FAILED: Message was not received after delivery delay of 30 secs elapsed");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Message received after 30 seconds expired (CORRECT)");
                }
            }
            logger.log(System.Logger.Level.INFO, "---------------------------------------------------------");
            logger.log(System.Logger.Level.INFO, "END TEST queueDeliveryDelayTest with DeliveryDelay=30Secs");
            logger.log(System.Logger.Level.INFO, "---------------------------------------------------------");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("queueDeliveryDelayTest", e);
        }
        if (!pass) {
            throw new Exception("queueDeliveryDelayTest failed");
        }
    }

    @Test
    public void topicSendAndRecvTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendAndRecvTest1");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            this.consumer.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("topicSendAndRecvTest1", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicSendAndRecvTest1 failed");
        }
    }

    @Test
    public void topicSendAndRecvTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendAndRecvTest2");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, int, int, long)");
            this.producer.send(this.destination, (Message)expTextMessage, 1, 3, 0L);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 3 || actTextMessage.getJMSExpiration() != 0L) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority());
                logger.log(System.Logger.Level.ERROR, "TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("topicSendAndRecvTest2", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicSendAndRecvTest2 failed");
        }
    }

    @Test
    public void topicSendAndRecvTest3() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendAndRecvTest3");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message)");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("topicSendAndRecvTest3", e);
        }
        if (!pass) {
            throw new Exception("topicSendAndRecvTest3 failed");
        }
    }

    @Test
    public void topicSendAndRecvTest4() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendAndRecvTest4");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, int, int, long)");
            this.producer.send((Message)expTextMessage, 1, 3, 0L);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 3 || actTextMessage.getJMSExpiration() != 0L) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority());
                logger.log(System.Logger.Level.ERROR, "TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("topicSendAndRecvTest4", e);
        }
        if (!pass) {
            throw new Exception("topicSendAndRecvTest4 failed");
        }
    }

    @Test
    public void topicSetGetDeliveryModeTest() throws Exception {
        int actDeliveryMode;
        int expDeliveryMode;
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            expDeliveryMode = 2;
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned");
            actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicSetGetDeliveryModeTest");
        }
        try {
            expDeliveryMode = 1;
            logger.log(System.Logger.Level.INFO, "Calling setDeliveryMode(" + expDeliveryMode + ")");
            this.producer.setDeliveryMode(expDeliveryMode);
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned");
            actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicSetGetDeliveryModeTest");
        }
        if (!pass) {
            throw new Exception("topicSetGetDeliveryModeTest failed");
        }
    }

    @Test
    public void topicSetGetDeliveryDelayTest() throws Exception {
        long actDeliveryDelay;
        long expDeliveryDelay;
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            expDeliveryDelay = 0L;
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned");
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicSetGetDeliveryDelayTest");
        }
        try {
            expDeliveryDelay = 1L;
            logger.log(System.Logger.Level.INFO, "Calling setDeliveryDelay(" + expDeliveryDelay + ")");
            this.producer.setDeliveryDelay(expDeliveryDelay);
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned");
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicSetGetDeliveryDelayTest");
        }
        if (!pass) {
            throw new Exception("topicSetGetDeliveryDelayTest failed");
        }
    }

    @Test
    public void topicSetGetDisableMessageIDTest() throws Exception {
        boolean actDisableMessageID;
        boolean expDisableMessageID;
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            expDisableMessageID = true;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageID(" + expDisableMessageID + ")");
            this.producer.setDisableMessageID(expDisableMessageID);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned");
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicSetGetDisableMessageIDTest");
        }
        try {
            expDisableMessageID = false;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageID(" + expDisableMessageID + ")");
            this.producer.setDisableMessageID(expDisableMessageID);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned");
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicSetGetDisableMessageIDTest");
        }
        if (!pass) {
            throw new Exception("topicSetGetDisableMessageIDTest failed");
        }
    }

    @Test
    public void topicSetGetDisableMessageTimestampTest() throws Exception {
        boolean actDisableMessageTimestamp;
        boolean expDisableMessageTimestamp;
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            expDisableMessageTimestamp = true;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")");
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned");
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicSetGetDisableMessageTimestampTest");
        }
        try {
            expDisableMessageTimestamp = false;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")");
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned");
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicSetGetDisableMessageTimestampTest");
        }
        if (!pass) {
            throw new Exception("topicSetGetDisableMessageTimestampTest failed");
        }
    }

    @Test
    public void topicSetGetPriorityTest() throws Exception {
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            int expPriority = 4;
            logger.log(System.Logger.Level.INFO, "Calling getPriority and expect " + expPriority + " to be returned");
            int actPriority = this.producer.getPriority();
            if (actPriority != expPriority) {
                logger.log(System.Logger.Level.ERROR, "getPriority() returned " + actPriority + ", expected " + expPriority);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicSetGetPriorityTest");
        }
        int[] expPriority = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (int i = 0; i < expPriority.length; ++i) {
            try {
                logger.log(System.Logger.Level.INFO, "Calling setPriority(" + expPriority[i] + ")");
                this.producer.setPriority(expPriority[i]);
                logger.log(System.Logger.Level.INFO, "Calling getPriority and expect " + expPriority[i] + " to be returned");
                int actPriority = this.producer.getPriority();
                if (actPriority == expPriority[i]) continue;
                logger.log(System.Logger.Level.ERROR, "getPriority() returned " + actPriority + ", expected " + expPriority[i]);
                pass = false;
                continue;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
                throw new Exception("topicSetGetPriorityTest");
            }
        }
        if (!pass) {
            throw new Exception("topicSetGetPriorityTest failed");
        }
    }

    @Test
    public void topicInvalidDestinationExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = null;
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicInvalidDestinationExceptionTests");
            try {
                logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                this.producer.send(this.destination, (Message)expTextMessage);
                logger.log(System.Logger.Level.ERROR, "Didn't throw InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("queueInvalidDestinationExceptionTests", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicInvalidDestinationExceptionTests failed");
        }
    }

    @Test
    public void topicUnsupportedOperationExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicUnsupportedOperationExceptionTests");
            try {
                logger.log(System.Logger.Level.INFO, "Send message with destination specified at creation time");
                this.producer.send(this.destination, (Message)expTextMessage);
                logger.log(System.Logger.Level.ERROR, "Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Send message with destination specified at creation time");
                this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e.getMessage());
                pass = false;
            }
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            try {
                logger.log(System.Logger.Level.INFO, "Send message with destination not specified at creation time");
                this.producer.send((Message)expTextMessage);
                logger.log(System.Logger.Level.ERROR, "Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Send message with destination not specified at creation time");
                this.producer.send((Message)expTextMessage, 1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("topicUnsupportedOperationExceptionTests", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicUnsupportedOperationExceptionTests failed");
        }
    }

    @Test
    public void topicDeliveryDelayTest() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "-----------------------------------------------------------");
            logger.log(System.Logger.Level.INFO, "BEGIN TEST topicDeliveryDelayTest with DeliveryDelay=30Secs");
            logger.log(System.Logger.Level.INFO, "-----------------------------------------------------------");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            this.producer.setDeliveryDelay(30000L);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage message = this.session.createTextMessage("This is a test!");
            logger.log(System.Logger.Level.INFO, "Set StringProperty COM_SUN_JMS_TESTNAME");
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "topicDeliveryDelayTest");
            logger.log(System.Logger.Level.INFO, "Sending message with DeliveryMode.PERSISTENT and DeliveryDelay=30Secs");
            this.producer.send(this.destination, (Message)message, 2, 4, 0L);
            logger.log(System.Logger.Level.INFO, "Waiting 15 seconds to receive message");
            message = (TextMessage)this.consumer.receive(15000L);
            if (message != null) {
                logger.log(System.Logger.Level.ERROR, "FAILED: Message received before delivery delay of 30 secs elapsed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message not available after 15 seconds (CORRECT)");
                logger.log(System.Logger.Level.INFO, "Sleeping 15 more seconds before receiving message");
                Thread.sleep(15000L);
                logger.log(System.Logger.Level.INFO, "Waiting 15 seconds to receive message");
                message = (TextMessage)this.consumer.receive(15000L);
                if (message == null) {
                    logger.log(System.Logger.Level.ERROR, "FAILED: Message was not received after delivery delay of 30 secs elapsed");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Message received after 30 seconds expired (CORRECT)");
                }
            }
            logger.log(System.Logger.Level.INFO, "Sending message with DeliveryMode.NON_PERSISTENT and DeliveryDelay=30Secs");
            this.producer.send(this.destination, (Message)message, 1, 4, 0L);
            logger.log(System.Logger.Level.INFO, "Waiting 15 seconds to receive message");
            message = (TextMessage)this.consumer.receive(15000L);
            if (message != null) {
                logger.log(System.Logger.Level.ERROR, "FAILED: Message received before delivery delay of 30 secs elapsed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message not available after 15 seconds (CORRECT)");
                logger.log(System.Logger.Level.INFO, "Sleeping 15 more seconds before receiving message");
                Thread.sleep(15000L);
                logger.log(System.Logger.Level.INFO, "Waiting 15 seconds to receive message");
                message = (TextMessage)this.consumer.receive(15000L);
                if (message == null) {
                    logger.log(System.Logger.Level.ERROR, "FAILED: Message was not received after delivery delay of 30 secs elapsed");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Message received after 30 seconds expired (CORRECT)");
                }
            }
            logger.log(System.Logger.Level.INFO, "---------------------------------------------------------");
            logger.log(System.Logger.Level.INFO, "END TEST topicDeliveryDelayTest with DeliveryDelay=30Secs");
            logger.log(System.Logger.Level.INFO, "---------------------------------------------------------");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("topicDeliveryDelayTest", e);
        }
        if (!pass) {
            throw new Exception("topicDeliveryDelayTest failed");
        }
    }

    @Test
    public void JMSExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "JMSExceptionTests");
            try {
                logger.log(System.Logger.Level.INFO, "Try and set an invalid priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.setPriorty(-1)");
                this.producer.setPriority(-1);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and set an invalid delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.setDeliveryMode(-1)");
                this.producer.setDeliveryMode(-1);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, -1, Message.DEFAULT_PRIORITY, 0L)");
                this.producer.send((Message)expTextMessage, -1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, DeliveryMode.NON_PERSISTENT, -1, 0L)");
                this.producer.send((Message)expTextMessage, 1, -1, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, -1, Message.DEFAULT_PRIORITY, 0L, CompletionListener");
                this.producer.send((Message)expTextMessage, -1, 4, 0L, (CompletionListener)new MyCompletionListener());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, DeliveryMode.NON_PERSISTENT, -1, 0L, CompletionListener");
                this.producer.send((Message)expTextMessage, 1, -1, 0L, (CompletionListener)new MyCompletionListener());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, -1, Message.DEFAULT_PRIORITY, 0L)");
                this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, DeliveryMode.NON_PERSISTENT, -1, 0L)");
                this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, -1, Message.DEFAULT_PRIORITY, 0L, CompletionListener)");
                this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L, (CompletionListener)new MyCompletionListener());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, DeliveryMode.NON_PERSISTENT, -1, 0L, CompletionListener)");
                this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L, (CompletionListener)new MyCompletionListener());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            this.cleanup();
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "JMSExceptionTests");
            try {
                logger.log(System.Logger.Level.INFO, "Try and set an invalid priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.setPriorty(-1)");
                this.producer.setPriority(-1);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and set an invalid delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.setDeliveryMode(-1)");
                this.producer.setDeliveryMode(-1);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, -1, Message.DEFAULT_PRIORITY, 0L)");
                this.producer.send((Message)expTextMessage, -1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, DeliveryMode.NON_PERSISTENT, -1, 0L)");
                this.producer.send((Message)expTextMessage, 1, -1, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, -1, Message.DEFAULT_PRIORITY, 0L, CompletionListener");
                this.producer.send((Message)expTextMessage, -1, 4, 0L, (CompletionListener)new MyCompletionListener());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, DeliveryMode.NON_PERSISTENT, -1, 0L, CompletionListener");
                this.producer.send((Message)expTextMessage, 1, -1, 0L, (CompletionListener)new MyCompletionListener());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, -1, Message.DEFAULT_PRIORITY, 0L)");
                this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, DeliveryMode.NON_PERSISTENT, -1, 0L)");
                this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with delivery mode of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, -1, Message.DEFAULT_PRIORITY, 0L, CompletionListener)");
                this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L, (CompletionListener)new MyCompletionListener());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Try and send message with priority of -1");
                logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, DeliveryMode.NON_PERSISTENT, -1, 0L, CompletionListener)");
                this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L, (CompletionListener)new MyCompletionListener());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e.getMessage());
            throw new Exception("JMSExceptionTests", e);
        }
        if (!pass) {
            throw new Exception("JMSExceptionTests failed");
        }
    }

    private static class MyCompletionListener
    implements CompletionListener {
        public MyCompletionListener() {
            logger.log(System.Logger.Level.INFO, "MyCompletionListener()");
        }

        public void onCompletion(Message message) {
            logger.log(System.Logger.Level.INFO, "onCompletion()");
        }

        public void onException(Message message, Exception exception) {
            logger.log(System.Logger.Level.INFO, "onException()");
        }
    }
}

