/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgPropsT;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.MDB_T_Test;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    @EJB(name="ejb/MDB_MSGPropsT_Test")
    private static MDB_T_Test hr;
    private Properties props = new Properties();
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.props.put("jms_timeout", System.getProperty("jms_property"));
            this.props.put("user", System.getProperty("user"));
            this.props.put("password", System.getProperty("password"));
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            hr.setup(this.props);
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void mdbMsgPropertiesTTest() throws Exception {
        String testCase1 = "msgPropertiesTTestCreate";
        String testCase2 = "msgPropertiesTTest";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to run msgPropertiesTTestCreate");
            hr.askMDBToRunATest(testCase1);
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgPropertiesTTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgPropertiesConversionTTest() throws Exception {
        String testCase1 = "msgPropertiesConversionTTestCreate";
        String testCase2 = "msgPropertiesConversionTTest";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to run msgPropertiesConversionTTestCreate");
            hr.askMDBToRunATest(testCase1);
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgPropertiesConversionTTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    static {
        logger = System.getLogger(MDBClientIT.class.getName());
    }
}

