/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndToQueue;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.MDB_Q_Test;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    @EJB(name="ejb/MDB_SNDToQueue_Test")
    private static MDB_Q_Test hr;
    private Properties props = new Properties();
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        this.props.put("jms_timeout", System.getProperty("jms_property"));
        this.props.put("user", System.getProperty("user"));
        this.props.put("password", System.getProperty("password"));
        try {
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            hr.setup(this.props);
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void mdbSendTextMsgToQueueTest() throws Exception {
        String messageType = "TextMessage";
        String matchMe = "TextMessageFromMsgBean";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a text message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendTextMsgToQueueTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendBytesMsgToQueueTest() throws Exception {
        String messageType = "BytesMessage";
        String matchMe = "BytesMessageFromMsgBean";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a Bytes message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendBytesMsgToQueueTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendMapMsgToQueueTest() throws Exception {
        String matchMe = "MapMessageFromMsgBean";
        String messageType = "MapMessage";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a map message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendMapMsgToQueueTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendStreamMsgToQueueTest() throws Exception {
        String matchMe = "StreamMessageFromMsgBean";
        String messageType = "StreamMessage";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a stream message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendStreamMsgToQueueTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendObjectMsgToQueueTest() throws Exception {
        String matchMe = "ObjectMessageFromMsgBean";
        String messageType = "ObjectMessage";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send an object message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendObjectMsgToQueueTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    static {
        logger = System.getLogger(MDBClientIT.class.getName());
    }
}

