/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.usecases;

import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.tests.jms.ee20.cditests.usecases.BMBean1IF;
import com.sun.ts.tests.jms.ee20.cditests.usecases.BMBean2IF;
import com.sun.ts.tests.jms.ee20.cditests.usecases.CMBean1IF;
import com.sun.ts.tests.jms.ee20.cditests.usecases.CMBean2IF;
import jakarta.ejb.EJB;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    @EJB(name="ejb/CDIUseCasesCMBEAN1")
    static CMBean1IF cmbean1;
    @EJB(name="ejb/CDIUseCasesCMBEAN2")
    static CMBean2IF cmbean2;
    @EJB(name="ejb/CDIUseCasesBMBEAN1")
    static BMBean1IF bmbean1;
    @EJB(name="ejb/CDIUseCasesBMBEAN2")
    static BMBean2IF bmbean2;
    private static final long serialVersionUID = 1L;
    long timeout;
    String user;
    String password;
    String mode;
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        boolean pass = true;
        try {
            this.timeout = Integer.parseInt(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.hostname = System.getProperty("webServerHost");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            if (this.hostname == null) {
                throw new Exception("'webServerHost' is null");
            }
            try {
                this.portnum = Integer.parseInt(System.getProperty("webServerPort"));
            }
            catch (Exception e) {
                throw new Exception("'webServerPort' in must be a number");
            }
            logger.log(System.Logger.Level.INFO, "AppClient DEBUG: cmbean1=" + cmbean1 + " cmbean2=" + cmbean2);
            logger.log(System.Logger.Level.INFO, "AppClient DEBUG: bmbean1=" + bmbean1 + " bmbean2=" + bmbean2);
            if (cmbean1 == null || cmbean2 == null || bmbean1 == null || bmbean2 == null) {
                throw new Exception("setup failed: ejb injection failure");
            }
        }
        catch (Exception e) {
            throw new Exception("setup failed:", e);
        }
        logger.log(System.Logger.Level.INFO, "setup ok");
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    @Test
    public void beanUseCaseA() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseA");
            logger.log(System.Logger.Level.INFO, "------------");
            cmbean1.method1a();
            cmbean1.method1b();
            boolean status = cmbean1.cleanupQueue(2);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseA cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseA passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseA failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseA failed");
        }
    }

    @Test
    public void beanUseCaseB() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseB");
            logger.log(System.Logger.Level.INFO, "------------");
            cmbean1.method2();
            boolean status = cmbean1.cleanupQueue(2);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseB cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseB passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseB failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseB failed");
        }
    }

    @Test
    public void beanUseCaseC() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseC");
            logger.log(System.Logger.Level.INFO, "------------");
            cmbean1.method3();
            boolean status = cmbean1.cleanupQueue(2);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseC cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseC passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseC failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseC failed");
        }
    }

    @Test
    public void beanUseCaseD() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseD");
            logger.log(System.Logger.Level.INFO, "------------");
            cmbean1.method4();
            boolean status = cmbean1.cleanupQueue(2);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseD cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseD passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseD failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseD failed");
        }
    }

    @Test
    public void beanUseCaseE() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseE");
            logger.log(System.Logger.Level.INFO, "------------");
            bmbean1.method1();
            boolean status = bmbean1.cleanupQueue(2);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseE cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseE passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseE failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseE failed");
        }
    }

    @Test
    public void beanUseCaseF() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseF");
            logger.log(System.Logger.Level.INFO, "------------");
            bmbean1.method2();
            boolean status = bmbean1.cleanupQueue(2);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseF cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseF passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseF failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseF failed");
        }
    }

    @Test
    public void beanUseCaseG() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseG");
            logger.log(System.Logger.Level.INFO, "------------");
            bmbean1.method3();
            boolean status = bmbean1.cleanupQueue(4);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseG cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseG passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseG failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseG failed");
        }
    }

    @Test
    public void beanUseCaseH() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseH");
            logger.log(System.Logger.Level.INFO, "------------");
            bmbean1.method4();
            boolean status = bmbean1.cleanupQueue(5);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseH cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseH passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseH failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseH failed");
        }
    }

    @Test
    public void beanUseCaseJ() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseJ");
            logger.log(System.Logger.Level.INFO, "------------");
            cmbean1.method5();
            boolean status = cmbean1.cleanupQueue(3);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseJ cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseJ passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseJ failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseJ failed");
        }
    }

    @Test
    public void beanUseCaseK() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------");
            logger.log(System.Logger.Level.INFO, "BeanUseCaseK");
            logger.log(System.Logger.Level.INFO, "------------");
            cmbean1.method6();
            boolean status = cmbean1.cleanupQueue(2);
            if (!status) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "beanUseCaseK cleanup of Queue failed");
            } else {
                logger.log(System.Logger.Level.INFO, "beanUseCaseK passed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            logger.log(System.Logger.Level.ERROR, "beanUseCaseK failed");
            pass = false;
        }
        if (!pass) {
            throw new Exception("beanUseCaseK failed");
        }
    }

    static {
        logger = System.getLogger(ClientIT.class.getName());
    }
}

