/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.ecoretools.operation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egf.portfolio.genchain.ecoretools.command.CreateEdgeCommand;
import org.eclipse.egf.portfolio.genchain.ecoretools.command.CreateNodeCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.LayoutService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.query.EdgeMappingQuery;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.ui.business.api.view.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.ui.business.api.view.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.ui.internal.refresh.SynchronizeGMFModelCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.DiagramCreationUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.part.OffscreenEditPartFactory;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateEcoreTools2RepresentationOperation
extends WorkspaceModifyOperation {
    private static final String _AIRD_FILE_EXTENSION = "aird";
    protected static final String VIEWPOINT_ECORE_DESIGN = "Design";
    protected static final String REPRESENTATION__ENTITIES_DIAGRAM = "Entities";
    protected static final String REPRESENTATION__DOCUMENTATION_TABLE = "Classes";
    protected Set<Viewpoint> viewpoints = new HashSet<Viewpoint>();
    protected List<RepresentationDescription> representations = new ArrayList<RepresentationDescription>();
    private String representationFileName;
    private URI representationFileURI;
    private IProject representationProject;
    private URI ecoreModelURI;

    public CreateEcoreTools2RepresentationOperation(URI ecoreURI, String fileName) {
        this.ecoreModelURI = ecoreURI;
        this.initRepresentationFileInformations(fileName);
        this.initViewpointsList();
    }

    private void initRepresentationFileInformations(String fileName) {
        this.representationFileName = this.getRepresentationFileName(fileName);
        this.representationFileURI = this.getRepresentationUri(fileName);
        this.representationProject = this.getRepresentationProject(fileName);
    }

    private boolean isFqnFileName(String fileName) {
        return fileName != null && !fileName.isEmpty() && fileName.contains("/");
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Session session = this.createRepresentationFile(monitor);
        if (session != null) {
            DDiagram diagram = this.createDiagrams(session, monitor);
            if (diagram != null) {
                this.populateEntitiesDiagram(session, diagram);
                this.arrangeAll(session, diagram);
            }
            session.save(monitor);
        }
    }

    private DDiagram createDiagrams(Session session, IProgressMonitor monitor) {
        DDiagram entitiesDiagram = null;
        List<EPackage> ecoreEPackages = this.getEcoreEPackagesFromSession(session);
        for (EPackage iEPackage : ecoreEPackages) {
            Collection representations = DialectManager.INSTANCE.getRepresentations((EObject)iEPackage, session);
            if (representations.isEmpty()) {
                entitiesDiagram = this.createEntitiesDiagram(iEPackage, session, monitor);
                this.createClassesTable(iEPackage, session, monitor);
                continue;
            }
            ArrayList<String> representationDescriptionNames = new ArrayList<String>();
            for (DRepresentation representation : representations) {
                if (representation instanceof DDiagram) {
                    DDiagramElement dDiagramElement;
                    DDiagram dDiagram = (DDiagram)representation;
                    DiagramDescription description = dDiagram.getDescription();
                    representationDescriptionNames.add(description.getName());
                    EList ownedDiagramElements = dDiagram.getOwnedDiagramElements();
                    if (ownedDiagramElements.isEmpty()) {
                        entitiesDiagram = dDiagram;
                        continue;
                    }
                    if (ownedDiagramElements.size() != 1 || !(dDiagramElement = (DDiagramElement)ownedDiagramElements.get(0)).getMapping().getName().equals("Empty Diagram")) continue;
                    entitiesDiagram = dDiagram;
                    continue;
                }
                if (!(representation instanceof DTable)) continue;
                TableDescription description = ((DTable)representation).getDescription();
                representationDescriptionNames.add(description.getName());
            }
            if (!representationDescriptionNames.contains(REPRESENTATION__ENTITIES_DIAGRAM)) {
                entitiesDiagram = this.createEntitiesDiagram(iEPackage, session, monitor);
            }
            if (representationDescriptionNames.contains(REPRESENTATION__DOCUMENTATION_TABLE)) continue;
            this.createClassesTable(iEPackage, session, monitor);
        }
        return entitiesDiagram;
    }

    private void arrangeAll(Session session, DDiagram diagram) {
        DiagramCreationUtil util = new DiagramCreationUtil(diagram);
        Diagram associatedGMFDiagram = null;
        if (!util.findAssociatedGMFDiagram()) {
            util.createNewGMFDiagram();
            associatedGMFDiagram = util.getAssociatedGMFDiagram();
            if (associatedGMFDiagram != null) {
                session.getServices().putCustomData("GMF_DIAGRAMS", (EObject)diagram, (EObject)associatedGMFDiagram);
            }
        } else {
            associatedGMFDiagram = util.getAssociatedGMFDiagram();
        }
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        if (associatedGMFDiagram != null) {
            CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(associatedGMFDiagram);
            SynchronizeGMFModelCommand gmfNotationModelSynchronizationCmd = new SynchronizeGMFModelCommand(domain, canonicalSynchronizer);
            domain.getCommandStack().execute((Command)gmfNotationModelSynchronizationCmd);
        }
        final Diagram associatedGMFDiagram_f = associatedGMFDiagram;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell shell = new Shell(Display.getDefault());
                DiagramEditPart diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(associatedGMFDiagram_f, shell);
                ListIterator listIterator = associatedGMFDiagram_f.getChildren().listIterator();
                while (listIterator.hasNext()) {
                    Object next = listIterator.next();
                    GraphicalEditPart g = (GraphicalEditPart)diagramEP.getPrimaryEditParts().get(0);
                    next.toString();
                    diagramEP.getViewer().getEditPartRegistry().put(next, g);
                }
                ArrayList<String> hints = new ArrayList<String>(2);
                hints.add("DEFAULT");
                hints.add((String)diagramEP);
                ObjectAdapter layoutHint = new ObjectAdapter(hints);
                List layoutNodes = LayoutService.getInstance().getLayoutNodes(diagramEP, (List)associatedGMFDiagram_f.getChildren());
                Runnable layoutRun = LayoutService.getInstance().layoutLayoutNodes(layoutNodes, false, (IAdaptable)layoutHint);
                layoutRun.run();
            }
        });
    }

    private void populateEntitiesDiagram(Session session, DDiagram diagram) {
        List<EPackage> ecoreEPackagesFromSession = this.getEcoreEPackagesFromSession(session);
        for (EPackage ePackage : ecoreEPackagesFromSession) {
            this.populateNodesAndContainers(session, diagram, ePackage);
            this.populateEdges(session, diagram, ePackage);
        }
        this.refreshDiagram(session, diagram);
    }

    private void refreshDiagram(Session session, final DDiagram diagram) {
        TransactionalEditingDomain editingDomain = session.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                diagram.refresh();
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    private void populateEdges(Session session, DDiagram diagram, EPackage ePackage) {
        DiagramDescription description = diagram.getDescription();
        EList allEdgeMappings = description.getDefaultLayer().getEdgeMappings();
        TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
        for (EdgeMapping edgeMapping : allEdgeMappings) {
            boolean useDomainElement = edgeMapping.isUseDomainElement();
            if (useDomainElement) {
                EdgeMappingQuery edgeMappingQuery = new EdgeMappingQuery(edgeMapping);
                Collection candidates = edgeMappingQuery.evaluateCandidateExpression((DSemanticDiagram)diagram, session.getInterpreter(), (DragAndDropTarget)diagram);
                for (EObject eObject : candidates) {
                    CreateEdgeCommand command = new CreateEdgeCommand(session, diagram, edgeMapping, eObject, useDomainElement);
                    transactionalEditingDomain.getCommandStack().execute((Command)command);
                }
                continue;
            }
            for (EObject semantic : ePackage.eContents()) {
                CreateEdgeCommand command = new CreateEdgeCommand(session, diagram, edgeMapping, semantic, useDomainElement);
                transactionalEditingDomain.getCommandStack().execute((Command)command);
            }
        }
        transactionalEditingDomain.getCommandStack().flush();
    }

    private void populateNodesAndContainers(Session session, DDiagram diagram, EPackage ePackage) {
        EList containerMappings;
        BasicEList abstractNodeMappings = new BasicEList();
        DiagramDescription description = diagram.getDescription();
        EList nodeMappings = description.getAllNodeMappings();
        if (!nodeMappings.isEmpty()) {
            abstractNodeMappings.addAll((Collection)nodeMappings);
        }
        if (!(containerMappings = description.getAllContainerMappings()).isEmpty()) {
            abstractNodeMappings.addAll((Collection)containerMappings);
        }
        ModelAccessor modelAccessor = session.getModelAccessor();
        for (AbstractNodeMapping abstractNodeMapping : abstractNodeMappings) {
            String domainClass = abstractNodeMapping.getDomainClass();
            for (EObject element : ePackage.eContents()) {
                if (!modelAccessor.eInstanceOf(element, domainClass)) continue;
                CreateNodeCommand command = new CreateNodeCommand(session, diagram, abstractNodeMapping, element);
                session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
            }
        }
    }

    private DDiagram createEntitiesDiagram(EPackage semantic, Session session, IProgressMonitor monitor) {
        RepresentationDescription entitiesDiagram = this.getRepresentationDescription(REPRESENTATION__ENTITIES_DIAGRAM);
        String diagramName = String.valueOf(semantic.getName()) + " entities diagram";
        DRepresentation createRepresentation = this.createRepresentation((EObject)semantic, session, entitiesDiagram, diagramName, monitor);
        return (DDiagram)createRepresentation;
    }

    private DTable createClassesTable(EPackage semantic, Session session, IProgressMonitor monitor) {
        RepresentationDescription classesTable = this.getRepresentationDescription(REPRESENTATION__DOCUMENTATION_TABLE);
        String tableName = String.valueOf(semantic.getName()) + " documentation";
        DRepresentation createRepresentation = this.createRepresentation((EObject)semantic, session, classesTable, tableName, monitor);
        return (DTable)createRepresentation;
    }

    private DRepresentation createRepresentation(EObject semantic, Session session, RepresentationDescription description, String name, IProgressMonitor monitor) {
        CreateRepresentationCommand createRepresentationCommand = new CreateRepresentationCommand(session, description, semantic, name, monitor);
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)createRepresentationCommand);
        DRepresentation createdRepresentation = createRepresentationCommand.getCreatedRepresentation();
        return createdRepresentation;
    }

    private RepresentationDescription getRepresentationDescription(String representationName) {
        for (RepresentationDescription representation : this.representations) {
            if (!representation.getName().equals(representationName)) continue;
            return representation;
        }
        return null;
    }

    private List<EPackage> getEcoreEPackagesFromSession(Session session) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (Resource resource : session.getSemanticResources()) {
            EObject eObject;
            EList contents;
            if (!resource.getURI().toString().equals(this.ecoreModelURI.toString()) || (contents = resource.getContents()) == null || contents.isEmpty() || !((eObject = (EObject)contents.get(0)) instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)eObject;
            result.add(ePackage);
            List<EPackage> subPackages = this.getSubPackages(ePackage);
            if (subPackages.isEmpty()) continue;
            result.addAll(subPackages);
        }
        return result;
    }

    private List<EPackage> getSubPackages(EPackage parent) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EList eSubpackages = parent.getESubpackages();
        if (eSubpackages != null && !eSubpackages.isEmpty()) {
            result.addAll((Collection<EPackage>)eSubpackages);
            for (EPackage ePackage : eSubpackages) {
                List<EPackage> children = this.getSubPackages(ePackage);
                if (children.isEmpty()) continue;
                result.addAll(children);
            }
        }
        return result;
    }

    private Session createRepresentationFile(IProgressMonitor monitor) {
        monitor.subTask("create the representation model...");
        IProject project = this.representationProject;
        Session session = CreateEcoreTools2RepresentationOperation.createAird(project, this.representationFileURI, monitor);
        if (session == null) {
            throw new RuntimeException("Can't create a session for " + this.representationFileURI.toString());
        }
        session.getTransactionalEditingDomain().getResourceSet().getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        AddSemanticResourceCommand addSemanticResourceCommand = new AddSemanticResourceCommand(session, this.ecoreModelURI, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ChangeViewpointSelectionCommand changeViewpointSelectionCommand = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), this.viewpoints, Collections.emptySet(), false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        CompoundCommand compoundCommand = new CompoundCommand("Link resources to representation");
        compoundCommand.append((Command)addSemanticResourceCommand);
        compoundCommand.append((Command)changeViewpointSelectionCommand);
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)compoundCommand);
        return session;
    }

    public static Session createAird(IProject project, URI representationsURI, IProgressMonitor monitor) {
        Session session = null;
        Option modelingProject = ModelingProject.asModelingProject((IProject)project);
        if (modelingProject.some()) {
            session = ((ModelingProject)modelingProject.get()).getSession();
        } else {
            DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(representationsURI, monitor);
            try {
                sessionCreationOperation.execute();
                session = sessionCreationOperation.getCreatedSession();
            }
            catch (CoreException e) {
                throw new RuntimeException("Can't create session for " + representationsURI, e);
            }
        }
        return session;
    }

    private URI getRepresentationUri(String fileName) {
        String stringRepresentationURI = "";
        if (this.isFqnFileName(fileName)) {
            stringRepresentationURI = fileName;
        } else {
            URI ecoreUriWithoutFileExtension = this.ecoreModelURI.trimFileExtension();
            if (ecoreUriWithoutFileExtension != null && ecoreUriWithoutFileExtension.segmentCount() > 1) {
                int i = 1;
                while (i < ecoreUriWithoutFileExtension.segments().length - 1) {
                    stringRepresentationURI = String.valueOf(stringRepresentationURI) + "/" + ecoreUriWithoutFileExtension.segments()[i];
                    ++i;
                }
                stringRepresentationURI = String.valueOf(stringRepresentationURI) + "/" + this.representationFileName;
            } else {
                throw new RuntimeException("Ecore URI is not valid");
            }
        }
        if (stringRepresentationURI.length() > 0) {
            return URI.createPlatformResourceURI((String)stringRepresentationURI, (boolean)true);
        }
        throw new RuntimeException("Error on creating representation URI");
    }

    private String getRepresentationFileName(String fileName) {
        if (fileName == null || fileName != null && fileName.trim().length() < 1) {
            URI ecoreUriWithoutFileExtension = this.ecoreModelURI.trimFileExtension();
            if (ecoreUriWithoutFileExtension != null && ecoreUriWithoutFileExtension.segmentCount() > 1) {
                String ecoreModelName = ecoreUriWithoutFileExtension.lastSegment();
                ecoreModelName = String.valueOf(ecoreModelName) + ".aird";
                return ecoreModelName;
            }
            throw new RuntimeException("Ecore file URI is not valid");
        }
        boolean fqnFileName = this.isFqnFileName(fileName);
        if (fqnFileName) {
            String[] segments = fileName.split("/");
            String lastSegment = segments[segments.length - 1];
            if (lastSegment.contains(_AIRD_FILE_EXTENSION)) {
                return lastSegment;
            }
            return String.valueOf(lastSegment) + "." + _AIRD_FILE_EXTENSION;
        }
        return fileName;
    }

    private IProject getRepresentationProject(String fileName) {
        String projectName = null;
        ArrayList<String> foldersToCreate = new ArrayList<String>();
        if (this.isFqnFileName(fileName)) {
            String[] segments = fileName.split("/");
            projectName = segments[0];
            int i = 1;
            while (i < segments.length - 1) {
                foldersToCreate.add(segments[i]);
                ++i;
            }
        } else {
            projectName = this.ecoreModelURI.isPlatform() ? this.ecoreModelURI.segment(1) : this.ecoreModelURI.segment(0);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        NullProgressMonitor NPM = new NullProgressMonitor();
        try {
            if (!project.exists()) {
                project.create((IProgressMonitor)NPM);
            }
            project.open((IProgressMonitor)NPM);
        }
        catch (CoreException e) {
            throw new RuntimeException("Project with name : " + projectName + " can't be localized", e);
        }
        if (!foldersToCreate.isEmpty()) {
            IFolder currentFolder = null;
            for (String folderName : foldersToCreate) {
                if ((currentFolder = currentFolder == null ? project.getFolder(folderName) : currentFolder.getFolder(folderName)).exists()) continue;
                try {
                    currentFolder.create(true, true, (IProgressMonitor)NPM);
                }
                catch (CoreException e) {
                    throw new RuntimeException("Can't create folder : " + currentFolder, e);
                }
            }
        }
        return project;
    }

    private void initViewpointsList() {
        for (Viewpoint viewpoint : ViewpointRegistry.getInstance().getViewpoints()) {
            if (!viewpoint.getName().equals(VIEWPOINT_ECORE_DESIGN) || !viewpoint.eResource().getURI().segmentsList().contains("org.eclipse.emf.ecoretools.design")) continue;
            this.viewpoints.add(viewpoint);
            break;
        }
        if (!this.viewpoints.isEmpty()) {
            for (Viewpoint viewpoint : this.viewpoints) {
                EList ownedRepresentations = viewpoint.getOwnedRepresentations();
                if (ownedRepresentations == null || ownedRepresentations.isEmpty()) continue;
                for (RepresentationDescription representationDescription : ownedRepresentations) {
                    if (!representationDescription.getName().equals(REPRESENTATION__ENTITIES_DIAGRAM) && !representationDescription.getName().equals(REPRESENTATION__DOCUMENTATION_TABLE)) continue;
                    this.representations.add(representationDescription);
                }
            }
        }
    }
}

