/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class ConfigurationChecker {
    private ConfigurationChecker() {
    }

    private static void checkLfs(IProgressMonitor monitor) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean auto = store.getBoolean("auto_lfs_config");
        if (auto && !ConfigurationChecker.isLfsConfigured(monitor)) {
            try {
                LfsFactory.LfsInstallCommand cmd = LfsFactory.getInstance().getInstallCommand();
                if (cmd != null && !monitor.isCanceled()) {
                    cmd.call();
                }
            }
            catch (Exception e) {
                Activator.handleIssue(2, UIText.ConfigurationChecker_installLfsCannotInstall, e, !monitor.isCanceled());
            }
        }
    }

    private static boolean isLfsConfigured(IProgressMonitor monitor) {
        FileBasedConfig cfg;
        block3: {
            try {
                cfg = SystemReader.getInstance().openUserConfig(null, FS.DETECTED);
                if (!monitor.isCanceled()) break block3;
                return true;
            }
            catch (Exception e) {
                Activator.handleIssue(2, UIText.ConfigurationChecker_installLfsCannotLoadConfig, e, false);
                return false;
            }
        }
        cfg.load();
        return cfg.getSubsections("filter").contains("lfs");
    }

    private static void checkHome(IProgressMonitor monitor) {
        boolean hidden;
        String home = System.getenv("HOME");
        if (home != null) {
            return;
        }
        home = ConfigurationChecker.calcHomeDir();
        String message = NLS.bind((String)UIText.ConfigurationChecker_homeNotSet, (Object)home);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean bl = hidden = !store.getBoolean("show_home_drive_warning");
        if (!hidden && !monitor.isCanceled()) {
            Activator.handleIssue(2, message, null, false);
        }
    }

    private static String calcHomeDir() {
        if (ConfigurationChecker.runsOnWindows()) {
            String homeDrive = System.getenv("HOMEDRIVE");
            if (homeDrive != null) {
                String homePath = SystemReader.getInstance().getenv("HOMEPATH");
                return new File(homeDrive, homePath).getAbsolutePath();
            }
            return System.getenv("HOMESHARE");
        }
        return System.getProperty("user.home");
    }

    private static boolean runsOnWindows() {
        String os;
        try {
            os = System.getProperty("os.name");
        }
        catch (RuntimeException e) {
            return false;
        }
        return os.contains("Windows");
    }

    @Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
    public static class Checker
    extends Job
    implements EventHandler {
        public Checker() {
            super(UIText.ConfigurationChecker_checkConfiguration);
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            ConfigurationChecker.checkHome((IProgressMonitor)progress.newChild(1));
            ConfigurationChecker.checkLfs((IProgressMonitor)progress.newChild(1));
            return Status.OK_STATUS;
        }

        public void handleEvent(Event event) {
            if ("org/eclipse/e4/ui/LifeCycle/appStartupComplete".equals(event.getTopic())) {
                this.schedule();
            }
        }

        @Deactivate
        void stop() {
            this.cancel();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

