/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.DescribeCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_Describe")
class Describe
extends TextBuiltin {
    @Argument(index=0, metaVar="metaVar_treeish")
    private ObjectId tree;
    @Option(name="--long", usage="usage_LongFormat")
    private boolean longDesc;
    @Option(name="--all", usage="usage_UseTags")
    private boolean useAll;
    @Option(name="--tags", usage="usage_UseTags")
    private boolean useTags;
    @Option(name="--always", usage="usage_AlwaysFallback")
    private boolean always;
    @Option(name="--match", usage="usage_Match", metaVar="metaVar_pattern")
    private List<String> patterns = new ArrayList<String>();
    @Option(name="--exclude", usage="usage_Exclude", metaVar="metaVar_pattern")
    private List<String> excludes = new ArrayList<String>();
    @Option(name="--abbrev", usage="usage_Abbrev")
    private Integer abbrev;

    Describe() {
    }

    @Override
    protected void run() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Git git = new Git(this.db);){
                DescribeCommand cmd = git.describe();
                if (this.tree != null) {
                    cmd.setTarget(this.tree);
                }
                cmd.setLong(this.longDesc);
                cmd.setAll(this.useAll);
                cmd.setTags(this.useTags);
                cmd.setAlways(this.always);
                cmd.setMatch(this.patterns.toArray(new String[0]));
                cmd.setExclude(this.excludes.toArray(new String[0]));
                if (this.abbrev != null) {
                    cmd.setAbbrev(this.abbrev.intValue());
                }
                String result = null;
                try {
                    result = cmd.call();
                }
                catch (RefNotFoundException e) {
                    throw Describe.die(CLIText.get().noNamesFound, (Throwable)e);
                }
                if (result == null) {
                    throw Describe.die(CLIText.get().noNamesFound);
                }
                this.outw.println(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException | InvalidPatternException e) {
            throw Describe.die(e.getMessage(), e);
        }
    }
}

