/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class Group {
    public final GroupType groupType;
    public final BitSet members;
    public final BitSet localNodes;
    public final List<Group> childGroups;
    private int shuffledBase = -1;

    public Group(GroupType groupType, BitSet localNodes) {
        this(groupType, localNodes, Collections.emptyList());
    }

    public Group(GroupType groupType, BitSet localNodes, List<Group> childGroups) {
        this.groupType = groupType;
        this.localNodes = localNodes;
        this.childGroups = childGroups;
        this.members = BitSets.bitset();
        if (localNodes != null) {
            this.members.or(localNodes);
        }
        for (Group childGrp : childGroups) {
            this.members.or(childGrp.members);
        }
    }

    public void dbgDump(DebugNormalOutput dbg) {
        this.dbgDump("    ", dbg);
    }

    public void dbgDump(String indent, DebugNormalOutput dbg) {
        if (!dbg.isEnabled()) {
            return;
        }
        dbg.line("%s- Grouptype %s", new Object[]{indent, this.groupType.name()});
        dbg.line("%s  Local nodes: %s", new Object[]{indent, this.localNodes == null ? "<none>" : this.localNodes.toString()});
        for (Group child : this.childGroups) {
            child.dbgDump(indent + "    ", dbg);
        }
    }

    public void setShuffledBase(int base) {
        Assert.check((base >= 0 ? 1 : 0) != 0);
        this.shuffledBase = base;
    }

    public int getShuffledBase() {
        return this.shuffledBase;
    }

    public int getShuffledSize() {
        if (this.shuffledBase < 0) {
            return -1;
        }
        return this.members.cardinality();
    }

    public boolean isElementary() {
        return this.childGroups.isEmpty();
    }

    public static enum GroupType {
        BUS,
        CLUSTER,
        COLLECTION;

    }
}

