/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.escet.common.java.Assert;

public class Maps {
    private Maps() {
    }

    public static <TK, TV> Map<TK, TV> put(Map<TK, TV> map, TK key, TV value) {
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> map() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> mapc(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <KR, KI extends KR, VR, VI extends VR> LinkedHashMap<KR, VR> copy(Map<KI, VI> m) {
        return new LinkedHashMap<KI, VI>(m);
    }

    public static <V, K> Map<V, K> invert(Map<K, V> map) {
        Map<V, K> inv = Maps.mapc(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Assert.notNull(entry.getKey());
            Assert.notNull(entry.getValue());
            V prevValue = inv.put(entry.getValue(), entry.getKey());
            Assert.check(prevValue == null, "Cannot invert the map, as it is not a one-to-one map.");
        }
        return inv;
    }
}

