/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifPartialSpecAnnotationUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class ConvertToInterface
extends CifWalker
implements CifToCifTransformation {
    private final InterfaceKind interfaceKind;
    private final Set<InputVariable> addedInputVars = Sets.set();
    private final Map<ComponentDef, List<Parameter>> origCompDefParams = Maps.map();

    public ConvertToInterface(InterfaceKind interfaceKind) {
        this.interfaceKind = interfaceKind;
    }

    @Override
    public void transform(Specification spec) {
        this.walkSpecification(spec);
        CifPartialSpecAnnotationUtils.makePartial((Specification)spec);
    }

    protected void preprocessAnnotatedObject(AnnotatedObject annotatedObj) {
        annotatedObj.getAnnotations().clear();
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        comp.getIoDecls().clear();
        comp.getInitials().clear();
        comp.getMarkeds().clear();
        comp.getInvariants().clear();
        comp.getEquations().clear();
        if (this.interfaceKind == InterfaceKind.REDUCED) {
            comp.getDeclarations().removeIf(d -> d instanceof Function);
            comp.getDeclarations().removeIf(d -> {
                InputVariable i;
                return d instanceof InputVariable && !this.addedInputVars.contains(i = (InputVariable)d);
            });
        }
    }

    protected void preprocessComponentDef(ComponentDef compDef) {
        this.origCompDefParams.put(compDef, Lists.copy((List)compDef.getParameters()));
        compDef.getParameters().removeIf(p -> !(p instanceof ComponentParameter));
    }

    protected void preprocessComponentInst(ComponentInst compInst) {
        CifType compDefType = CifTypeUtils.normalizeType((CifType)compInst.getDefinition());
        Assert.check((boolean)(compDefType instanceof ComponentDefType));
        ComponentDef compDef = ((ComponentDefType)compDefType).getDefinition();
        EList params = this.origCompDefParams.get(compDef);
        if (params == null) {
            params = compDef.getParameters();
        }
        int i = params.size() - 1;
        while (i >= 0) {
            if (!(params.get(i) instanceof ComponentParameter)) {
                compInst.getArguments().remove(i);
            }
            --i;
        }
    }

    protected void postprocessAlgVariable(AlgVariable algVar) {
        InputVariable inputVar = CifConstructors.newInputVariable();
        inputVar.setName(algVar.getName());
        inputVar.setType(algVar.getType());
        EMFHelper.updateParentContainment((EObject)algVar, (EObject)inputVar);
        this.addedInputVars.add(inputVar);
    }

    protected void postprocessContVariable(ContVariable contVar) {
        InputVariable inputVar = CifConstructors.newInputVariable();
        inputVar.setName(contVar.getName());
        inputVar.setType((CifType)CifConstructors.newRealType());
        EMFHelper.updateParentContainment((EObject)contVar, (EObject)inputVar);
        this.addedInputVars.add(inputVar);
    }

    protected void postprocessDiscVariable(DiscVariable discVar) {
        if (discVar.eContainer() instanceof ComplexComponent) {
            InputVariable inputVar = CifConstructors.newInputVariable();
            inputVar.setName(discVar.getName());
            inputVar.setType(discVar.getType());
            EMFHelper.updateParentContainment((EObject)discVar, (EObject)inputVar);
            this.addedInputVars.add(inputVar);
        }
    }

    protected void preprocessLocation(Location loc) {
        if (loc.getName() != null) {
            InputVariable inputVar = CifConstructors.newInputVariable();
            inputVar.setName(loc.getName());
            inputVar.setType((CifType)CifConstructors.newBoolType());
            Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
            aut.getDeclarations().add((Object)inputVar);
            this.addedInputVars.add(inputVar);
        }
    }

    protected void postprocessAutomaton(Automaton aut) {
        Group group = CifConstructors.newGroup();
        group.setName(aut.getName());
        group.getDeclarations().addAll((Collection)aut.getDeclarations());
        EMFHelper.updateParentContainment((EObject)aut, (EObject)group);
    }

    public static enum InterfaceKind {
        COMPLETE,
        REDUCED;

    }
}

