/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class BreakpointUtils {
    private static final String HANDLE_ID = JDIDebugUIPlugin.getUniqueIdentifier() + ".JAVA_ELEMENT_HANDLE_ID";
    private static final String RUN_TO_LINE = JDIDebugUIPlugin.getUniqueIdentifier() + ".run_to_line";
    private static final String MEMBER_START = JDIDebugUIPlugin.getUniqueIdentifier() + ".member_start";
    private static final String MEMBER_END = JDIDebugUIPlugin.getUniqueIdentifier() + ".member_end";

    public static IResource getBreakpointResource(IMember member) {
        IResource res;
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && cu.isWorkingCopy()) {
            member = (IMember)member.getPrimaryElement();
        }
        if ((res = member.getResource()) == null) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        } else if (!res.getProject().exists()) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        }
        return res;
    }

    public static IType getType(IJavaBreakpoint breakpoint) {
        IJavaElement je;
        String handle = breakpoint.getMarker().getAttribute(HANDLE_ID, null);
        if (handle != null && (je = JavaCore.create((String)handle)) != null) {
            if (je instanceof IType) {
                return (IType)je;
            }
            if (je instanceof IMember) {
                return ((IMember)je).getDeclaringType();
            }
        }
        return null;
    }

    public static IMember getMember(IJavaLineBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof IJavaMethodBreakpoint) {
            return BreakpointUtils.getMethod((IJavaMethodBreakpoint)breakpoint);
        }
        if (breakpoint instanceof IJavaWatchpoint) {
            return BreakpointUtils.getField((IJavaWatchpoint)breakpoint);
        }
        int start = breakpoint.getCharStart();
        int end = breakpoint.getCharEnd();
        IType type = BreakpointUtils.getType((IJavaBreakpoint)breakpoint);
        if (start == -1 && end == -1) {
            start = breakpoint.getMarker().getAttribute(MEMBER_START, -1);
            end = breakpoint.getMarker().getAttribute(MEMBER_END, -1);
        }
        IType member = null;
        if (type != null && type.exists() && end >= start && start >= 0) {
            member = BreakpointUtils.binSearch(type, start, end);
        }
        if (member == null) {
            member = type;
        }
        return member;
    }

    protected static IMember binSearch(IType type, int start, int end) throws JavaModelException {
        IJavaElement je = BreakpointUtils.getElementAt(type, start);
        if (je != null && !je.equals(type)) {
            return BreakpointUtils.asMember(je);
        }
        if (end > start) {
            je = BreakpointUtils.getElementAt(type, end);
            if (je != null && !je.equals(type)) {
                return BreakpointUtils.asMember(je);
            }
            int mid = (end - start) / 2 + start;
            if (mid > start) {
                je = BreakpointUtils.binSearch(type, start + 1, mid);
                if (je == null) {
                    je = BreakpointUtils.binSearch(type, mid + 1, end - 1);
                }
                return BreakpointUtils.asMember(je);
            }
        }
        return null;
    }

    private static IMember asMember(IJavaElement element) {
        if (element instanceof IMember) {
            return (IMember)element;
        }
        return null;
    }

    protected static IJavaElement getElementAt(IType type, int pos) throws JavaModelException {
        if (type.isBinary()) {
            return type.getClassFile().getElementAt(pos);
        }
        return type.getCompilationUnit().getElementAt(pos);
    }

    public static void addJavaBreakpointAttributes(Map<String, Object> attributes, IJavaElement element) {
        String handleId = element.getHandleIdentifier();
        attributes.put(HANDLE_ID, handleId);
        JavaCore.addJavaElementMarkerAttributes(attributes, (IJavaElement)element);
    }

    public static void addJavaBreakpointAttributesWithMemberDetails(Map<String, Object> attributes, IJavaElement element, int memberStart, int memberEnd) {
        BreakpointUtils.addJavaBreakpointAttributes(attributes, element);
        attributes.put(MEMBER_START, memberStart);
        attributes.put(MEMBER_END, memberEnd);
    }

    public static void addRunToLineAttributes(Map<String, Object> attributes) {
        attributes.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
        attributes.put(RUN_TO_LINE, Boolean.TRUE);
    }

    public static IMethod getMethod(IJavaMethodBreakpoint breakpoint) {
        IJavaElement je;
        String handle = breakpoint.getMarker().getAttribute(HANDLE_ID, null);
        if (handle != null && (je = JavaCore.create((String)handle)) != null && je instanceof IMethod) {
            return (IMethod)je;
        }
        return null;
    }

    public static IField getField(IJavaWatchpoint breakpoint) {
        IJavaElement je;
        String handle = breakpoint.getMarker().getAttribute(HANDLE_ID, null);
        if (handle != null && (je = JavaCore.create((String)handle)) != null && je instanceof IField) {
            return (IField)je;
        }
        return null;
    }

    public static boolean isRunToLineBreakpoint(IJavaLineBreakpoint breakpoint) {
        return breakpoint.getMarker().getAttribute(RUN_TO_LINE, false);
    }

    public static boolean isProblemBreakpoint(IBreakpoint breakpoint) {
        return breakpoint == JavaDebugOptionsManager.getDefault().getSuspendOnCompilationErrorBreakpoint() || breakpoint == JavaDebugOptionsManager.getDefault().getSuspendOnUncaughtExceptionBreakpoint();
    }

    public static IBreakpoint getBreakpointFromEditor(ITextEditor editor, IVerticalRulerInfo info) {
        IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int line;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != info.getLineOfLastMouseButtonActivity() || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

