/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DiscVariablePostChecker {
    private final CifPostCheckEnv env;

    public DiscVariablePostChecker(CifPostCheckEnv env) {
        this.env = env;
    }

    public void check(Specification spec) {
        for (Automaton aut : (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)Lists.list())) {
            this.check(aut);
        }
    }

    private void check(Automaton aut) {
        List discVars = (List)CifCollectUtils.collectDiscVariables((ComplexComponent)aut, (Collection)Lists.list());
        if (discVars.isEmpty()) {
            return;
        }
        Predicate<DiscVariable> hasSingleInitValue = v -> v.getValue() == null || v.getValue().getValues().size() == 1;
        List<DiscVariable> varsToConsider = discVars.stream().filter(hasSingleInitValue).toList();
        if (varsToConsider.isEmpty()) {
            return;
        }
        Map varInfos = Maps.mapc((int)varsToConsider.size());
        List typeFuncs = Lists.listc((int)0);
        for (DiscVariable discVar : varsToConsider) {
            Expression initialValue = discVar.getValue() == null ? CifValueUtils.getDefaultValue((CifType)discVar.getType(), (List)typeFuncs) : (Expression)discVar.getValue().getValues().get(0);
            varInfos.put(discVar, new VarInfo(initialValue));
        }
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                for (Update update : edge.getUpdates()) {
                    this.processUpdate(update, varInfos);
                }
            }
        }
        for (Map.Entry entry : varInfos.entrySet()) {
            DiscVariable discVar = (DiscVariable)entry.getKey();
            VarInfo varInfo = (VarInfo)entry.getValue();
            if (varInfo.isAssignedOtherValue) continue;
            String reasonTxt = varInfo.isAssignedItself && varInfo.isAssignedInitialValue ? "it is only ever assigned itself or its initial value" : (varInfo.isAssignedItself ? "it is only ever assigned itself" : (varInfo.isAssignedInitialValue ? "it is only ever assigned its initial value" : "it is never assigned"));
            this.env.addProblem(ErrMsg.DISC_VAR_EFFECTIVELY_CONSTANT, discVar.getPosition(), CifTextUtils.getAbsName((PositionObject)discVar), reasonTxt);
        }
    }

    private void processUpdate(Update update, Map<DiscVariable, VarInfo> varInfos) {
        if (update instanceof Assignment) {
            Assignment assignment = (Assignment)update;
            this.processAssignment(assignment.getAddressable(), assignment.getValue(), varInfos);
        } else if (update instanceof IfUpdate) {
            IfUpdate ifUpdate = (IfUpdate)update;
            for (Update thenUpdate : ifUpdate.getThens()) {
                this.processUpdate(thenUpdate, varInfos);
            }
            for (ElifUpdate elifUpdate : ifUpdate.getElifs()) {
                for (Update thenUpdate : elifUpdate.getThens()) {
                    this.processUpdate(thenUpdate, varInfos);
                }
            }
            for (Update elseUpdate : ifUpdate.getElses()) {
                this.processUpdate(elseUpdate, varInfos);
            }
        } else {
            throw new AssertionError((Object)("Unknown update: " + String.valueOf(update)));
        }
    }

    private void processAssignment(Expression addressable, Expression value, Map<DiscVariable, VarInfo> varInfos) {
        DiscVariableExpression discVarAddr;
        DiscVariable discVar;
        VarInfo varInfo;
        while (addressable instanceof ProjectionExpression) {
            ProjectionExpression projAddr = (ProjectionExpression)addressable;
            addressable = projAddr.getChild();
            value = null;
        }
        if (addressable instanceof ContVariableExpression) {
            return;
        }
        if (addressable instanceof InputVariableExpression) {
            return;
        }
        if (addressable instanceof TupleExpression) {
            TupleExpression tupleAddr = (TupleExpression)addressable;
            for (Expression fieldAddr : tupleAddr.getFields()) {
                this.processAssignment(fieldAddr, null, varInfos);
            }
        } else if (addressable instanceof DiscVariableExpression && (varInfo = varInfos.get(discVar = (discVarAddr = (DiscVariableExpression)addressable).getVariable())) != null && !varInfo.isAssignedOtherValue) {
            DiscVariableExpression valueRef;
            if (value == null) {
                varInfo.isAssignedOtherValue = true;
            } else if (value instanceof DiscVariableExpression && (valueRef = (DiscVariableExpression)value).getVariable() == discVar) {
                varInfo.isAssignedItself = true;
            } else if (CifValueUtils.areStructurallySameExpression((Expression)varInfo.initialValue, (Expression)value).booleanValue()) {
                varInfo.isAssignedInitialValue = true;
            } else {
                varInfo.isAssignedOtherValue = true;
            }
        }
    }

    private static class VarInfo {
        final Expression initialValue;
        boolean isAssignedItself = false;
        boolean isAssignedInitialValue = false;
        boolean isAssignedOtherValue = false;

        VarInfo(Expression initialValue) {
            this.initialValue = initialValue;
        }
    }
}

