/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeEventImpl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.ACompDecl;
import org.eclipse.escet.cif.parser.ast.ADecl;
import org.eclipse.escet.cif.parser.ast.AEquation;
import org.eclipse.escet.cif.parser.ast.automata.AAlphabetDecl;
import org.eclipse.escet.cif.parser.ast.automata.AAutomatonBody;
import org.eclipse.escet.cif.parser.ast.automata.AEdgeEvent;
import org.eclipse.escet.cif.parser.ast.automata.AEdgeLocationElement;
import org.eclipse.escet.cif.parser.ast.automata.AEquationLocationElement;
import org.eclipse.escet.cif.parser.ast.automata.AInitialLocationElement;
import org.eclipse.escet.cif.parser.ast.automata.AInvariantLocationElement;
import org.eclipse.escet.cif.parser.ast.automata.ALocation;
import org.eclipse.escet.cif.parser.ast.automata.ALocationElement;
import org.eclipse.escet.cif.parser.ast.automata.AMarkedLocationElement;
import org.eclipse.escet.cif.parser.ast.automata.AMonitorDecl;
import org.eclipse.escet.cif.parser.ast.automata.AUpdate;
import org.eclipse.escet.cif.parser.ast.automata.AUrgentLocationElement;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.parser.ast.tokens.AName;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifUpdateTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.ExprContext;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.declwrap.EventDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EventParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.LocationDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.LocationParamDeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class AutScope
extends ParentScope<Automaton> {
    private static final ExprContext EVT_REF_CTXT = ExprContext.DEFAULT_CTXT.add(ExprContext.Condition.ALLOW_EVENT);
    private final ACompDecl autDecl;
    private final List<ALocation> astLocs;

    public AutScope(Automaton obj, ACompDecl autDecl, ParentScope<?> parent, CifTypeChecker tchecker) {
        super(obj, parent, tchecker);
        this.autDecl = autDecl;
        this.astLocs = ((AAutomatonBody)autDecl.body).locations;
    }

    @Override
    protected String getScopeTypeName() {
        return "aut";
    }

    @Override
    protected ComplexComponent getComplexComponent() {
        return (ComplexComponent)this.obj;
    }

    @Override
    protected Group getGroup() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ComponentDef getComponentDef() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Automaton getAutomaton() {
        return (Automaton)this.obj;
    }

    @Override
    public List<ALocation> getAstLocs() {
        return this.astLocs;
    }

    @Override
    public void addChildScope(SymbolScope<?> scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isSubScope() {
        return true;
    }

    @Override
    protected boolean isRootScope() {
        return false;
    }

    @Override
    public String getName() {
        return ((Automaton)this.obj).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.obj);
    }

    @Override
    public String getAbsText() {
        return Strings.fmt((String)"automaton \"%s\"", (Object[])new Object[]{this.getAbsName()});
    }

    @Override
    protected void tcheckScopeFull() {
        AutScope.typeCheckAutomaton((AAutomatonBody)this.autDecl.body, (Automaton)this.obj, this, this.tchecker);
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.astAnnotations, this, this.tchecker);
        ((Automaton)this.obj).getAnnotations().addAll(annos);
    }

    public static void typeCheckAutomaton(AAutomatonBody astBody, Automaton mmAut, ParentScope<?> autScope, CifTypeChecker tchecker) {
        int alphabetCount = 0;
        AAlphabetDecl astAlpha = null;
        for (ADecl decl : astBody.decls) {
            if (!(decl instanceof AAlphabetDecl)) continue;
            if (++alphabetCount > 1) {
                tchecker.addProblem(ErrMsg.AUT_DUPL_ALPHABET, astAlpha.position, CifTextUtils.getAbsName((PositionObject)mmAut));
                tchecker.addProblem(ErrMsg.AUT_DUPL_ALPHABET, decl.position, CifTextUtils.getAbsName((PositionObject)mmAut));
                throw new SemanticException();
            }
            List events = ((AAlphabetDecl)decl).events;
            if (events == null) {
                events = Lists.list();
            }
            astAlpha = (AAlphabetDecl)decl;
            Alphabet alpha = CifConstructors.newAlphabet();
            alpha.setPosition(astAlpha.createPosition());
            mmAut.setAlphabet(alpha);
            for (AName event1 : events) {
                EventParameter param;
                Event event2;
                SymbolTableEntry entry = autScope.resolve(event1.position, event1.name, tchecker, autScope);
                if (entry instanceof EventDeclWrap) {
                    event2 = (Event)((EventDeclWrap)entry).getObject();
                    param = null;
                } else if (entry instanceof EventParamDeclWrap) {
                    param = (EventParameter)((EventParamDeclWrap)entry).getObject();
                    event2 = param.getEvent();
                } else {
                    tchecker.addProblem(ErrMsg.RESOLVE_NON_EVENT, event1.position, entry.getAbsName());
                    throw new SemanticException();
                }
                if (param != null && !CifEventUtils.eventParamSupportsSync((EventParameter)param)) {
                    tchecker.addProblem(ErrMsg.ALPHABET_NON_SYNC_PARAM, event1.position, CifTextUtils.getAbsName((PositionObject)event2), CifTextUtils.getAbsName((PositionObject)mmAut));
                    throw new SemanticException();
                }
                Expression eventExpr = autScope.resolveAsExpr(event1.name, event1.position, "", tchecker);
                alpha.getEvents().add((Object)eventExpr);
            }
        }
        int monitorCount = 0;
        AMonitorDecl astMonitor = null;
        for (ADecl decl : astBody.decls) {
            if (!(decl instanceof AMonitorDecl)) continue;
            if (++monitorCount > 1) {
                tchecker.addProblem(ErrMsg.AUT_DUPL_MONITOR, astMonitor.position, CifTextUtils.getAbsName((PositionObject)mmAut));
                tchecker.addProblem(ErrMsg.AUT_DUPL_MONITOR, decl.position, CifTextUtils.getAbsName((PositionObject)mmAut));
                throw new SemanticException();
            }
            astMonitor = (AMonitorDecl)decl;
            Monitors mmMonitors = CifConstructors.newMonitors();
            mmMonitors.setPosition(astMonitor.createPosition());
            mmAut.setMonitors(mmMonitors);
            for (AName event1 : astMonitor.events) {
                SymbolTableEntry entry = autScope.resolve(event1.position, event1.name, tchecker, autScope);
                if (!(entry instanceof EventDeclWrap) && !(entry instanceof EventParamDeclWrap)) {
                    tchecker.addProblem(ErrMsg.RESOLVE_NON_EVENT, event1.position, entry.getAbsName());
                    throw new SemanticException();
                }
                Expression eventExpr = autScope.resolveAsExpr(event1.name, event1.position, "", tchecker);
                mmMonitors.getEvents().add((Object)eventExpr);
            }
        }
        int i = 0;
        while (i < astBody.locations.size()) {
            ALocation loc1 = (ALocation)astBody.locations.get(i);
            if (loc1.name == null && mmAut.getLocations().size() != 1) {
                tchecker.addProblem(ErrMsg.NAMELESS_LOC_NOT_ALONE, loc1.position, CifTextUtils.getAbsName((PositionObject)mmAut));
                throw new SemanticException();
            }
            Location loc2 = (Location)mmAut.getLocations().get(i);
            AutScope.typeCheckLocation(loc1, loc2, autScope, tchecker);
            ++i;
        }
        Set initialLocs = CifLocationUtils.getPossibleInitialLocs((Automaton)mmAut, (boolean)false);
        if (initialLocs.isEmpty()) {
            tchecker.addProblem(ErrMsg.AUT_NO_INIT_LOC, mmAut.getPosition(), CifTextUtils.getAbsName((PositionObject)mmAut));
        }
        if (mmAut.getLocations().size() > 1) {
            Set<Location> unreachables = AutScope.getUnreachableLocs(mmAut, initialLocs);
            for (Location loc : unreachables) {
                tchecker.addProblem(ErrMsg.LOC_UNREACHABLE, loc.getPosition(), loc.getName(), CifTextUtils.getAbsName((PositionObject)mmAut));
            }
        }
    }

    private static void typeCheckLocation(ALocation astLoc, Location mmLoc, ParentScope<?> autScope, CifTypeChecker tchecker) {
        if (astLoc.name == null) {
            List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(astLoc.annotations, autScope, tchecker);
            mmLoc.getAnnotations().addAll(annos);
        }
        if (astLoc.elements == null) {
            return;
        }
        TextPosition urgPos = null;
        for (ALocationElement elem : astLoc.elements) {
            CifType nt;
            CifType t;
            Expression pred2;
            Object pred;
            BoolType type;
            List preds;
            if (elem instanceof AInitialLocationElement) {
                preds = ((AInitialLocationElement)elem).preds;
                if (preds == null) {
                    type = CifConstructors.newBoolType();
                    type.setPosition(elem.createPosition());
                    pred = CifConstructors.newBoolExpression();
                    pred.setValue(true);
                    pred.setPosition(elem.createPosition());
                    pred.setType((CifType)type);
                    mmLoc.getInitials().add(pred);
                    continue;
                }
                for (AExpression pred3 : preds) {
                    pred2 = CifExprsTypeChecker.transExpression(pred3, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, autScope, null, tchecker);
                    t = pred2.getType();
                    nt = CifTypeUtils.normalizeType((CifType)t);
                    if (!(nt instanceof BoolType)) {
                        tchecker.addProblem(ErrMsg.INIT_NON_BOOL, pred3.position, CifTextUtils.typeToStr((CifType)t));
                        continue;
                    }
                    mmLoc.getInitials().add((Object)pred2);
                }
                continue;
            }
            if (elem instanceof AInvariantLocationElement) continue;
            if (elem instanceof AEquationLocationElement) {
                if (autScope.mmEquations == null) continue;
                List eqns = ((AEquationLocationElement)elem).equations;
                for (AEquation astEqn : eqns) {
                    Equation eqn = autScope.mmEquations.get(astEqn);
                    if (eqn != null) {
                        mmLoc.getEquations().add((Object)eqn);
                        continue;
                    }
                    tchecker.addProblem(ErrMsg.EQN_VAR_NOT_IN_SCOPE, astEqn.position, astEqn.variable.id, autScope.getAbsText());
                }
                continue;
            }
            if (elem instanceof AMarkedLocationElement) {
                preds = ((AMarkedLocationElement)elem).preds;
                if (preds == null) {
                    type = CifConstructors.newBoolType();
                    type.setPosition(elem.createPosition());
                    pred = CifConstructors.newBoolExpression();
                    pred.setValue(true);
                    pred.setPosition(elem.createPosition());
                    pred.setType((CifType)type);
                    mmLoc.getMarkeds().add(pred);
                    continue;
                }
                for (AExpression pred3 : preds) {
                    pred2 = CifExprsTypeChecker.transExpression(pred3, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, autScope, null, tchecker);
                    mmLoc.getMarkeds().add((Object)pred2);
                    t = pred2.getType();
                    nt = CifTypeUtils.normalizeType((CifType)t);
                    if (nt instanceof BoolType) continue;
                    tchecker.addProblem(ErrMsg.MARKED_NON_BOOL, pred3.position, CifTextUtils.typeToStr((CifType)t));
                }
                continue;
            }
            if (elem instanceof AUrgentLocationElement) {
                mmLoc.setUrgent(true);
                if (urgPos == null) {
                    urgPos = elem.position;
                    continue;
                }
                String locTxt = CifTextUtils.getLocationText2((Location)mmLoc);
                tchecker.addProblem(ErrMsg.LOC_DUPL_URGENT, urgPos, locTxt);
                tchecker.addProblem(ErrMsg.LOC_DUPL_URGENT, elem.position, locTxt);
                continue;
            }
            if (elem instanceof AEdgeLocationElement) continue;
            throw new RuntimeException("Unknown loc elem: " + String.valueOf(elem));
        }
        for (ALocationElement elem : astLoc.elements) {
            if (!(elem instanceof AEdgeLocationElement)) continue;
            AutScope.typeCheckEdge(mmLoc, (AEdgeLocationElement)elem, autScope, tchecker);
        }
    }

    private static void typeCheckEdge(Location loc, AEdgeLocationElement astEdge, ParentScope<?> autScope, CifTypeChecker tchecker) {
        Event event;
        Edge edge = CifConstructors.newEdge();
        edge.setPosition(astEdge.createPosition());
        loc.getEdges().add((Object)edge);
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(astEdge.annotations, autScope, tchecker);
        edge.getAnnotations().addAll(annos);
        edge.setUrgent(astEdge.coreEdge.urgentPos != null);
        if (loc.isUrgent() && edge.isUrgent()) {
            String locTxt = CifTextUtils.getLocationText2((Location)loc);
            tchecker.addProblem(ErrMsg.EDGE_URG_LOC_URG, astEdge.coreEdge.urgentPos, locTxt);
        }
        Location targetLoc = null;
        if (astEdge.target != null) {
            SymbolTableEntry entry = autScope.resolve(astEdge.target.position, astEdge.target.id, tchecker, null);
            if (entry instanceof LocationDeclWrap) {
                targetLoc = (Location)((LocationDeclWrap)entry).getObject();
            } else if (entry instanceof LocationParamDeclWrap) {
                tchecker.addProblem(ErrMsg.EDGE_TGT_LOC_PARAM, astEdge.target.position, entry.getAbsName(), autScope.getAbsName());
            } else {
                tchecker.addProblem(ErrMsg.EDGE_NON_LOC_TARGET, astEdge.target.position, entry.getAbsName());
                throw new SemanticException();
            }
            edge.setTarget(targetLoc);
        }
        if (targetLoc != null) {
            Automaton tgtLocAut;
            Automaton srcLocAut = (Automaton)loc.eContainer();
            Assert.check((srcLocAut == (tgtLocAut = (Automaton)targetLoc.eContainer()) ? 1 : 0) != 0);
        }
        EList guards = edge.getGuards();
        for (AExpression g : astEdge.coreEdge.guards) {
            Expression guard = CifExprsTypeChecker.transExpression(g, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, autScope, null, tchecker);
            CifType t = guard.getType();
            CifType nt = CifTypeUtils.normalizeType((CifType)t);
            if (!(nt instanceof BoolType)) {
                tchecker.addProblem(ErrMsg.GUARD_NON_BOOL, guard.getPosition(), CifTextUtils.typeToStr((CifType)t));
            }
            guards.add(guard);
        }
        boolean hasReceive = false;
        boolean hasNonReceive = false;
        for (AEdgeEvent astEdgeEvent : astEdge.coreEdge.events) {
            boolean isComm;
            String absName;
            AExpression astEventRef = astEdgeEvent.eventRef;
            Iterator eventRef = CifExprsTypeChecker.transExpression(astEventRef, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, autScope, EVT_REF_CTXT, tchecker);
            Expression uEventRef = CifTypeUtils.unwrapExpression((Expression)eventRef);
            EventParameter param = null;
            if (uEventRef instanceof TauExpression) {
                event = null;
                absName = "tau";
            } else if (uEventRef instanceof EventExpression) {
                event = ((EventExpression)uEventRef).getEvent();
                absName = CifTextUtils.getAbsName((PositionObject)event);
                if (event.eContainer() instanceof EventParameter) {
                    param = (EventParameter)event.eContainer();
                }
            } else {
                PositionObject evt = CifScopeUtils.getRefObjFromRef((Expression)uEventRef);
                tchecker.addProblem(ErrMsg.RESOLVE_NON_EVENT, astEventRef.position, CifTextUtils.getAbsName((PositionObject)evt));
                throw new SemanticException();
            }
            CifType eventType = null;
            if (event != null) {
                eventType = event.getType();
            }
            boolean isChannel = eventType != null;
            boolean isVoid = eventType instanceof VoidType;
            AEdgeEvent.Direction direction = astEdgeEvent.direction;
            boolean bl = isComm = direction != AEdgeEvent.Direction.NONE;
            if (direction == AEdgeEvent.Direction.RECEIVE) {
                hasReceive = true;
            } else {
                hasNonReceive = true;
            }
            if (isComm && !isChannel) {
                String dirTxt = direction == AEdgeEvent.Direction.SEND ? "send" : "receive";
                tchecker.addProblem(ErrMsg.CHANNEL_COMM_NON_CHAN, astEdgeEvent.position, dirTxt, absName);
                throw new SemanticException();
            }
            if (param != null) {
                String problem = null;
                switch (direction) {
                    case SEND: {
                        if (CifEventUtils.eventParamSupportsSend((EventParameter)param)) break;
                        problem = "send (!)";
                        break;
                    }
                    case RECEIVE: {
                        if (CifEventUtils.eventParamSupportsRecv((EventParameter)param)) break;
                        problem = "receive (?)";
                        break;
                    }
                    case NONE: {
                        if (CifEventUtils.eventParamSupportsSync((EventParameter)param)) break;
                        problem = "synchronization (~)";
                    }
                }
                if (problem != null) {
                    tchecker.addProblem(ErrMsg.EDGE_EVT_PARAM_ILLEGAL_USE, astEdgeEvent.position, absName, problem);
                }
            }
            boolean valueMandatory = direction == AEdgeEvent.Direction.SEND && isChannel && !isVoid;
            boolean valueForbidden = direction != AEdgeEvent.Direction.SEND || !isChannel || isVoid;
            Expression value = null;
            if (astEdgeEvent.value != null) {
                if (valueForbidden) {
                    Assert.check((isChannel && isVoid ? 1 : 0) != 0);
                    tchecker.addProblem(ErrMsg.CHANNEL_VOID_WITH_VALUE, astEdgeEvent.position, absName);
                } else {
                    value = CifExprsTypeChecker.transExpression(astEdgeEvent.value, eventType, autScope, null, tchecker);
                    CifType valueType = value.getType();
                    if (!CifTypeUtils.checkTypeCompat((CifType)eventType, (CifType)valueType, (RangeCompat)RangeCompat.CONTAINED)) {
                        tchecker.addProblem(ErrMsg.CHANNEL_SEND_TYPE_MISMATCH, astEdgeEvent.position, CifTextUtils.typeToStr((CifType)valueType), absName, CifTextUtils.typeToStr((CifType)eventType));
                    }
                }
            } else if (valueMandatory) {
                tchecker.addProblem(ErrMsg.CHANNEL_NON_VOID_NEED_VALUE, astEdgeEvent.position, absName, CifTextUtils.typeToStr((CifType)eventType));
            }
            EdgeEvent edgeEvent = null;
            switch (direction) {
                case NONE: {
                    edgeEvent = CifConstructors.newEdgeEvent();
                    break;
                }
                case SEND: {
                    edgeEvent = CifConstructors.newEdgeSend();
                    break;
                }
                case RECEIVE: {
                    edgeEvent = CifConstructors.newEdgeReceive();
                }
            }
            edgeEvent.setPosition(astEdgeEvent.createPosition());
            edgeEvent.setEvent((Expression)eventRef);
            if (direction == AEdgeEvent.Direction.SEND) {
                ((EdgeSend)edgeEvent).setValue(value);
            }
            edge.getEvents().add((Object)edgeEvent);
        }
        if (hasReceive && hasNonReceive) {
            for (EdgeEvent edgeEvent : edge.getEvents()) {
                if (edgeEvent instanceof EdgeReceive) continue;
                if (edgeEvent instanceof EdgeSend) {
                    tchecker.addProblem(ErrMsg.EDGE_RCV_EXPECTED, edgeEvent.getPosition(), "Sending over a channel");
                    continue;
                }
                Assert.check((edgeEvent.getClass() == EdgeEventImpl.class ? 1 : 0) != 0);
                tchecker.addProblem(ErrMsg.EDGE_RCV_EXPECTED, edgeEvent.getPosition(), "Synchronizing over an event");
            }
        }
        CifType channelType = null;
        Position firstReceivePos = null;
        if (hasReceive) {
            for (EdgeEvent edgeEvent : edge.getEvents()) {
                Expression eventRef;
                if (!(edgeEvent instanceof EdgeReceive) || (eventRef = edgeEvent.getEvent()) instanceof TauExpression) continue;
                eventRef = CifTypeUtils.unwrapExpression((Expression)eventRef);
                event = ((EventExpression)eventRef).getEvent();
                CifType eventType = event.getType();
                if (channelType == null) {
                    channelType = eventType;
                    firstReceivePos = edgeEvent.getPosition();
                    continue;
                }
                if (CifTypeUtils.checkTypeCompat((CifType)channelType, (CifType)eventType, (RangeCompat)RangeCompat.EQUAL)) continue;
                tchecker.addProblem(ErrMsg.CHANNEL_RCVS_TYPE_MISMATCH, firstReceivePos, CifTextUtils.typeToStr((CifType)channelType), CifTextUtils.typeToStr((CifType)eventType));
                tchecker.addProblem(ErrMsg.CHANNEL_RCVS_TYPE_MISMATCH, edgeEvent.getPosition(), CifTextUtils.typeToStr((CifType)channelType), CifTextUtils.typeToStr((CifType)eventType));
            }
        }
        ExprContext context = ExprContext.DEFAULT_CTXT;
        if (hasReceive) {
            context = context.setReceiveType(channelType);
        }
        EList updates = edge.getUpdates();
        for (AUpdate update1 : astEdge.coreEdge.updates) {
            Update update2 = CifUpdateTypeChecker.typeCheckUpdate(update1, autScope, context, tchecker);
            updates.add(update2);
        }
    }

    private static Set<Location> getUnreachableLocs(Automaton aut, Set<Location> initialLocs) {
        Set unreachables = Sets.list2set((List)aut.getLocations());
        unreachables.removeAll(initialLocs);
        ArrayDeque<Location> queue = new ArrayDeque<Location>(initialLocs);
        while (!queue.isEmpty()) {
            Location loc = (Location)queue.pop();
            for (Edge edge : loc.getEdges()) {
                boolean todo;
                Location target = edge.getTarget();
                if (target == null || !(todo = unreachables.remove(target))) continue;
                queue.add(target);
            }
        }
        return unreachables;
    }
}

